/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFOA;
import org.eclipse.swt.internal.win32.NMTTDISPINFOW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class Composite
extends Scrollable {
    Layout layout;
    int font;
    WINDOWPOS[] lpwp;
    Control[] tabList;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    /*
     * Unable to fully structure code
     */
    Control[] _getChildren() {
        count = 0;
        hwndChild = OS.GetWindow(this.handle, 5);
        if (hwndChild != 0) ** GOTO lbl7
        return new Control[0];
lbl-1000:
        // 1 sources

        {
            ++count;
            hwndChild = OS.GetWindow(hwndChild, 2);
lbl7:
            // 2 sources

            ** while (hwndChild != 0)
        }
lbl8:
        // 1 sources

        children = new Control[count];
        index = 0;
        hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0) {
            control = this.display.getControl(hwndChild);
            if (control != null && control != this) {
                children[index++] = control;
            }
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        if (count == index) {
            return children;
        }
        newChildren = new Control[index];
        System.arraycopy(children, 0, newChildren, 0, index);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x1000;
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int count = 0;
        int hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0) {
            ++count;
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        return count;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.setResizeChildren(false);
        this.layout.layout(this, changed);
        this.setResizeChildren(true);
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseChildren();
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
        this.lpwp = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
        this.resizeChildren();
    }

    void resizeChildren() {
        if (this.lpwp == null) {
            return;
        }
        do {
            WINDOWPOS[] currentLpwp = this.lpwp;
            this.lpwp = null;
            if (this.resizeChildren(true, currentLpwp)) continue;
            this.resizeChildren(false, currentLpwp);
        } while (this.lpwp != null);
    }

    boolean resizeChildren(boolean defer, WINDOWPOS[] pwp) {
        if (pwp == null) {
            return true;
        }
        int hdwp = 0;
        if (defer && (hdwp = OS.BeginDeferWindowPos(pwp.length)) == 0) {
            return false;
        }
        int i = 0;
        while (i < pwp.length) {
            WINDOWPOS wp = pwp[i];
            if (wp != null) {
                if (defer) {
                    if ((hdwp = OS.DeferWindowPos(hdwp, wp.hwnd, 0, wp.x, wp.y, wp.cx, wp.cy, wp.flags)) == 0) {
                        return false;
                    }
                } else {
                    OS.SetWindowPos(wp.hwnd, 0, wp.x, wp.y, wp.cx, wp.cy, wp.flags);
                }
            }
            ++i;
        }
        if (defer) {
            return OS.EndDeferWindowPos(hdwp);
        }
        return true;
    }

    public boolean setFocus() {
        Control child;
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.setFocus()) {
                return true;
            }
            ++i;
        }
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void setResizeChildren(boolean resize) {
        if (resize) {
            this.resizeChildren();
        } else {
            int count = this.getChildrenCount();
            if (count > 1 && this.lpwp == null) {
                this.lpwp = new WINDOWPOS[count];
            }
        }
    }

    boolean setTabGroupFocus() {
        Control child;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus && this.setTabItemFocus()) {
                return true;
            }
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.isTabItem() && child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean setTabItemFocus() {
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus) {
                if (!this.isShowing()) {
                    return false;
                }
                if (this.forceFocus()) {
                    return true;
                }
            }
        }
        return super.setTabItemFocus();
    }

    String toolTipText(NMTTDISPINFO hdr) {
        if ((hdr.uFlags & 1) == 0) {
            return null;
        }
        int hwnd = hdr.idFrom;
        if (hwnd == 0) {
            return null;
        }
        Control control = this.display.getControl(hwnd);
        if (control == null) {
            return null;
        }
        return control.toolTipText;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void updateFont(Font oldFont, Font newFont) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (!control.isDisposed()) {
                control.updateFont(oldFont, newFont);
            }
            ++i;
        }
        super.updateFont(oldFont, newFont);
        this.layout(true);
    }

    int widgetStyle() {
        return super.widgetStyle() | 0x2000000;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 0x1000) != 0 && (this.style & 0x40000) != 0) {
            return LRESULT.ONE;
        }
        return result;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 0x1000) != 0) {
            if ((this.style & 0x80000) != 0) {
                return new LRESULT(256);
            }
            if (this.hooksKeys()) {
                int flags = 7;
                return new LRESULT(flags);
            }
            int count = this.getChildrenCount();
            if (count != 0) {
                return new LRESULT(256);
            }
        }
        return result;
    }

    LRESULT WM_GETFONT(int wParam, int lParam) {
        LRESULT result = super.WM_GETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        int code = this.callWindowProc(49, wParam, lParam);
        if (code != 0) {
            return new LRESULT(code);
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if ((this.state & 0x1000) != 0) {
            if ((this.style & 0x80000) != 0) {
                return result;
            }
            if (OS.GetWindow(this.handle, 5) == 0) {
                this.setFocus();
            }
        }
        return result;
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        if (!OS.IsWinCE) {
            NMHDR hdr = new NMHDR();
            OS.MoveMemory(hdr, lParam, 12);
            switch (hdr.code) {
                case -522: 
                case -521: {
                    this.display.lockActiveWindow = true;
                    int flags = 19;
                    int hwndInsertAfter = hdr.code == -521 ? -1 : -2;
                    OS.SetWindowPos(hdr.hwndFrom, hwndInsertAfter, 0, 0, 0, 0, flags);
                    this.display.lockActiveWindow = false;
                    break;
                }
                case -530: 
                case -520: {
                    Control control;
                    NMTTDISPINFO lpnmtdi;
                    if (hdr.code == -520) {
                        lpnmtdi = new NMTTDISPINFOA();
                        OS.MoveMemory(lpnmtdi, lParam, 108);
                    } else {
                        lpnmtdi = new NMTTDISPINFOW();
                        OS.MoveMemory((NMTTDISPINFOW)lpnmtdi, lParam, 188);
                    }
                    String string = this.toolTipText(lpnmtdi);
                    if (string == null) break;
                    Shell shell = this.getShell();
                    string = Display.withCrLf(string);
                    int length = string.length();
                    char[] chars = new char[length + 1];
                    string.getChars(0, length, chars, 0);
                    int hwnd = hdr.idFrom;
                    if (hwnd != 0 && (lpnmtdi.uFlags & 1) != 0 && (control = this.display.getControl(hwnd)) != null) {
                        lpnmtdi.uFlags = (control.getStyle() & 0x4000000) != 0 ? (lpnmtdi.uFlags |= 4) : (lpnmtdi.uFlags &= 0xFFFFFFFB);
                    }
                    if (hdr.code == -520) {
                        byte[] bytes = new byte[chars.length * 2];
                        OS.WideCharToMultiByte(0, 0, chars, chars.length, bytes, bytes.length, null, null);
                        shell.setToolTipText(lpnmtdi, bytes);
                        OS.MoveMemory(lParam, lpnmtdi, 108);
                    } else {
                        shell.setToolTipText(lpnmtdi, chars);
                        OS.MoveMemory(lParam, (NMTTDISPINFOW)lpnmtdi, 188);
                    }
                    return LRESULT.ZERO;
                }
            }
        }
        return super.WM_NOTIFY(wParam, lParam);
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        if ((this.state & 0x1000) == 0) {
            return super.WM_PAINT(wParam, lParam);
        }
        int oldBits = 0;
        int newBits = 0;
        if (!OS.IsWinCE && (newBits = (oldBits = OS.GetWindowLong(this.handle, -16)) | 0x4000000 | 0x2000000) != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
        }
        PAINTSTRUCT ps = new PAINTSTRUCT();
        if (this.hooks(9)) {
            int[] lpRgnData = null;
            boolean isComplex = false;
            boolean exposeRegion = false;
            if ((this.style & 0x200000) != 0) {
                int rgn = OS.CreateRectRgn(0, 0, 0, 0);
                boolean bl = isComplex = OS.GetUpdateRgn(this.handle, rgn, false) == 3;
                if (isComplex) {
                    int nBytes = OS.GetRegionData(rgn, 0, null);
                    exposeRegion = OS.GetRegionData(rgn, nBytes, lpRgnData = new int[nBytes / 4]) != 0;
                }
                OS.DeleteObject(rgn);
            }
            GCData data = new GCData();
            data.ps = ps;
            GC gc = GC.win32_new(this, data);
            int hDC = gc.handle;
            Event event = new Event();
            event.gc = gc;
            if (isComplex && exposeRegion) {
                RECT rect = new RECT();
                int count = lpRgnData[2];
                int i = 0;
                while (i < count) {
                    OS.SetRect(rect, lpRgnData[8 + (i << 2)], lpRgnData[8 + (i << 2) + 1], lpRgnData[8 + (i << 2) + 2], lpRgnData[8 + (i << 2) + 3]);
                    if ((this.style & 0x40000) == 0) {
                        this.drawBackground(hDC, rect);
                    }
                    event.x = rect.left;
                    event.y = rect.top;
                    event.width = rect.right - rect.left;
                    event.height = rect.bottom - rect.top;
                    event.count = count - 1 - i;
                    this.sendEvent(9, event);
                    if (!this.isDisposed()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                if ((this.style & 0x40000) == 0) {
                    RECT rect = new RECT();
                    OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                    this.drawBackground(hDC, rect);
                }
                event.x = ps.left;
                event.y = ps.top;
                event.width = ps.right - ps.left;
                event.height = ps.bottom - ps.top;
                this.sendEvent(9, event);
            }
            event.gc = null;
            gc.dispose();
        } else {
            int hDC = OS.BeginPaint(this.handle, ps);
            if ((this.style & 0x40000) == 0) {
                RECT rect = new RECT();
                OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                this.drawBackground(hDC, rect);
            }
            OS.EndPaint(this.handle, ps);
        }
        if (!OS.IsWinCE && newBits != oldBits && !this.isDisposed()) {
            OS.SetWindowLong(this.handle, -16, oldBits);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 0x1000) != 0) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            if ((this.style & 0x40000) == 0) {
                this.drawBackground(wParam, rect);
            }
            GCData data = new GCData();
            data.device = this.display;
            GC gc = GC.win32_new(wParam, data);
            Event event = new Event();
            event.gc = gc;
            event.x = rect.left;
            event.y = rect.top;
            event.width = rect.right - rect.left;
            event.height = rect.bottom - rect.top;
            this.sendEvent(9, event);
            event.gc = null;
            gc.dispose();
        }
        return result;
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        this.font = wParam;
        return super.WM_SETFONT(this.font, lParam);
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int hwndChild;
        int threadId;
        this.setResizeChildren(false);
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if (this.layout != null) {
            this.layout.layout(this, false);
        }
        this.setResizeChildren(true);
        if ((this.state & 0x1000) != 0 && (this.style & 0x100000) == 0 && this.hooks(9)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if ((this.state & 0x1000) != 0 && (this.style & 0x1000000) != 0 && (threadId = OS.GetWindowThreadProcessId(hwndChild = OS.GetWindow(this.handle, 5), null)) != OS.GetCurrentThreadId()) {
            if (this.display.msgHook == 0 && !OS.IsWinCE) {
                this.display.getMsgCallback = new Callback(this.display, "getMsgProc", 3);
                this.display.getMsgProc = this.display.getMsgCallback.getAddress();
                if (this.display.getMsgProc == 0) {
                    this.error(3);
                }
                this.display.msgHook = OS.SetWindowsHookEx(3, this.display.getMsgProc, OS.GetLibraryHandle(), threadId);
            }
            OS.PostThreadMessage(threadId, 32772, hwndChild, lParam);
        }
        return result;
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            int hwndChild = children[i].handle;
            OS.SendMessage(hwndChild, 21, 0, 0);
            ++i;
        }
        return null;
    }

    LRESULT WM_SYSCOMMAND(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOMMAND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((wParam & 0xF000) == 0) {
            return result;
        }
        if (!OS.IsWinCE) {
            int cmd = wParam & 0xFFF0;
            switch (cmd) {
                case 61552: 
                case 61568: {
                    boolean showHBar = this.horizontalBar != null && this.horizontalBar.getVisible();
                    boolean showVBar = this.verticalBar != null && this.verticalBar.getVisible();
                    int code = this.callWindowProc(274, wParam, lParam);
                    if (showHBar != (this.horizontalBar != null && this.horizontalBar.getVisible()) || showVBar != (this.verticalBar != null && this.verticalBar.getVisible())) {
                        int flags = 1281;
                        OS.RedrawWindow(this.handle, null, 0, flags);
                    }
                    if (code == 0) {
                        return LRESULT.ZERO;
                    }
                    return new LRESULT(code);
                }
            }
        }
        return result;
    }
}

