/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    boolean noSelection;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, lpWndClass);
        ComboProc = lpWndClass.lpfnWndProc;
    }

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        TCHAR buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((result = OS.SendMessage(this.handle, 323, 0, buffer = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (result == -2) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        TCHAR buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if ((result = OS.SendMessage(this.handle, 330, index, buffer = new TCHAR(this.getCodePage(), string, true))) == -2 || result == -1) {
            this.error(14);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ComboProc, this.handle, msg, wParam, lParam);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int tmInternalLeading = 0;
        if (wHint == -1) {
            int oldFont = 0;
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            int count = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rect = new RECT();
            int flags = 3072;
            if ((this.style & 8) == 0) {
                flags |= 0x2000;
            }
            int length = OS.GetWindowTextLength(this.handle);
            int cp = this.getCodePage();
            TCHAR buffer = new TCHAR(cp, length + 1);
            OS.GetWindowText(this.handle, buffer, length + 1);
            OS.DrawText(hDC, buffer, length, rect, flags);
            width = Math.max(width, rect.right - rect.left);
            int i = 0;
            while (i < count) {
                length = OS.SendMessage(this.handle, 329, i, 0);
                if (length != -1) {
                    int result;
                    if (length + 1 > buffer.length()) {
                        buffer = new TCHAR(cp, length + 1);
                    }
                    if ((result = OS.SendMessage(this.handle, 328, i, buffer)) != -1) {
                        OS.DrawText(hDC, buffer, length, rect, flags);
                        width = Math.max(width, rect.right - rect.left);
                    }
                }
                ++i;
            }
            if ((this.style & 8) != 0) {
                TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(hDC, tm);
                tmInternalLeading = tm.tmInternalLeading;
            }
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (hHint == -1 && (this.style & 0x40) != 0) {
            int count = OS.SendMessage(this.handle, 326, 0, 0);
            int itemHeight = OS.SendMessage(this.handle, 340, 0, 0);
            height = count * itemHeight;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if ((this.style & 8) != 0) {
            width += tmInternalLeading * 2;
        } else {
            int hwndText = OS.GetDlgItem(this.handle, 1001);
            if (hwndText != 0) {
                int margins = OS.SendMessage(hwndText, 212, 0, 0);
                int marginWidth = (margins & 0xFFFF) + (margins >> 16 & 0xFFFF);
                width += marginWidth + 3;
            }
        }
        int border = OS.GetSystemMetrics(45);
        int textHeight = OS.SendMessage(this.handle, 340, -1, 0);
        height = (this.style & 4) != 0 ? textHeight + 6 : (height += textHeight + 10);
        return new Point(width += OS.GetSystemMetrics(2) + border * 2, height);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createHandle() {
        int hwndList;
        super.createHandle();
        this.state &= 0xFFFFEFFF;
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLong(hwndText, -4);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLong(hwndList, -4);
        }
        if ((this.style & 0x40) != 0) {
            int flags = 52;
            OS.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, flags);
            OS.SetWindowPos(this.handle, 0, 0, 0, 0, 0, flags);
        }
    }

    public void cut() {
        this.checkWidget();
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        int hwndList;
        super.deregister();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            this.display.removeControl(hwndText);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(hwndList);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        int selection = OS.SendMessage(this.handle, 327, 0, 0);
        if (index != selection) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    boolean getEditable() {
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0xF) == 3;
    }

    public String getItem(int index) {
        TCHAR buffer;
        int result;
        this.checkWidget();
        int length = OS.SendMessage(this.handle, 329, index, 0);
        if (length != -1 && (result = OS.SendMessage(this.handle, 328, index, buffer = new TCHAR(this.getCodePage(), length + 1))) != -1) {
            return buffer.toString(0, length);
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index >= 0 && index < count) {
            this.error(8);
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (count == -1) {
            this.error(36);
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = OS.SendMessage(this.handle, 340, 0, 0);
        if (result == -1) {
            this.error(11);
        }
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 320, start, end);
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    public int getTextHeight() {
        this.checkWidget();
        int result = OS.SendMessage(this.handle, 340, -1, 0);
        if (result == -1) {
            this.error(11);
        }
        return result + 6;
    }

    public int getTextLimit() {
        this.checkWidget();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText == 0) {
            return LIMIT;
        }
        return OS.SendMessage(hwndText, 213, 0, 0);
    }

    boolean hasFocus() {
        int hwndFocus = OS.GetFocus();
        if (hwndFocus == this.handle) {
            return true;
        }
        if (hwndFocus == 0) {
            return false;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndFocus == hwndText) {
            return true;
        }
        int hwndList = OS.GetDlgItem(this.handle, 1000);
        return hwndFocus == hwndList;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int count = this.getItemCount();
            int i = start;
            while (i < count) {
                if (string.equals(this.getItem(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (start < 0 || start >= count) {
            return -1;
        }
        int index = start - 1;
        int last = 0;
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((index = OS.SendMessage(this.handle, 344, last = index, buffer)) != -1 && index > last) continue;
            return -1;
        } while (!string.equals(this.getItem(index)));
        return index;
    }

    public void paste() {
        this.checkWidget();
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    void register() {
        int hwndList;
        super.register();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            this.display.addControl(hwndText, this);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(hwndList, this);
        }
    }

    public void remove(int index) {
        int count;
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        int code = OS.SendMessage(this.handle, 324, index, 0);
        if (code == -1) {
            count = OS.SendMessage(this.handle, 326, 0, 0);
            if (index >= 0 && index < count) {
                this.error(15);
            }
            this.error(6);
        }
        if (length != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (count = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int length = OS.GetWindowTextLength(this.handle);
        int i = start;
        while (i <= end) {
            int result = OS.SendMessage(this.handle, 324, start, 0);
            if (result == -1) {
                this.error(15);
            }
            ++i;
        }
        if (length != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (count = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
    }

    public void remove(String string) {
        int index = this.indexOf(string, 0);
        if (index == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index >= 0 && index < count) {
            int selection = OS.SendMessage(this.handle, 327, 0, 0);
            int code = OS.SendMessage(this.handle, 334, index, 0);
            if (code != -1 && code != selection) {
                this.sendEvent(24);
            }
        }
    }

    void setBackgroundPixel(int pixel) {
        int hwndList;
        if (this.background == pixel) {
            return;
        }
        super.setBackgroundPixel(pixel);
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.InvalidateRect(hwndText, null, true);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(hwndList, null, true);
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if ((this.style & 4) != 0) {
            int textHeight = OS.SendMessage(this.handle, 340, -1, 0);
            int itemHeight = OS.SendMessage(this.handle, 340, 0, 0);
            height = textHeight + 6 + itemHeight * 5 + 2;
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            if (rect.right - rect.left != 0 && OS.SendMessage(this.handle, 338, 0, rect) != 0) {
                int oldWidth = rect.right - rect.left;
                int oldHeight = rect.bottom - rect.top;
                if (oldWidth == width && oldHeight == height) {
                    flags |= 1;
                }
            }
            OS.SetWindowPos(this.handle, 0, x, y, width, height, flags);
            return;
        }
        if (this.parent.lpwp != null || (flags & 1) != 0 || !OS.IsWindowVisible(this.handle)) {
            super.setBounds(x, y, width, height, flags);
            return;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        super.setBounds(x, y, width, height, flags);
        int oldWidth = rect.right - rect.left;
        int oldHeight = rect.bottom - rect.top;
        if (oldWidth != width || oldHeight != height) {
            if (OS.IsWinCE) {
                int hwndList;
                int hwndText = OS.GetDlgItem(this.handle, 1001);
                if (hwndText != 0) {
                    OS.InvalidateRect(hwndText, null, true);
                }
                if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
                    OS.InvalidateRect(hwndList, null, true);
                }
            } else {
                int uFlags = 133;
                OS.RedrawWindow(this.handle, null, 0, uFlags);
            }
        }
    }

    void setEditable(boolean editable) {
        this.error(20);
    }

    void setForegroundPixel(int pixel) {
        int hwndList;
        if (this.foreground == pixel) {
            return;
        }
        super.setForegroundPixel(pixel);
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.InvalidateRect(hwndText, null, true);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(hwndList, null, true);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.remove(index);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, index);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int codePage = this.getCodePage();
        int i = 0;
        while (i < items.length) {
            String string = items[i];
            TCHAR buffer = new TCHAR(codePage, string, true);
            int code = OS.SendMessage(this.handle, 323, 0, buffer);
            if (code == -1) {
                this.error(14);
            }
            if (code == -2) {
                this.error(14);
            }
            ++i;
        }
        this.sendEvent(24);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        int bits = OS.GetWindowLong(this.handle, -20);
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
            bits |= 0x400000;
        } else {
            this.style &= 0xF7FFFFFF;
            bits &= 0xFFBFFFFF;
        }
        OS.SetWindowLong(this.handle, -20, bits);
        int hwndText = 0;
        int hwndList = 0;
        COMBOBOXINFO pcbi = new COMBOBOXINFO();
        pcbi.cbSize = 52;
        if (OS.GetComboBoxInfo(this.handle, pcbi)) {
            hwndText = pcbi.hwndItem;
            hwndList = pcbi.hwndList;
        }
        if (hwndText != 0) {
            int bits0 = OS.GetWindowLong(hwndText, -20);
            int bits1 = OS.GetWindowLong(hwndText, -16);
            if ((this.style & 0x4000000) != 0) {
                bits0 |= 0x3000;
                bits1 |= 2;
            } else {
                bits0 &= 0xFFFFCFFF;
                bits1 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(hwndText, -20, bits0);
            OS.SetWindowLong(hwndText, -16, bits1);
            RECT rect = new RECT();
            OS.GetWindowRect(hwndText, rect);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            OS.GetWindowRect(this.handle, rect);
            int widthCombo = rect.right - rect.left;
            int heightCombo = rect.bottom - rect.top;
            int uFlags = 22;
            OS.SetWindowPos(hwndText, 0, 0, 0, width - 1, height - 1, uFlags);
            OS.SetWindowPos(this.handle, 0, 0, 0, widthCombo - 1, heightCombo - 1, uFlags);
            OS.SetWindowPos(hwndText, 0, 0, 0, width, height, uFlags);
            OS.SetWindowPos(this.handle, 0, 0, 0, widthCombo, heightCombo, uFlags);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (hwndList != 0) {
            int exStyle = OS.GetWindowLong(hwndList, -20);
            exStyle = (this.style & 0x4000000) != 0 ? (exStyle |= 0x400000) : (exStyle &= 0xFFBFFFFF);
            OS.SetWindowLong(hwndList, -20, exStyle);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        int bits = selection.x | selection.y << 16;
        OS.SendMessage(this.handle, 322, 0, bits);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
            return;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        if (OS.SetWindowText(this.handle, buffer)) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 321, limit, 0);
    }

    void subclass() {
        int hwndList;
        super.subclass();
        int newProc = this.display.windowProc;
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.SetWindowLong(hwndText, -4, newProc);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLong(hwndList, -4, newProc);
        }
    }

    boolean translateTraversal(MSG msg) {
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0 && msg.hwnd == hwndText) {
            switch (msg.wParam) {
                case 27: {
                    if (OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                    return false;
                }
            }
        }
        return super.translateTraversal(msg);
    }

    boolean traverseEscape() {
        if (OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    void unsubclass() {
        int hwndList;
        super.unsubclass();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0 && EditProc != 0) {
            OS.SetWindowLong(hwndText, -4, EditProc);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLong(hwndList, -4, ListProc);
        }
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40 | 0x400 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return bits | 1;
        }
        if ((this.style & 8) != 0) {
            return bits | 3;
        }
        return bits | 2;
    }

    TCHAR windowClass() {
        return ComboClass;
    }

    int windowProc() {
        return ComboProc;
    }

    int windowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        if (hwnd != this.handle) {
            int hwndText = OS.GetDlgItem(this.handle, 1001);
            int hwndList = OS.GetDlgItem(this.handle, 1000);
            if (hwndText != 0 && hwnd == hwndText || hwndList != 0 && hwnd == hwndList) {
                LRESULT result = null;
                switch (msg) {
                    case 258: {
                        result = this.WM_CHAR(wParam, lParam);
                        break;
                    }
                    case 646: {
                        result = this.WM_IME_CHAR(wParam, lParam);
                        break;
                    }
                    case 256: {
                        result = this.WM_KEYDOWN(wParam, lParam);
                        break;
                    }
                    case 257: {
                        result = this.WM_KEYUP(wParam, lParam);
                        break;
                    }
                    case 262: {
                        result = this.WM_SYSCHAR(wParam, lParam);
                        break;
                    }
                    case 260: {
                        result = this.WM_SYSKEYDOWN(wParam, lParam);
                        break;
                    }
                    case 261: {
                        result = this.WM_SYSKEYUP(wParam, lParam);
                        break;
                    }
                    case 123: {
                        result = this.WM_CONTEXTMENU(this.handle, lParam);
                    }
                }
                if (result != null) {
                    return result.value;
                }
                int windowProc = hwnd == hwndText ? EditProc : ListProc;
                return OS.CallWindowProc(windowProc, hwnd, msg, wParam, lParam);
            }
        }
        return super.windowProc(hwnd, msg, wParam, lParam);
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 13: {
                this.postEvent(14);
            }
            case 9: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_CTLCOLOR(int wParam, int lParam) {
        return this.wmColorChild(wParam, lParam);
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        int code = this.callWindowProc(135, wParam, lParam);
        return new LRESULT(code | 1);
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int length;
        if ((this.style & 8) != 0 || (this.style & 4) == 0) {
            return super.WM_SIZE(wParam, lParam);
        }
        int index = OS.SendMessage(this.handle, 327, 0, 0);
        boolean redraw = false;
        TCHAR buffer = null;
        int[] start = null;
        int[] end = null;
        if (index == -1 && (length = OS.GetWindowTextLength(this.handle)) != 0) {
            buffer = new TCHAR(this.getCodePage(), length + 1);
            OS.GetWindowText(this.handle, buffer, length + 1);
            start = new int[1];
            end = new int[1];
            OS.SendMessage(this.handle, 320, start, end);
            boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            if (redraw) {
                this.setRedraw(false);
            }
        }
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if (buffer != null) {
            OS.SetWindowText(this.handle, buffer);
            int bits = start[0] | end[0] << 16;
            OS.SendMessage(this.handle, 322, 0, bits);
            if (redraw) {
                this.setRedraw(true);
            }
        }
        return result;
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        int code = wParam >> 16;
        switch (code) {
            case 5: {
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int index = OS.SendMessage(this.handle, 327, 0, 0);
                if (index != -1) {
                    OS.SendMessage(this.handle, 334, index, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.postEvent(13);
                break;
            }
            case 3: 
            case 4: {
                this.sendFocusEvent(code == 3 ? 15 : 16, -1);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(wParam, lParam);
    }
}

