/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Program {
    String name;
    String command;
    String iconName;

    Program() {
    }

    public static Program findProgram(String extension) {
        int[] phkResult;
        TCHAR key;
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, key = new TCHAR(0, extension, true), 0, 131097, phkResult = new int[1]) != 0) {
            return null;
        }
        int[] lpcbData = new int[]{256};
        TCHAR lpData = new TCHAR(0, lpcbData[0]);
        int result = OS.RegQueryValueEx(phkResult[0], null, 0, null, lpData, lpcbData);
        OS.RegCloseKey(phkResult[0]);
        if (result != 0) {
            return null;
        }
        return Program.getProgram(lpData.toString(0, lpData.strlen()));
    }

    public static String[] getExtensions() {
        String[] extensions = new String[1024];
        TCHAR lpName = new TCHAR(0, 1024);
        int[] lpcName = new int[]{lpName.length()};
        FILETIME ft = new FILETIME();
        int dwIndex = 0;
        int count = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, dwIndex, lpName, lpcName, null, null, null, ft) != 259) {
            String extension = lpName.toString(0, lpcName[0]);
            lpcName[0] = lpName.length();
            if (extension.length() > 0 && extension.charAt(0) == '.') {
                if (count == extensions.length) {
                    String[] newExtensions = new String[extensions.length + 1024];
                    System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
                    extensions = newExtensions;
                }
                extensions[count++] = extension;
            }
            ++dwIndex;
        }
        if (count != extensions.length) {
            String[] newExtension = new String[count];
            System.arraycopy(extensions, 0, newExtension, 0, count);
            extensions = newExtension;
        }
        return extensions;
    }

    static String getKeyValue(String string, boolean expand) {
        TCHAR key = new TCHAR(0, string, true);
        int[] phkResult = new int[1];
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, key, 0, 131097, phkResult) != 0) {
            return null;
        }
        String result = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx(phkResult[0], null, 0, null, null, lpcbData) == 0) {
            int length = lpcbData[0] / TCHAR.sizeof;
            if (length == 0) {
                result = "";
            } else {
                TCHAR lpData = new TCHAR(0, length);
                if (OS.RegQueryValueEx(phkResult[0], null, 0, null, lpData, lpcbData) == 0) {
                    if (!OS.IsWinCE && expand) {
                        int nSize = OS.ExpandEnvironmentStrings(lpData, null, 0);
                        TCHAR lpDst = new TCHAR(0, nSize);
                        OS.ExpandEnvironmentStrings(lpData, lpDst, nSize);
                        result = lpDst.toString(0, Math.max(0, nSize - 1));
                    } else {
                        length = Math.max(0, lpData.length() - 1);
                        result = lpData.toString(0, length);
                    }
                }
            }
        }
        if (phkResult[0] != 0) {
            OS.RegCloseKey(phkResult[0]);
        }
        return result;
    }

    static Program getProgram(String key) {
        String name = Program.getKeyValue(key, false);
        if (name == null || name.length() == 0) {
            return null;
        }
        String COMMAND = "\\shell\\open\\command";
        String command = Program.getKeyValue(String.valueOf(key) + COMMAND, true);
        if (command == null || command.length() == 0) {
            return null;
        }
        String DEFAULT_ICON = "\\DefaultIcon";
        String iconName = Program.getKeyValue(String.valueOf(key) + DEFAULT_ICON, true);
        if (iconName == null || iconName.length() == 0) {
            return null;
        }
        Program program = new Program();
        program.name = name;
        program.command = command;
        program.iconName = iconName;
        return program;
    }

    public static Program[] getPrograms() {
        Program[] programs = new Program[1024];
        TCHAR lpName = new TCHAR(0, 1024);
        int[] lpcName = new int[]{lpName.length()};
        FILETIME ft = new FILETIME();
        int dwIndex = 0;
        int count = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, dwIndex, lpName, lpcName, null, null, null, ft) != 259) {
            String path = lpName.toString(0, lpcName[0]);
            lpcName[0] = lpName.length();
            Program program = Program.getProgram(path);
            if (program != null) {
                if (count == programs.length) {
                    Program[] newPrograms = new Program[programs.length + 1024];
                    System.arraycopy(programs, 0, newPrograms, 0, programs.length);
                    programs = newPrograms;
                }
                programs[count++] = program;
            }
            ++dwIndex;
        }
        if (count != programs.length) {
            Program[] newPrograms = new Program[count];
            System.arraycopy(programs, 0, newPrograms, 0, count);
            programs = newPrograms;
        }
        return programs;
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer1 = new TCHAR(0, "open", true);
        int byteCount1 = buffer1.length() * TCHAR.sizeof;
        int lpVerb = OS.HeapAlloc(hHeap, 8, byteCount1);
        OS.MoveMemory(lpVerb, buffer1, byteCount1);
        TCHAR buffer2 = new TCHAR(0, fileName, true);
        int byteCount2 = buffer2.length() * TCHAR.sizeof;
        int lpFile = OS.HeapAlloc(hHeap, 8, byteCount2);
        OS.MoveMemory(lpFile, buffer2, byteCount2);
        SHELLEXECUTEINFO info = new SHELLEXECUTEINFO();
        info.cbSize = 60;
        info.lpVerb = lpVerb;
        info.lpFile = lpFile;
        info.nShow = 5;
        boolean result = OS.ShellExecuteEx(info);
        if (lpVerb != 0) {
            OS.HeapFree(hHeap, 0, lpVerb);
        }
        if (lpFile != 0) {
            OS.HeapFree(hHeap, 0, lpFile);
        }
        return result;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        boolean quote = true;
        String prefix = this.command;
        String suffix = "";
        int index = this.command.indexOf("%1");
        if (index != -1) {
            int count = 0;
            int i = index + 2;
            int length = this.command.length();
            while (i < length) {
                if (this.command.charAt(i) == '\"') {
                    ++count;
                }
                ++i;
            }
            quote = count % 2 == 0;
            prefix = this.command.substring(0, index);
            suffix = this.command.substring(index + 2, length);
        }
        if (quote) {
            fileName = " \"" + fileName + "\"";
        }
        try {
            Compatibility.exec(String.valueOf(prefix) + fileName + suffix);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public ImageData getImageData() {
        int nIconIndex = 0;
        String fileName = this.iconName;
        int index = this.iconName.indexOf(44);
        if (index != -1) {
            fileName = this.iconName.substring(0, index);
            String iconIndex = this.iconName.substring(index + 1, this.iconName.length()).trim();
            try {
                nIconIndex = Integer.parseInt(iconIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        TCHAR lpszFile = new TCHAR(0, fileName, true);
        int[] phiconSmall = new int[1];
        int[] phiconLarge = null;
        OS.ExtractIconEx(lpszFile, nIconIndex, phiconLarge, phiconSmall, 1);
        if (phiconSmall[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, 1, phiconSmall[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

