/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table table;
    int row;
    int column;
    Listener tableListener;
    Listener resizeListener;

    public TableCursor(Table parent, int style) {
        super(parent, style);
        ScrollBar vBar;
        this.table = parent;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableCursor.this.dispose(event);
                        break;
                    }
                    case 1: {
                        TableCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TableCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TableCursor.this.traverse(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TableCursor.this.redraw();
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(1, listener);
        this.addListener(9, listener);
        this.addListener(31, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TableCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this.table.addListener(15, this.tableListener);
        this.table.addListener(3, this.tableListener);
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.resize();
            }
        };
        int columns = this.table.getColumnCount();
        int i = 0;
        while (i < columns) {
            TableColumn column = this.table.getColumn(i);
            column.addListener(11, this.resizeListener);
            ++i;
        }
        ScrollBar hBar = this.table.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void dispose(Event event) {
        Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ScrollBar vBar;
                if (TableCursor.this.table.isDisposed()) {
                    return;
                }
                TableCursor.this.table.removeListener(15, TableCursor.this.tableListener);
                TableCursor.this.table.removeListener(3, TableCursor.this.tableListener);
                int columns = TableCursor.this.table.getColumnCount();
                int i = 0;
                while (i < columns) {
                    TableColumn column = TableCursor.this.table.getColumn(i);
                    column.removeListener(11, TableCursor.this.resizeListener);
                    ++i;
                }
                ScrollBar hBar = TableCursor.this.table.getHorizontalBar();
                if (hBar != null) {
                    hBar.removeListener(13, TableCursor.this.resizeListener);
                }
                if ((vBar = TableCursor.this.table.getVerticalBar()) != null) {
                    vBar.removeListener(13, TableCursor.this.resizeListener);
                }
            }
        });
    }

    void keyDown(Event event) {
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.setRowColumn(this.row - 1, this.column, true);
                break;
            }
            case 0x1000002: {
                this.setRowColumn(this.row + 1, this.column, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int leadKey;
                int n = leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == leadKey) {
                    this.setRowColumn(this.row, this.column - 1, true);
                    break;
                }
                this.setRowColumn(this.row, this.column + 1, true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(0, this.column, true);
                break;
            }
            case 0x1000008: {
                int row = this.table.getItemCount() - 1;
                this.setRowColumn(row, this.column, true);
                break;
            }
            case 0x1000005: {
                int index = this.table.getTopIndex();
                if (index == this.row) {
                    Rectangle rect = this.table.getClientArea();
                    TableItem item = this.table.getItem(index);
                    Rectangle itemRect = item.getBounds(0);
                    rect.height -= itemRect.y;
                    int height = this.table.getItemHeight();
                    int page = Math.max(1, rect.height / height);
                    index = Math.max(0, index - page + 1);
                }
                this.setRowColumn(index, this.column, true);
                break;
            }
            case 0x1000006: {
                int index = this.table.getTopIndex();
                Rectangle rect = this.table.getClientArea();
                TableItem item = this.table.getItem(index);
                Rectangle itemRect = item.getBounds(0);
                rect.height -= itemRect.y;
                int height = this.table.getItemHeight();
                int page = Math.max(1, rect.height / height);
                int end = this.table.getItemCount() - 1;
                index = Math.min(end, index + page - 1);
                if (index == this.row) {
                    index = Math.min(end, index + page - 1);
                }
                this.setRowColumn(index, this.column, true);
            }
        }
    }

    void paint(Event event) {
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(27));
        gc.setForeground(display.getSystemColor(26));
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        TableItem item = this.table.getItem(this.row);
        int x = 0;
        int y = 0;
        Point size = this.getSize();
        Image image = item.getImage(this.column);
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = y + (int)((double)((float)size.y - (float)imageSize.height) / 2.0);
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        int n = this.column == 0 ? 2 : 6;
        int textY = y + (int)((double)((float)size.y - (float)gc.getFontMetrics().getHeight()) / 2.0);
        gc.drawString(item.getText(this.column), x += n, textY);
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        Rectangle clientRect = this.table.getClientArea();
        int columns = this.table.getColumnCount();
        int start = this.table.getTopIndex();
        int end = this.table.getItemCount();
        int row = start;
        while (row < end) {
            TableItem item = this.table.getItem(row);
            int column = 0;
            while (column < columns) {
                Rectangle rect = item.getBounds(column);
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                if (rect.contains(pt)) {
                    this.setRowColumn(row, column, true);
                    this.setFocus();
                    return;
                }
                ++column;
            }
            ++row;
        }
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    void setRowColumn(int row, int column, boolean notify) {
        if (row >= 0 && row < this.table.getItemCount() && column >= 0 && column < this.table.getColumnCount()) {
            this.row = row;
            this.column = column;
            TableItem item = this.table.getItem(row);
            this.table.showItem(item);
            this.setBounds(item.getBounds(column));
            this.redraw();
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this.resize();
        }
        super.setVisible(visible);
    }

    void resize() {
        TableItem item = this.table.getItem(this.row);
        this.setBounds(item.getBounds(this.column));
    }

    public int getColumn() {
        this.checkWidget();
        return this.column;
    }

    public TableItem getRow() {
        this.checkWidget();
        return this.table.getItem(this.row);
    }

    public void setSelection(int row, int column) {
        this.checkWidget();
        if (row < 0 || row >= this.table.getItemCount() || column < 0 || column >= this.table.getColumnCount()) {
            SWT.error(5);
        }
        this.setRowColumn(row, column, false);
    }

    public void setSelection(TableItem row, int column) {
        this.checkWidget();
        if (row == null || row.isDisposed() || column < 0 || column >= this.table.getColumnCount()) {
            SWT.error(5);
        }
        this.setRowColumn(this.table.indexOf(row), column, false);
    }
}

