/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder2;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class CTabItem2
extends Item {
    CTabFolder2 parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    Image disabledImage;
    String shortenedText;
    int shortenedTextWidth;
    static final int LEFT_MARGIN = 6;
    static final int RIGHT_MARGIN = 6;
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int INTERNAL_SPACING = 2;
    static final int FLAGS = 9;
    static final String ellipsis = "...";

    public CTabItem2(CTabFolder2 parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public CTabItem2(CTabFolder2 parent, int style, int index) {
        super(parent, CTabItem2.checkStyle(style));
        parent.createItem(this, index);
    }

    static int checkStyle(int style) {
        return 0;
    }

    static String shortenText(GC gc, String text, int width) {
        if (gc.textExtent((String)text, (int)9).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipsis, (int)9).x;
        int length = text.length();
        int end = length - 1;
        while (end > 0) {
            text = text.substring(0, end);
            int l1 = gc.textExtent((String)text, (int)9).x;
            if (l1 + ellipseWidth <= width) {
                return String.valueOf(text) + ellipsis;
            }
            --end;
        }
        return String.valueOf(text) + ellipsis;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
    }

    void drawSelected(GC gc) {
        int i;
        int temp;
        int i2;
        int index;
        int[] right;
        int[] left;
        int rightTabEdge = this.parent.getSize().x - this.parent.borderRight - this.parent.chevronRect.width - this.parent.expandRect.width - this.parent.closeRect.width - 1;
        if (rightTabEdge <= this.x) {
            return;
        }
        int extra = 25;
        int[] shape = null;
        if (this.parent.onBottom) {
            left = CTabFolder2.BOTTOM_LEFT_CORNER;
            right = this.parent.curve;
            shape = new int[left.length + right.length + 6];
            index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y - 1;
            i2 = 0;
            while (i2 < left.length / 2) {
                shape[index++] = this.x + left[2 * i2];
                shape[index++] = this.y + this.height + left[2 * i2 + 1] - 1;
                ++i2;
            }
            i2 = 0;
            while (i2 < right.length / 2) {
                shape[index++] = this.x + this.width - extra + right[2 * i2];
                shape[index++] = this.y + right[2 * i2 + 1] - 1;
                ++i2;
            }
            temp = 0;
            i = 0;
            while (i < shape.length / 2) {
                if (shape[2 * i] > rightTabEdge) {
                    temp = temp == 0 && i > 0 ? shape[2 * i - 1] : this.y - 1;
                    shape[2 * i] = rightTabEdge;
                    shape[2 * i + 1] = temp;
                }
                ++i;
            }
            shape[index++] = rightTabEdge;
            shape[index++] = this.y - 1;
            shape[index++] = this.x + this.width + extra;
            shape[index++] = this.y - 1;
        } else {
            left = CTabFolder2.TOP_LEFT_CORNER;
            right = this.parent.curve;
            shape = new int[left.length + right.length + 6];
            index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y + this.height;
            i2 = 0;
            while (i2 < left.length / 2) {
                shape[index++] = this.x + left[2 * i2];
                shape[index++] = this.y + left[2 * i2 + 1];
                ++i2;
            }
            i2 = 0;
            while (i2 < right.length / 2) {
                shape[index++] = this.x + this.width - extra + right[2 * i2];
                shape[index++] = this.y + right[2 * i2 + 1];
                ++i2;
            }
            temp = 0;
            i = 0;
            while (i < shape.length / 2) {
                if (shape[2 * i] > rightTabEdge) {
                    temp = temp == 0 && i > 0 ? shape[2 * i - 1] : this.y + this.height + 1;
                    shape[2 * i] = rightTabEdge;
                    shape[2 * i + 1] = temp;
                }
                ++i;
            }
            shape[index++] = rightTabEdge;
            shape[index++] = this.y + this.height + 1;
            shape[index++] = this.x + this.width + extra;
            shape[index++] = this.y + this.height + 1;
        }
        this.parent.drawSelectionBackground(gc, shape);
        Region r = new Region();
        r.add(new Rectangle(this.x, this.y, this.width, this.height));
        r.subtract(shape);
        if (this.parent.single) {
            gc.setBackground(this.parent.getBackground());
        } else {
            gc.setBackground(this.parent.getParent().getBackground());
        }
        CTabFolder2.fillRegion(gc, r);
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.subtract(r);
        r.add(clipping);
        r.intersect(new Rectangle(this.x, this.y, Math.min(this.width, rightTabEdge - this.x), this.height));
        gc.setClipping(r);
        int xDraw = this.x + 6;
        Image image = this.getImage();
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            int imageX = xDraw;
            int imageHeight = imageBounds.height;
            int imageY = this.y + (this.height - imageHeight) / 2;
            int n = this.parent.onBottom ? -1 : 1;
            int imageWidth = imageBounds.width * imageHeight / imageBounds.height;
            gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY += n, imageWidth, imageHeight);
            xDraw += imageWidth + 2;
        }
        int textWidth = this.x + this.width - xDraw - 6;
        if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
            this.shortenedText = CTabItem2.shortenText(gc, this.getText(), textWidth);
            this.shortenedTextWidth = textWidth;
        }
        Point extent = gc.textExtent(this.shortenedText, 9);
        int textY = this.y + (this.height - extent.y) / 2;
        int n = this.parent.onBottom ? -1 : 1;
        gc.setForeground(this.parent.selectionForeground);
        gc.drawText(this.shortenedText, xDraw, textY += n, 9);
        if (this.parent.isFocusControl()) {
            Display display = this.getDisplay();
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(xDraw - 2, textY - 2, extent.x + 3, extent.y + 4);
        }
        gc.setClipping(clipping);
        r.dispose();
        clipping.dispose();
    }

    void drawUnselected(GC gc) {
        int index;
        int[] right;
        int[] left;
        int i;
        int index2;
        int[] right2;
        int[] left2;
        int[] shape = null;
        if (this.parent.onBottom) {
            left2 = CTabFolder2.BOTTOM_LEFT_CORNER;
            right2 = CTabFolder2.BOTTOM_RIGHT_CORNER;
            shape = new int[left2.length + right2.length + 4];
            index2 = 0;
            shape[index2++] = this.x;
            shape[index2++] = this.y;
            i = 0;
            while (i < left2.length / 2) {
                shape[index2++] = this.x + left2[2 * i];
                shape[index2++] = this.y + this.height - 1 + left2[2 * i + 1];
                ++i;
            }
            i = 0;
            while (i < right2.length / 2) {
                shape[index2++] = this.x + this.width - 3 + right2[2 * i];
                shape[index2++] = this.y + this.height - 1 + right2[2 * i + 1];
                ++i;
            }
            shape[index2++] = this.x + this.width - 3;
            shape[index2++] = this.y;
        } else {
            left2 = CTabFolder2.TOP_LEFT_CORNER;
            right2 = CTabFolder2.TOP_RIGHT_CORNER;
            shape = new int[left2.length + right2.length + 4];
            index2 = 0;
            shape[index2++] = this.x;
            shape[index2++] = this.y + this.height;
            i = 0;
            while (i < left2.length / 2) {
                shape[index2++] = this.x + left2[2 * i];
                shape[index2++] = this.y + 1 + left2[2 * i + 1];
                ++i;
            }
            i = 0;
            while (i < right2.length / 2) {
                shape[index2++] = this.x + this.width - 2 + right2[2 * i];
                shape[index2++] = this.y + 1 + right2[2 * i + 1];
                ++i;
            }
            shape[index2++] = this.x + this.width - 2;
            shape[index2++] = this.y + this.height;
        }
        gc.setBackground(this.parent.getBackground());
        gc.fillPolygon(shape);
        Region r = new Region();
        r.add(new Rectangle(this.x, this.y, this.width, this.height));
        r.subtract(shape);
        gc.setBackground(this.parent.getParent().getBackground());
        CTabFolder2.fillRegion(gc, r);
        r.dispose();
        shape = null;
        if (this.parent.onBottom) {
            left = CTabFolder2.BOTTOM_LEFT_CORNER;
            right = CTabFolder2.BOTTOM_RIGHT_CORNER;
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y;
            int i2 = 0;
            while (i2 < left.length / 2) {
                shape[index++] = this.x + left[2 * i2];
                shape[index++] = this.y + this.height - 2 + left[2 * i2 + 1];
                ++i2;
            }
            i2 = 0;
            while (i2 < right.length / 2) {
                shape[index++] = this.x + this.width - 3 + right[2 * i2];
                shape[index++] = this.y + this.height - 2 + right[2 * i2 + 1];
                ++i2;
            }
            shape[index++] = this.x + this.width - 3;
            shape[index++] = this.y - 1;
        } else {
            left = CTabFolder2.TOP_LEFT_CORNER;
            right = CTabFolder2.TOP_RIGHT_CORNER;
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y + this.height - 1;
            int i3 = 0;
            while (i3 < left.length / 2) {
                shape[index++] = this.x + left[2 * i3];
                shape[index++] = this.y + 1 + left[2 * i3 + 1];
                ++i3;
            }
            i3 = 0;
            while (i3 < right.length / 2) {
                shape[index++] = this.x + this.width - 3 + right[2 * i3];
                shape[index++] = this.y + 1 + right[2 * i3 + 1];
                ++i3;
            }
            shape[index++] = this.x + this.width - 3;
            shape[index++] = this.y + this.height;
        }
        gc.setForeground(CTabFolder2.border1Color);
        gc.drawPolyline(shape);
        int textWidth = this.width - 6 - 6;
        if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
            this.shortenedText = CTabItem2.shortenText(gc, this.getText(), textWidth);
            this.shortenedTextWidth = textWidth;
        }
        Point extent = gc.textExtent(this.shortenedText, 9);
        int textY = this.y + (this.height - extent.y) / 2;
        int n = this.parent.onBottom ? -1 : 1;
        gc.setForeground(this.parent.getForeground());
        gc.drawText(this.shortenedText, this.x + 6, textY += n, 9);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public CTabFolder2 getParent() {
        return this.parent;
    }

    public String getToolTipText() {
        String text;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(text = this.getText())) {
            return text;
        }
        return this.toolTipText;
    }

    void onPaint(GC gc, boolean isSelected) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (isSelected) {
            this.drawSelected(gc);
        } else {
            this.drawUnselected(gc);
        }
    }

    int preferredHeight(GC gc) {
        Image image = this.getImage();
        int h = image == null ? 0 : image.getBounds().height;
        String text = this.getText();
        h = Math.max(h, gc.textExtent((String)text, (int)9).y);
        return h + 2 + 2;
    }

    int preferredWidth(GC gc, boolean isSelected) {
        String text;
        int w = 0;
        Image image = this.getImage();
        if (isSelected) {
            if (image != null) {
                w += image.getBounds().width;
            }
            w += 5;
        }
        if ((text = this.getText()) != null) {
            if (isSelected && image != null) {
                w += 2;
            }
            w += gc.textExtent((String)text, (int)9).x;
        }
        return w + 6 + 6;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int index = this.parent.indexOf(this);
            if (index == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.equals(this.getDisabledImage())) {
            return;
        }
        this.disabledImage = image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.equals(this.getImage())) {
            return;
        }
        super.setImage(image);
        if (!this.parent.updateTabHeight(this.parent.tabHeight)) {
            this.parent.updateItems();
        }
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        this.parent.updateItems();
        this.parent.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

