/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolderCloseListener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderExpandListener;
import org.eclipse.swt.custom.CTabFolderListListener;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem2;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class CTabFolder2
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 3;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean fixedTabHeight;
    int tabHeight;
    CTabItem2[] items = new CTabItem2[0];
    int selectedIndex = -1;
    int topTabIndex = -1;
    CTabFolderCloseListener[] closeListeners = new CTabFolderCloseListener[0];
    CTabFolderExpandListener[] expandListeners = new CTabFolderExpandListener[0];
    CTabFolderListListener[] listListeners = new CTabFolderListListener[0];
    Image backgroundImage;
    Color[] gradientColors;
    int[] gradientPercents;
    Color selectionForeground;
    Color selectionBackground;
    static Color border1Color;
    static Color border2Color;
    static Color border3Color;
    boolean showClose = false;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 1;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showExpand = false;
    Rectangle expandRect = new Rectangle(0, 0, 0, 0);
    boolean expanded = true;
    int expandImageState = 1;
    boolean tipShowing;
    boolean showHighlight = false;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int[] curve;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    int insertionIndex = -2;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int HIGHLIGHT_HEADER = 5;
    static final int HIGHLIGHT_MARGIN = 3;
    static final int CURVE_WIDTH = 50;
    static final int CURVE_RIGHT = 30;
    static final int CURVE_LEFT = 30;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] TOP_LEFT_OUTSIDE_CORNER;
    static final int[] TOP_RIGHT_OUTSIDE_CORNER;
    static final int[] BOTTOM_LEFT_OUTSIDE_CORNER;
    static final int[] BOTTOM_RIGHT_OUTSIDE_CORNER;
    static final int SELECTION_FOREGROUND = 30;
    static final int SELECTION_BACKGROUND = 31;
    static final int BORDER1_COLOR = 18;
    static final int BORDER2_COLOR = 17;
    static final int BORDER3_COLOR = 18;
    static final int FOREGROUND = 33;
    static final int BACKGROUND = 34;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_BORDER;
    static final RGB CLOSE_FILL;
    static final RGB EXPAND_BORDER;
    static final RGB EXPAND_FILL;
    static final RGB CHEVRON_BORDER;
    static final RGB CHEVRON_FILL;

    static {
        int[] nArray = new int[14];
        nArray[1] = 5;
        nArray[2] = 1;
        nArray[3] = 4;
        nArray[4] = 1;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 1;
        nArray[10] = 4;
        nArray[11] = 1;
        nArray[12] = 5;
        TOP_LEFT_CORNER = nArray;
        int[] nArray2 = new int[14];
        nArray2[0] = -5;
        nArray2[2] = -4;
        nArray2[3] = 1;
        nArray2[4] = -3;
        nArray2[5] = 1;
        nArray2[6] = -2;
        nArray2[7] = 2;
        nArray2[8] = -1;
        nArray2[9] = 3;
        nArray2[10] = -1;
        nArray2[11] = 4;
        nArray2[13] = 5;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[18];
        nArray3[1] = -5;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -3;
        nArray3[6] = 2;
        nArray3[7] = -3;
        nArray3[8] = 2;
        nArray3[9] = -2;
        nArray3[10] = 3;
        nArray3[11] = -2;
        nArray3[12] = 3;
        nArray3[13] = -1;
        nArray3[14] = 5;
        nArray3[15] = -1;
        nArray3[16] = 5;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -5;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -5;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = 6;
        nArray5[2] = 1;
        nArray5[3] = 5;
        nArray5[4] = 1;
        nArray5[5] = 4;
        nArray5[6] = 4;
        nArray5[7] = 1;
        nArray5[8] = 5;
        nArray5[9] = 1;
        nArray5[10] = 6;
        TOP_LEFT_OUTSIDE_CORNER = nArray5;
        int[] nArray6 = new int[12];
        nArray6[0] = -6;
        nArray6[2] = -5;
        nArray6[3] = 1;
        nArray6[4] = -4;
        nArray6[5] = 1;
        nArray6[6] = -1;
        nArray6[7] = 4;
        nArray6[8] = -1;
        nArray6[9] = 5;
        nArray6[11] = 6;
        TOP_RIGHT_OUTSIDE_CORNER = nArray6;
        int[] nArray7 = new int[12];
        nArray7[1] = -6;
        nArray7[2] = 1;
        nArray7[3] = -5;
        nArray7[4] = 1;
        nArray7[5] = -4;
        nArray7[6] = 4;
        nArray7[7] = -1;
        nArray7[8] = 5;
        nArray7[9] = -1;
        nArray7[10] = 6;
        BOTTOM_LEFT_OUTSIDE_CORNER = nArray7;
        int[] nArray8 = new int[12];
        nArray8[0] = -6;
        nArray8[2] = -5;
        nArray8[3] = -1;
        nArray8[4] = -4;
        nArray8[5] = -1;
        nArray8[6] = -1;
        nArray8[7] = -4;
        nArray8[8] = -1;
        nArray8[9] = -5;
        nArray8[11] = -6;
        BOTTOM_RIGHT_OUTSIDE_CORNER = nArray8;
        CLOSE_BORDER = new RGB(221, 106, 106);
        CLOSE_FILL = new RGB(214, 195, 195);
        EXPAND_BORDER = new RGB(114, 106, 221);
        EXPAND_FILL = new RGB(199, 196, 242);
        CHEVRON_BORDER = new RGB(111, 220, 106);
        CHEVRON_FILL = new RGB(199, 242, 196);
    }

    public CTabFolder2(Composite parent, int style) {
        super(parent, CTabFolder2.checkStyle(style));
        this.onBottom = (this.getStyle() & 0x400) != 0;
        boolean bl = this.single = (style & 4) != 0;
        int n = (style & 0x800) != 0 ? ((style & 0x800000) != 0 ? 1 : 4) : (this.borderLeft = 0);
        this.borderRight = (style & 0x800) != 0 ? ((style & 0x800000) != 0 ? 1 : 6) : 0;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderRight;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(30);
        this.selectionBackground = display.getSystemColor(31);
        border1Color = display.getSystemColor(18);
        border2Color = display.getSystemColor(17);
        border3Color = display.getSystemColor(18);
        this.setForeground(display.getSystemColor(33));
        this.setBackground(display.getSystemColor(34));
        this.initAccessible();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder2.this.onDispose();
                        break;
                    }
                    case 9: {
                        CTabFolder2.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder2.this.onResize();
                        break;
                    }
                    case 8: {
                        CTabFolder2.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder2.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder2.this.onMouse(event);
                        break;
                    }
                    case 32: {
                        CTabFolder2.this.onMouseHover(event);
                        break;
                    }
                    case 5: {
                        CTabFolder2.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder2.this.onMouse(event);
                        break;
                    }
                    case 15: {
                        CTabFolder2.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder2.this.onFocus(event);
                        break;
                    }
                    case 31: {
                        CTabFolder2.this.onTraverse(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 9, 11, 8, 3, 7, 32, 5, 4, 15, 16, 1, 31};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    static int[] bezier(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3, int count) {
        double a0 = x0;
        double a1 = 3 * (x1 - x0);
        double a2 = 3 * (x0 + x2 - 2 * x1);
        double a3 = x3 - x0 + 3 * x1 - 3 * x2;
        double b0 = y0;
        double b1 = 3 * (y1 - y0);
        double b2 = 3 * (y0 + y2 - 2 * y1);
        double b3 = y3 - y0 + 3 * y1 - 3 * y2;
        int[] polygon = new int[2 * count + 2];
        int i = 0;
        while (i <= count) {
            double t = (double)i / (double)count;
            polygon[2 * i] = (int)(a0 + a1 * t + a2 * t * t + a3 * t * t * t);
            polygon[2 * i + 1] = (int)(b0 + b1 * t + b2 * t * t + b3 * t * t * t);
            ++i;
        }
        return polygon;
    }

    static int checkStyle(int style) {
        int mask = 109053062;
        if (((style &= mask) & 0x80) != 0) {
            style = style & 0xFFFFFB7F | 0x80;
        }
        if ((style & 2) != 0) {
            style = style & 0xFFFFFFF9 | 2;
        }
        return style |= 0x140000;
    }

    static void fillRegion(GC gc, Region region) {
        Region clipping = new Region();
        gc.getClipping(clipping);
        region.intersect(clipping);
        gc.setClipping(region);
        gc.fillRectangle(region.getBounds());
        gc.setClipping(clipping);
        clipping.dispose();
    }

    public void addCTabFolderCloseListener(CTabFolderCloseListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeListeners.length == 0) {
            this.showClose = true;
            this.setButtonBounds();
            this.redraw();
        }
        CTabFolderCloseListener[] newListeners = new CTabFolderCloseListener[this.closeListeners.length + 1];
        System.arraycopy(this.closeListeners, 0, newListeners, 0, this.closeListeners.length);
        this.closeListeners = newListeners;
        this.closeListeners[this.closeListeners.length - 1] = listener;
    }

    public void addCTabFolderExpandListener(CTabFolderExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.expandListeners.length == 0) {
            this.showExpand = true;
            this.updateItems();
            this.redraw();
        }
        CTabFolderExpandListener[] newListeners = new CTabFolderExpandListener[this.expandListeners.length + 1];
        System.arraycopy(this.expandListeners, 0, newListeners, 0, this.expandListeners.length);
        this.expandListeners = newListeners;
        this.expandListeners[this.expandListeners.length - 1] = listener;
    }

    public void addCTabFolderListener(CTabFolderListener listener) {
        this.addCTabFolderCloseListener(listener);
    }

    public void addCTabFolderListListener(CTabFolderListListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CTabFolderListListener[] newListeners = new CTabFolderListListener[this.listListeners.length + 1];
        System.arraycopy(this.listListeners, 0, newListeners, 0, this.listListeners.length);
        this.listListeners = newListeners;
        this.listListeners[this.listListeners.length - 1] = listener;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int minWidth = 0;
        int minHeight = 0;
        GC gc = new GC(this);
        int selectedMax = 0;
        int selectedMaxIndex = -1;
        int i = 0;
        while (i < this.items.length) {
            int width = this.items[i].preferredWidth(gc, true);
            if (width > selectedMax) {
                selectedMax = width;
                selectedMaxIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            minWidth += this.items[i].preferredWidth(gc, i == selectedMaxIndex);
            ++i;
        }
        gc.dispose();
        i = 0;
        while (i < this.items.length) {
            Control control = this.items[i].getControl();
            if (control != null && !control.isDisposed()) {
                Point size = control.computeSize(wHint, hHint);
                minWidth = Math.max(minWidth, size.x);
                minHeight = Math.max(minHeight, size.y);
            }
            ++i;
        }
        if (minWidth == 0) {
            minWidth = 64;
        }
        if (minHeight == 0) {
            minHeight = 64;
        }
        if (!this.expanded) {
            minHeight = 0;
        }
        if (wHint != -1) {
            minWidth = wHint;
        }
        if (hHint != -1) {
            minHeight = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, minWidth, minHeight);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (!this.expanded) {
            int trimX = x - this.borderLeft;
            int trimY = this.onBottom ? y - this.borderTop : y - 5 - this.tabHeight - this.borderTop;
            int trimWidth = width + this.borderLeft + this.borderRight;
            int trimHeight = this.borderTop + this.borderBottom + this.tabHeight + 5;
            return new Rectangle(trimX, trimY, trimWidth, trimHeight);
        }
        int trimX = x - this.marginWidth - this.borderLeft;
        int trimY = this.onBottom ? y - this.marginHeight - this.borderTop : y - this.marginHeight - 5 - this.tabHeight - this.borderTop;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.marginWidth;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + 5;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createItem(CTabItem2 item, int index) {
        if (index < 0 || index > this.getItemCount()) {
            SWT.error(6);
        }
        CTabItem2[] newItems = new CTabItem2[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        item.parent = this;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        if (this.items.length == 1) {
            this.topTabIndex = 0;
            if (!this.updateTabHeight(this.tabHeight)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            if (index >= this.topTabIndex && item.x + item.width <= this.getSize().x - this.borderRight - this.closeRect.width - this.expandRect.width - this.chevronRect.width) {
                this.redraw();
            }
        }
    }

    void destroyItem(CTabItem2 item) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        this.insertionIndex = -2;
        if (this.items.length == 1) {
            this.items = new CTabItem2[0];
            this.selectedIndex = -1;
            this.topTabIndex = 0;
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            if (!this.fixedTabHeight) {
                this.tabHeight = 0;
            }
            this.redraw();
            return;
        }
        CTabItem2[] newItems = new CTabItem2[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
        if (this.topTabIndex == this.items.length) {
            --this.topTabIndex;
        }
        if (this.selectedIndex == index) {
            Control control = item.getControl();
            this.selectedIndex = -1;
            this.setSelection(Math.max(0, index - 1), true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        if (this.updateItems()) {
            this.redraw();
        }
    }

    void drawBorder(GC gc) {
        Point size = this.getSize();
        if (this.selectedIndex == -1) {
            int x = this.borderLeft;
            int y = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 5 : this.borderTop + this.tabHeight + 1;
            int width = size.x - this.borderLeft - this.borderRight;
            int height = 4;
            gc.setBackground(this.getBackground());
            gc.fillRectangle(x, y, width, height);
            x = this.borderLeft;
            y = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            gc.setForeground(border1Color);
            gc.drawLine(x, y, x + width, y);
        } else {
            int x = this.borderLeft;
            int y = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 5 : this.borderTop + this.tabHeight + 1;
            int width = size.x - this.borderLeft - this.borderRight;
            int height = 4;
            int[] shape = new int[]{x, y, x + width, y, x + width, y + height, x, y + height};
            this.drawSelectionBackground(gc, shape);
            CTabItem2 item = this.items[this.selectedIndex];
            int itemX = item.x;
            int itemY = item.y;
            int itemW = item.width;
            int itemH = item.height;
            int extra = 25;
            if (this.onBottom) {
                int[] left = BOTTOM_LEFT_CORNER;
                int[] right = this.curve;
                shape = new int[left.length + right.length + 8];
                int index = 0;
                shape[index++] = Math.max(0, this.borderLeft - 1);
                shape[index++] = itemY - 1;
                shape[index++] = itemX;
                shape[index++] = itemY - 1;
                int i = 0;
                while (i < left.length / 2) {
                    shape[index++] = itemX + left[2 * i];
                    shape[index++] = itemY + itemH + left[2 * i + 1] - 1;
                    ++i;
                }
                i = 0;
                while (i < right.length / 2) {
                    shape[index++] = itemX + itemW - extra + right[2 * i];
                    shape[index++] = itemY + right[2 * i + 1] - 2;
                    ++i;
                }
                int temp = 0;
                int rightTabEdge = size.x - this.borderRight - this.chevronRect.width - this.expandRect.width - this.closeRect.width - 1;
                int i2 = 0;
                while (i2 < shape.length / 2) {
                    if (shape[2 * i2] > rightTabEdge) {
                        temp = temp == 0 && i2 > 0 ? shape[2 * i2 - 1] : itemY - 1;
                        shape[2 * i2] = rightTabEdge;
                        shape[2 * i2 + 1] = temp;
                    }
                    ++i2;
                }
                shape[index++] = rightTabEdge;
                shape[index++] = itemY - 1;
                shape[index++] = size.x - this.borderRight;
                shape[index++] = itemY - 1;
            } else {
                int[] left = TOP_LEFT_CORNER;
                int[] right = this.curve;
                shape = new int[left.length + right.length + 8];
                int index = 0;
                shape[index++] = Math.max(0, this.borderLeft - 1);
                shape[index++] = itemY + itemH;
                shape[index++] = itemX;
                shape[index++] = itemY + itemH;
                int i = 0;
                while (i < left.length / 2) {
                    shape[index++] = itemX + left[2 * i];
                    shape[index++] = itemY + left[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < right.length / 2) {
                    shape[index++] = itemX + itemW - extra + right[2 * i];
                    shape[index++] = itemY + right[2 * i + 1];
                    ++i;
                }
                int temp = 0;
                int rightTabEdge = size.x - this.borderRight - this.chevronRect.width - this.expandRect.width - this.closeRect.width - 1;
                int i3 = 0;
                while (i3 < shape.length / 2) {
                    if (shape[2 * i3] > rightTabEdge) {
                        temp = temp == 0 && i3 > 0 ? shape[2 * i3 - 1] : itemY + itemH;
                        shape[2 * i3] = rightTabEdge;
                        shape[2 * i3 + 1] = temp;
                    }
                    ++i3;
                }
                shape[index++] = rightTabEdge;
                shape[index++] = itemY + itemH;
                shape[index++] = size.x - this.borderRight;
                shape[index++] = itemY + itemH;
            }
            gc.setForeground(border1Color);
            gc.drawPolyline(shape);
        }
        if (this.borderLeft == 0) {
            return;
        }
        if (this.borderLeft == 1) {
            this.drawFlatBorder(gc);
        } else {
            this.draw3DBorder(gc);
        }
    }

    void drawFlatBorder(GC gc) {
        Point size = this.getSize();
        Color color = border1Color;
        gc.setForeground(color);
        if (this.onBottom) {
            int x1 = 0;
            int x2 = size.x - this.borderRight;
            int y1 = this.borderTop - 1;
            int y2 = size.y - this.tabHeight - this.borderBottom - 1;
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y1, x2, y1);
            if (this.single) {
                int x = Math.max(0, this.borderLeft - 1);
                int y = size.y - this.borderBottom - this.tabHeight;
                int width = size.x - this.borderLeft - this.borderRight + 1;
                int height = this.tabHeight - 1;
                int[] shape = new int[BOTTOM_LEFT_OUTSIDE_CORNER.length + BOTTOM_RIGHT_OUTSIDE_CORNER.length + 4];
                int index = 0;
                shape[index++] = x;
                shape[index++] = y;
                int i = 0;
                while (i < BOTTOM_LEFT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + height + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < BOTTOM_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + height + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x + width;
                shape[index++] = y - 1;
                gc.setForeground(border1Color);
                gc.drawPolyline(shape);
            }
        } else {
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.borderTop + this.tabHeight;
            int y2 = size.y - this.borderBottom;
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y2, x2, y2);
            if (this.single) {
                int x = Math.max(0, this.borderLeft - 1);
                int y = this.borderTop;
                int width = size.x - this.borderLeft - this.borderRight + 1;
                int height = this.tabHeight - 1;
                int[] shape = new int[TOP_LEFT_OUTSIDE_CORNER.length + TOP_RIGHT_OUTSIDE_CORNER.length + 4];
                int index = 0;
                shape[index++] = x;
                shape[index++] = y + height;
                int i = 0;
                while (i < TOP_LEFT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + TOP_LEFT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_LEFT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < TOP_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + TOP_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x + width;
                shape[index++] = y + height + 1;
                gc.setForeground(border1Color);
                gc.drawPolyline(shape);
            }
        }
    }

    void draw3DBorder(GC gc) {
        int y2;
        int y1;
        int x2;
        int x1;
        Point size = this.getSize();
        Color parentBackground = this.getParent().getBackground();
        if (this.single) {
            int i;
            int index;
            int[] shape;
            int height;
            int width;
            int y;
            int x;
            if (this.onBottom) {
                x = Math.max(0, this.borderLeft - 1);
                if (this.borderLeft > 1 & this.showHighlight) {
                    x -= 3;
                }
                y = size.y - this.borderBottom - this.tabHeight;
                width = size.x - this.borderLeft - this.borderRight + 1;
                if (this.borderRight > 1 & this.showHighlight) {
                    width += 6;
                }
                height = this.tabHeight - 1;
                shape = new int[BOTTOM_LEFT_OUTSIDE_CORNER.length + BOTTOM_RIGHT_OUTSIDE_CORNER.length + 4];
                index = 0;
                shape[index++] = x;
                shape[index++] = y;
                i = 0;
                while (i < BOTTOM_LEFT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + height + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < BOTTOM_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + height + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x + width;
                shape[index++] = y - 1;
                gc.setForeground(border1Color);
                gc.drawPolyline(shape);
            } else {
                x = this.borderLeft - 1;
                if (this.borderLeft > 1 & this.showHighlight) {
                    x -= 3;
                }
                y = this.borderTop;
                width = size.x - this.borderLeft - this.borderRight + 1;
                if (this.borderRight > 1 & this.showHighlight) {
                    width += 6;
                }
                height = this.tabHeight - 1;
                shape = new int[TOP_LEFT_OUTSIDE_CORNER.length + TOP_RIGHT_OUTSIDE_CORNER.length + 4];
                index = 0;
                shape[index++] = x;
                shape[index++] = y + height;
                i = 0;
                while (i < TOP_LEFT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + TOP_LEFT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_LEFT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < TOP_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + TOP_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x + width;
                shape[index++] = y + height + 1;
                gc.setForeground(border1Color);
                gc.drawPolyline(shape);
            }
        }
        if (!this.showHighlight) {
            if (this.onBottom) {
                x1 = 3;
                x2 = size.x - this.borderRight;
                y1 = 3;
                y2 = size.y - this.borderBottom - this.tabHeight;
                gc.setBackground(parentBackground);
                gc.fillRectangle(0, 0, 3, size.y);
                gc.fillRectangle(x2 + 1, 0, this.borderRight, size.y);
                gc.fillRectangle(0, 0, size.x, 3);
                gc.setForeground(border1Color);
                gc.drawLine(x1, y1, x1, y2);
                gc.drawLine(x2, y1, x2, y2);
                gc.drawLine(x1, y1, x2, y1);
            } else {
                x1 = 3;
                x2 = size.x - this.borderRight;
                y1 = this.borderTop + this.tabHeight;
                y2 = size.y - this.borderBottom;
                gc.setBackground(parentBackground);
                gc.fillRectangle(0, 0, 3, size.y);
                gc.fillRectangle(x2 + 1, 0, this.borderRight, size.y);
                gc.fillRectangle(0, y2, size.x, this.borderBottom);
                gc.setForeground(border1Color);
                gc.drawLine(x1, y1, x1, y2);
                gc.drawLine(x2, y1, x2, y2);
                gc.drawLine(x1, y2, x2, y2);
            }
        } else if (this.onBottom) {
            int gapStart;
            if (!this.single) {
                gc.setBackground(parentBackground);
                gc.fillRectangle(0, size.y - this.borderBottom - this.tabHeight + 1, 3, this.borderBottom + this.tabHeight);
                gc.fillRectangle(size.x - this.borderRight + 1, size.y - this.borderBottom - this.tabHeight + 1, this.borderRight, this.borderTop + this.tabHeight);
            }
            x1 = 0;
            x2 = size.x - 3;
            y1 = 0;
            y2 = size.y - this.borderBottom - this.tabHeight - 1;
            gc.setForeground(border1Color);
            gc.drawLine(x1, y2, this.borderLeft - 1, y2);
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(size.x - this.borderRight, y2, x2, y2);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y1, x2, y1);
            int gapEnd = gapStart = size.x / 2;
            if (this.selectedIndex != -1 && this.selectedIndex >= this.topTabIndex) {
                CTabItem2 item = this.items[this.selectedIndex];
                Rectangle r = item.getBounds();
                int rightTabEdge = size.x - this.borderRight - this.chevronRect.width - this.expandRect.width - this.closeRect.width - 1;
                if (r.x < rightTabEdge) {
                    gapStart = r.x - 1;
                    int extra = 25;
                    int[] left = BOTTOM_LEFT_CORNER;
                    int[] right = this.curve;
                    int[] shape = new int[left.length + right.length + 8];
                    int index = 0;
                    shape[index++] = Math.max(0, this.borderLeft - 1);
                    shape[index++] = r.y - 1;
                    shape[index++] = r.x;
                    shape[index++] = r.y - 1;
                    int i = 0;
                    while (i < left.length / 2) {
                        shape[index++] = r.x + left[2 * i];
                        shape[index++] = r.y + r.height + left[2 * i + 1] - 1;
                        ++i;
                    }
                    i = 0;
                    while (i < right.length / 2) {
                        shape[index++] = r.x + r.width - extra + right[2 * i];
                        shape[index++] = r.y + right[2 * i + 1] - 2;
                        ++i;
                    }
                    i = 0;
                    while (i < shape.length / 2) {
                        if (shape[2 * i] > rightTabEdge) {
                            gapEnd = rightTabEdge + 1;
                            break;
                        }
                        if (shape[2 * i + 1] > r.y) {
                            gapEnd = shape[2 * i];
                        }
                        ++i;
                    }
                }
            }
            x1 = 1;
            x2 = size.x - 2;
            y1 = 1;
            y2 = size.y - this.borderBottom - this.tabHeight;
            gc.setForeground(border2Color);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y2, gapStart, y2);
            gc.drawLine(gapEnd, y2, x2, y2);
            gc.setForeground(parentBackground);
            if (!this.single) {
                gc.drawPoint(0, y2);
            }
            gc.drawPoint(x2, 0);
            x1 = 2;
            x2 = size.x - 1;
            y1 = 2;
            y2 = size.y - this.borderBottom - this.tabHeight + 1;
            gc.setForeground(border3Color);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y2, gapStart, y2);
            gc.drawLine(gapEnd, y2, x2, y2);
            gc.setForeground(parentBackground);
            if (!this.single) {
                gc.drawLine(0, y2, 1, y2);
            }
            gc.drawLine(x2, 0, x2, 1);
            x1 = 1;
            x2 = size.x - 3;
            y1 = 1;
            y2 = size.y - this.borderBottom - this.tabHeight - 1;
            int[] shape = new int[]{x1, y1, x2, y1, x2, y2, x1, y2};
            this.drawSelectionBackground(gc, shape);
        } else {
            int i;
            int index;
            int[] shape;
            int width;
            int y;
            if (!this.single) {
                gc.setBackground(parentBackground);
                gc.fillRectangle(0, 0, 3, this.borderTop + this.tabHeight);
                gc.fillRectangle(size.x - this.borderRight + 1, 0, this.borderRight, this.borderTop + this.tabHeight);
            }
            x1 = 0;
            x2 = size.x - 3;
            y1 = this.borderTop + this.tabHeight;
            y2 = size.y - 3;
            gc.setForeground(border1Color);
            gc.drawLine(x1, y1, this.borderLeft - 1, y1);
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(size.x - this.borderRight, y1, x2, y1);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y2, x2, y2);
            x1 = 1;
            x2 = size.x - 2;
            y1 = this.borderTop + this.tabHeight + 1;
            y2 = size.y - 2;
            gc.setForeground(border2Color);
            gc.drawLine(x1, y2, x2, y2);
            if (this.single) {
                int x = this.borderLeft - 3;
                y = this.borderTop;
                width = size.x - this.borderLeft - this.borderRight + 1 + 6;
                shape = new int[TOP_RIGHT_OUTSIDE_CORNER.length - 2];
                index = 0;
                i = 2;
                while (i < TOP_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + TOP_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x2;
                shape[index++] = y2;
                gc.drawPolyline(shape);
                gc.setForeground(parentBackground);
                gc.drawPoint(0, y2);
            } else {
                gc.drawLine(x2, y1, x2, y2);
                gc.setForeground(parentBackground);
                gc.drawPoint(0, y2);
                gc.drawLine(x2, 0, x2, y1 - 1);
            }
            x1 = 2;
            x2 = size.x - 1;
            y1 = this.borderTop + this.tabHeight + 2;
            y2 = size.y - 1;
            gc.setForeground(border3Color);
            gc.drawLine(x1, y2, x2, y2);
            if (this.single) {
                int x = this.borderLeft - 3 + 1;
                y = this.borderTop;
                width = size.x - this.borderLeft - this.borderRight + 1 + 6;
                shape = new int[TOP_RIGHT_OUTSIDE_CORNER.length - 4];
                index = 0;
                i = 3;
                while (i < TOP_RIGHT_OUTSIDE_CORNER.length / 2) {
                    shape[index++] = x + width + TOP_RIGHT_OUTSIDE_CORNER[2 * i];
                    shape[index++] = y + TOP_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                    ++i;
                }
                shape[index++] = x2;
                shape[index++] = y2;
                gc.drawPolyline(shape);
                gc.setForeground(parentBackground);
                gc.drawLine(0, y2, 1, y2);
            } else {
                gc.drawLine(x2, y1, x2, y2);
                gc.setForeground(parentBackground);
                gc.drawLine(0, y2, 1, y2);
                gc.drawLine(x2, 0, x2, y1 - 1);
            }
            x1 = 1;
            x2 = size.x - 3;
            y1 = this.borderTop + this.tabHeight + 1;
            y2 = size.y - 3;
            int[] shape2 = new int[]{x1, y1, x2, y1, x2, y2, x1, y2};
            this.drawSelectionBackground(gc, shape2);
        }
    }

    void drawChevron(GC gc) {
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        if (!this.single) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(this.chevronRect);
        }
        int indent = Math.max(1, (this.tabHeight - 11) / 2);
        int x = this.chevronRect.x + indent - 1;
        int y = this.chevronRect.y + indent;
        switch (this.chevronImageState) {
            case 1: {
                int[] shape = new int[]{x, y, x + 2, y, x + 6, y + 4, x + 6, y + 5, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(display.getSystemColor(1));
                gc.fillPolygon(shape);
                gc.setForeground(border1Color);
                gc.drawPolygon(shape);
                break;
            }
            case 2: {
                int[] shape = new int[]{x, y, x + 2, y, x + 6, y + 4, x + 6, y + 5, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(display.getSystemColor(1));
                gc.fillPolygon(shape);
                Color border = new Color(display, CHEVRON_BORDER);
                gc.setForeground(border);
                gc.drawPolygon(shape);
                border.dispose();
                break;
            }
            case 3: {
                int[] shape = new int[]{x + 1, y + 1, x + 3, y + 1, x + 7, y + 5, x + 7, y + 6, x + 3, y + 10, x + 1, y + 10, x + 1, y + 8, x + 3, y + 6, x + 3, y + 5, x + 1, y + 3};
                Color fill = new Color(display, CHEVRON_FILL);
                gc.setBackground(fill);
                gc.fillPolygon(shape);
                fill.dispose();
                Color border = new Color(display, CHEVRON_BORDER);
                gc.setForeground(border);
                gc.drawPolygon(shape);
                border.dispose();
            }
        }
    }

    void drawClose(GC gc) {
        if (this.closeRect.width == 0 || this.closeRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        if (!this.single) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(this.closeRect);
        }
        int indent = Math.max(1, (this.tabHeight - 11) / 2);
        int x = this.closeRect.x + indent - 1;
        int y = this.closeRect.y + indent;
        switch (this.closeImageState) {
            case 1: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(display.getSystemColor(1));
                gc.fillPolygon(shape);
                gc.setForeground(border1Color);
                gc.drawPolygon(shape);
                break;
            }
            case 2: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(display.getSystemColor(1));
                gc.fillPolygon(shape);
                Color border = new Color(display, CLOSE_BORDER);
                gc.setForeground(border);
                gc.drawPolygon(shape);
                border.dispose();
                break;
            }
            case 3: {
                int[] shape = new int[]{x + 1, y + 1, x + 3, y + 1, x + 5, y + 3, x + 6, y + 3, x + 8, y + 1, x + 10, y + 1, x + 10, y + 3, x + 8, y + 5, x + 8, y + 6, x + 10, y + 8, x + 10, y + 10, x + 8, y + 10, x + 6, y + 8, x + 5, y + 8, x + 3, y + 10, x + 1, y + 10, x + 1, y + 8, x + 3, y + 6, x + 3, y + 5, x + 1, y + 3};
                Color fill = new Color(display, CLOSE_FILL);
                gc.setBackground(fill);
                gc.fillPolygon(shape);
                fill.dispose();
                Color border = new Color(display, CLOSE_BORDER);
                gc.setForeground(border);
                gc.drawPolygon(shape);
                border.dispose();
            }
        }
    }

    void drawExpand(GC gc) {
        if (this.expandRect.width == 0 || this.expandRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        if (!this.single) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(this.expandRect);
        }
        int indent = Math.max(1, (this.tabHeight - 11) / 2);
        int x = this.expandRect.x + indent - 1;
        int y = this.expandRect.y + indent;
        switch (this.expandImageState) {
            case 1: {
                if (this.expanded) {
                    gc.setBackground(this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(x, y, 9, 3);
                    gc.setForeground(border1Color);
                    gc.drawRectangle(x, y, 9, 3);
                    break;
                }
                gc.setBackground(this.getDisplay().getSystemColor(1));
                gc.fillRectangle(x, y, 7, 9);
                gc.setForeground(border1Color);
                gc.drawRectangle(x, y, 7, 9);
                gc.drawLine(x + 1, y + 2, x + 6, y + 2);
                break;
            }
            case 2: {
                Color border = new Color(display, EXPAND_BORDER);
                if (this.expanded) {
                    gc.setBackground(this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(x, y, 9, 3);
                    gc.setForeground(border);
                    gc.drawRectangle(x, y, 9, 3);
                } else {
                    gc.setBackground(this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(x, y, 7, 9);
                    gc.setForeground(border);
                    gc.drawRectangle(x, y, 7, 9);
                    gc.drawLine(x + 1, y + 2, x + 6, y + 2);
                }
                border.dispose();
                break;
            }
            case 3: {
                Color fill = new Color(display, EXPAND_FILL);
                Color border = new Color(display, EXPAND_BORDER);
                if (this.expanded) {
                    gc.setBackground(fill);
                    gc.fillRectangle(x + 1, y + 1, 9, 3);
                    gc.setForeground(border);
                    gc.drawRectangle(x + 1, y + 1, 9, 3);
                } else {
                    gc.setBackground(fill);
                    gc.fillRectangle(x + 1, y + 1, 7, 9);
                    gc.setForeground(border);
                    gc.drawRectangle(x + 1, y + 1, 7, 9);
                    gc.drawLine(x + 2, y + 3, x + 7, y + 3);
                }
                fill.dispose();
                border.dispose();
            }
        }
    }

    void drawSelectionBackground(GC gc, int[] shape) {
        if (this.backgroundImage != null) {
            Region clipping = new Region();
            gc.getClipping(clipping);
            Region region = new Region();
            region.add(shape);
            gc.setClipping(region);
            gc.setBackground(this.selectionBackground);
            gc.drawImage(this.backgroundImage, 0, 0);
            gc.setClipping(clipping);
            clipping.dispose();
            region.dispose();
        } else if (this.gradientColors != null) {
            Point size = this.getSize();
            Region clipping = new Region();
            gc.getClipping(clipping);
            Region region = new Region();
            region.add(shape);
            gc.setClipping(region);
            if (this.gradientColors.length == 1) {
                Color background = this.gradientColors[0] != null ? this.gradientColors[0] : this.selectionBackground;
                gc.setBackground(background);
                gc.fillRectangle(0, 0, size.x, size.y);
            } else {
                Color background = this.selectionBackground;
                Color lastColor = this.gradientColors[0];
                if (lastColor == null) {
                    lastColor = background;
                }
                int i = 0;
                int pos = 0;
                while (i < this.gradientPercents.length) {
                    gc.setForeground(lastColor);
                    lastColor = this.gradientColors[i + 1];
                    if (lastColor == null) {
                        lastColor = background;
                    }
                    gc.setBackground(lastColor);
                    int gradientWidth = this.gradientPercents[i] * size.x / 100;
                    gc.fillGradientRectangle(0, 0, gradientWidth, size.y, false);
                    pos += gradientWidth;
                    ++i;
                }
            }
            gc.setClipping(clipping);
            clipping.dispose();
            region.dispose();
        } else {
            gc.setBackground(this.selectionBackground);
            gc.fillPolygon(shape);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!this.expanded) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point size = this.getSize();
        int width = size.x - this.borderLeft - this.borderRight - 2 * this.marginWidth;
        int height = size.y - this.borderTop - this.borderBottom - 2 * this.marginHeight;
        if (this.items.length == 0) {
            return new Rectangle(this.borderLeft + this.marginWidth, this.borderTop + this.marginHeight, width, height);
        }
        return new Rectangle(this.xClient, this.yClient, width, height -= this.tabHeight + 5);
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public CTabItem2 getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            SWT.error(6);
        }
        return this.items[index];
    }

    public CTabItem2 getItem(Point pt) {
        if (this.items.length == 0) {
            return null;
        }
        Point size = this.getSize();
        if (size.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        int index = this.topTabIndex;
        while (index < this.items.length) {
            CTabItem2 item = this.items[index];
            Rectangle rect = item.getBounds();
            if (rect.contains(pt)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem2[] getItems() {
        CTabItem2[] tabItems = new CTabItem2[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public CTabItem2 getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public int getTabHeight() {
        this.checkWidget();
        return this.tabHeight;
    }

    public Control getTopRight() {
        this.checkWidget();
        return null;
    }

    public int indexOf(CTabItem2 item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                int index;
                String name = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder2.this.items.length && (index = (name = CTabFolder2.this.items[childID].getText()).indexOf(38)) > 0) {
                    name = String.valueOf(name.substring(0, index)) + name.substring(index + 1);
                }
                e.result = name;
            }

            public void getHelp(AccessibleEvent e) {
                String help = null;
                int childID = e.childID;
                if (childID == -1) {
                    help = CTabFolder2.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder2.this.items.length) {
                    help = CTabFolder2.this.items[childID].getToolTipText();
                }
                e.result = help;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder2.this.items.length && (text = CTabFolder2.this.items[childID].getText()) != null && (mnemonic = CTabFolder2.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTabFolder2.this.toControl(new Point(e.x, e.y));
                int childID = -2;
                int i = 0;
                while (i < CTabFolder2.this.items.length) {
                    if (CTabFolder2.this.items[i].getBounds().contains(testPoint)) {
                        childID = i;
                        break;
                    }
                    ++i;
                }
                if (childID == -2) {
                    Rectangle location = CTabFolder2.this.getBounds();
                    location.height -= CTabFolder2.this.getClientArea().height;
                    if (location.contains(testPoint)) {
                        childID = -1;
                    }
                }
                e.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTabFolder2.this.getBounds();
                }
                if (childID >= 0 && childID < CTabFolder2.this.items.length) {
                    location = CTabFolder2.this.items[childID].getBounds();
                }
                if (location != null) {
                    Point pt = CTabFolder2.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CTabFolder2.this.items.length;
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                String action = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder2.this.items.length) {
                    action = "Switch";
                }
                e.result = action;
            }

            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (CTabFolder2.this.isFocusControl()) {
                    childID = CTabFolder2.this.selectedIndex == -1 ? -1 : CTabFolder2.this.selectedIndex;
                }
                e.childID = childID;
            }

            public void getRole(AccessibleControlEvent e) {
                int role = 0;
                int childID = e.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder2.this.items.length) {
                    role = 37;
                }
                e.detail = role;
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = CTabFolder2.this.selectedIndex == -1 ? -2 : CTabFolder2.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder2.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder2.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder2.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder2.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                }
                e.detail = state;
            }

            public void getChildren(AccessibleControlEvent e) {
                Object[] children = new Object[CTabFolder2.this.items.length];
                int i = 0;
                while (i < CTabFolder2.this.items.length) {
                    children[i] = new Integer(i);
                    ++i;
                }
                e.children = children;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder2.this.isFocusControl()) {
                    if (CTabFolder2.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder2.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder2.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder2.this.selectedIndex);
                }
            }
        });
    }

    boolean onArrowTraversal(Event event) {
        int count = this.items.length;
        if (count == 0) {
            return false;
        }
        if (this.selectedIndex == -1) {
            return false;
        }
        int offset = event.detail == 64 ? 1 : -1;
        int index = this.selectedIndex + offset;
        if (index < 0 || index >= count) {
            return false;
        }
        this.setSelection(index, true);
        return true;
    }

    void onDispose() {
        this.inDispose = true;
        int length = this.items.length;
        int i = 0;
        while (i < length) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            ++i;
        }
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event) {
        char key = event.character;
        int i = 0;
        while (i < this.items.length) {
            char mnemonic;
            if (this.items[i] != null && (mnemonic = this.getMnemonic(this.items[i].getText())) != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                this.setSelection(i, true);
                return true;
            }
            ++i;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        Event e = new Event();
        e.item = this.getItem(new Point(event.x, event.y));
        this.notifyListeners(14, e);
    }

    void onMouseHover(Event event) {
        if (this.tipShowing) {
            return;
        }
        this.showToolTip(event.x, event.y);
    }

    void onMouse(Event event) {
        int x = event.x;
        int y = event.y;
        switch (event.type) {
            case 7: {
                if (this.closeImageState != 1) {
                    this.closeImageState = 1;
                    this.redraw(this.closeRect.x, this.closeRect.y, this.closeRect.width, this.closeRect.height, false);
                }
                if (this.expandImageState != 1) {
                    this.expandImageState = 1;
                    this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
                }
                if (this.chevronImageState == 1) break;
                this.chevronImageState = 1;
                this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                break;
            }
            case 3: {
                if (this.closeRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.closeImageState = 3;
                    this.redraw(this.closeRect.x, this.closeRect.y, this.closeRect.width, this.closeRect.height, false);
                    this.update();
                    return;
                }
                if (this.expandRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.expandImageState = 3;
                    this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.chevronImageState = 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i].getBounds().contains(x, y)) {
                        if (i == this.selectedIndex) {
                            this.showSelection();
                            return;
                        }
                        this.setSelection(i, true);
                        this.setFocus();
                        return;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                boolean close = false;
                boolean expand = false;
                boolean chevron = false;
                if (this.closeRect.contains(x, y)) {
                    close = true;
                    if (this.closeImageState != 2) {
                        this.closeImageState = 2;
                        this.redraw(this.closeRect.x, this.closeRect.y, this.closeRect.width, this.closeRect.height, false);
                    }
                }
                if (this.expandRect.contains(x, y)) {
                    expand = true;
                    if (this.expandImageState != 2) {
                        this.expandImageState = 2;
                        this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
                    }
                }
                if (this.chevronRect.contains(x, y)) {
                    chevron = true;
                    if (this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.closeImageState == 2 && !close) {
                    this.closeImageState = 1;
                    this.redraw(this.closeRect.x, this.closeRect.y, this.closeRect.width, this.closeRect.height, false);
                }
                if (this.expandImageState == 2 && !expand) {
                    this.expandImageState = 1;
                    this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
                }
                if (this.chevronImageState != 2 || chevron) break;
                this.chevronImageState = 1;
                this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.closeRect.contains(x, y)) {
                    this.closeImageState = 2;
                    this.redraw(this.closeRect.x, this.closeRect.y, this.closeRect.width, this.closeRect.height, false);
                    if (this.selectedIndex == -1) {
                        return;
                    }
                    CTabItem2 item = this.items[this.selectedIndex];
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.item = item;
                    e.doit = true;
                    int i = 0;
                    while (i < this.closeListeners.length) {
                        this.closeListeners[i].itemClosed(e);
                        ++i;
                    }
                    if (e.doit) {
                        item.dispose();
                    }
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    this.chevronImageState = 2;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    Rectangle rect = new Rectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height);
                    if (this.listListeners.length == 0) {
                        this.showList(rect, 16384);
                    } else {
                        CTabFolderEvent e = new CTabFolderEvent(this);
                        e.widget = this;
                        e.time = event.time;
                        e.rect = rect;
                        int i = 0;
                        while (i < this.listListeners.length) {
                            this.listListeners[i].showList(e);
                            ++i;
                        }
                    }
                    return;
                }
                if (this.expandRect.contains(x, y)) {
                    this.expandImageState = 2;
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.doit = true;
                    int i = 0;
                    while (i < this.expandListeners.length) {
                        if (this.expanded) {
                            this.expandListeners[i].collapse(e);
                        } else {
                            this.expandListeners[i].expand(e);
                        }
                        ++i;
                    }
                    if (e.doit) {
                        this.expanded = !this.expanded;
                    }
                    this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
                    return;
                }
                if (!this.single || this.items.length <= 1) break;
                int i = 0;
                while (i < this.items.length) {
                    Rectangle bounds = this.items[i].getBounds();
                    if (bounds.contains(x, y)) {
                        Rectangle rect = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                        if (this.listListeners.length == 0) {
                            this.showList(rect, 131072);
                        } else {
                            CTabFolderEvent e = new CTabFolderEvent(this);
                            e.widget = this;
                            e.time = event.time;
                            e.rect = rect;
                            int j = 0;
                            while (j < this.listListeners.length) {
                                this.listListeners[j].showList(e);
                                ++j;
                            }
                        }
                        return;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    boolean onPageTraversal(Event event) {
        int count = this.items.length;
        if (count == 0) {
            return false;
        }
        int index = this.selectedIndex;
        if (index == -1) {
            index = 0;
        } else {
            int offset = event.detail == 512 ? 1 : -1;
            index = (this.selectedIndex + offset + count) % count;
        }
        this.setSelection(index, true);
        return true;
    }

    void onPaint(Event event) {
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(this.tabHeight)) {
                this.updateItems();
                this.redraw();
            }
        }
        GC gc = event.gc;
        Point size = this.getSize();
        Color parentBackground = this.getParent().getBackground();
        Color background = this.getBackground();
        if (this.items.length == 0) {
            gc.setBackground(parentBackground);
            gc.fillRectangle(0, 0, size.x, size.y);
            return;
        }
        if (this.single) {
            if (this.selectedIndex != -1) {
                int i;
                int index;
                int height;
                int width;
                int y;
                int x;
                CTabItem2 item = this.items[this.selectedIndex];
                int[] shapeLeft = null;
                int[] shapeRight = null;
                if (this.onBottom) {
                    x = Math.max(0, this.borderLeft - 1);
                    if (this.borderLeft > 1 & this.showHighlight) {
                        x -= 3;
                    }
                    y = size.y - this.borderBottom - this.tabHeight;
                    width = item.x - x;
                    height = this.tabHeight;
                    if (this.borderRight > 0) {
                        --height;
                    }
                    shapeLeft = new int[BOTTOM_LEFT_OUTSIDE_CORNER.length + 6];
                    index = 0;
                    shapeLeft[index++] = x;
                    shapeLeft[index++] = y;
                    i = 0;
                    while (i < BOTTOM_LEFT_OUTSIDE_CORNER.length / 2) {
                        shapeLeft[index++] = x + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i];
                        shapeLeft[index++] = y + height + BOTTOM_LEFT_OUTSIDE_CORNER[2 * i + 1];
                        ++i;
                    }
                    shapeLeft[index++] = x + width;
                    shapeLeft[index++] = y + height;
                    shapeLeft[index++] = x + width;
                    shapeLeft[index++] = y;
                    x = item.x + item.width;
                    width = size.x - this.borderRight - x;
                    if (this.borderRight > 1 & this.showHighlight) {
                        width += 3;
                    }
                    if (this.borderRight > 0) {
                        ++width;
                    }
                    shapeRight = new int[BOTTOM_RIGHT_OUTSIDE_CORNER.length + 6];
                    index = 0;
                    shapeRight[index++] = x;
                    shapeRight[index++] = y;
                    shapeRight[index++] = x;
                    shapeRight[index++] = y + height;
                    i = 0;
                    while (i < BOTTOM_RIGHT_OUTSIDE_CORNER.length / 2) {
                        shapeRight[index++] = x + width + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i];
                        shapeRight[index++] = y + height + BOTTOM_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                        ++i;
                    }
                    shapeRight[index++] = x + width;
                    shapeRight[index++] = y;
                } else {
                    x = Math.max(0, this.borderLeft - 1);
                    if (this.borderLeft > 1 & this.showHighlight) {
                        x -= 3;
                    }
                    y = this.borderTop;
                    width = item.x - x;
                    height = this.tabHeight;
                    shapeLeft = new int[TOP_LEFT_OUTSIDE_CORNER.length + 6];
                    index = 0;
                    shapeLeft[index++] = x;
                    shapeLeft[index++] = y + height;
                    i = 0;
                    while (i < TOP_LEFT_OUTSIDE_CORNER.length / 2) {
                        shapeLeft[index++] = x + TOP_LEFT_OUTSIDE_CORNER[2 * i];
                        shapeLeft[index++] = y + TOP_LEFT_OUTSIDE_CORNER[2 * i + 1];
                        ++i;
                    }
                    shapeLeft[index++] = x + width;
                    shapeLeft[index++] = y;
                    shapeLeft[index++] = x + width;
                    shapeLeft[index++] = y + height;
                    x = item.x + item.width;
                    width = size.x - this.borderRight - x;
                    if (this.borderRight > 1 & this.showHighlight) {
                        width += 3;
                    }
                    if (this.borderRight > 0) {
                        ++width;
                    }
                    shapeRight = new int[TOP_RIGHT_OUTSIDE_CORNER.length + 6];
                    index = 0;
                    shapeRight[index++] = x;
                    shapeRight[index++] = y + height;
                    shapeRight[index++] = x;
                    shapeRight[index++] = y;
                    i = 0;
                    while (i < TOP_RIGHT_OUTSIDE_CORNER.length / 2) {
                        shapeRight[index++] = x + width + TOP_RIGHT_OUTSIDE_CORNER[2 * i];
                        shapeRight[index++] = y + TOP_RIGHT_OUTSIDE_CORNER[2 * i + 1];
                        ++i;
                    }
                    shapeRight[index++] = x + width;
                    shapeRight[index++] = y + height;
                }
                Region r = new Region();
                int x2 = Math.max(0, this.borderLeft - 1);
                if (this.borderLeft > 1 & this.showHighlight) {
                    x2 -= 3;
                }
                int y2 = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop;
                int width2 = item.x - x2;
                int height2 = this.tabHeight;
                r.add(new Rectangle(x2, y2, width2, height2));
                r.subtract(shapeLeft);
                gc.setBackground(this.getParent().getBackground());
                CTabFolder2.fillRegion(gc, r);
                gc.setBackground(background);
                gc.fillPolygon(shapeLeft);
                x2 = item.x + item.width;
                width2 = size.x - this.borderRight - x2;
                if (this.borderRight > 1 & this.showHighlight) {
                    width2 += this.borderRight;
                }
                if (width2 > 0) {
                    if (this.borderRight > 0) {
                        ++width2;
                    }
                    r.subtract(r);
                    r.add(new Rectangle(x2, y2, width2, height2));
                    r.subtract(shapeRight);
                    gc.setBackground(this.getParent().getBackground());
                    CTabFolder2.fillRegion(gc, r);
                    gc.setBackground(background);
                    gc.fillPolygon(shapeRight);
                }
                r.dispose();
            }
        } else {
            CTabItem2 lastItem = this.items[this.items.length - 1];
            int edge = lastItem.x + lastItem.width;
            if (edge < size.x) {
                int x = edge;
                int y = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 1 : this.borderTop;
                int width = size.x - edge - this.borderRight + 1;
                int height = this.tabHeight + 1;
                gc.setBackground(parentBackground);
                gc.fillRectangle(x, y, width, height);
            }
        }
        if (!this.single) {
            int i = 0;
            while (i < this.items.length) {
                if (i != this.selectedIndex && event.getBounds().intersects(this.items[i].getBounds())) {
                    this.items[i].onPaint(gc, false);
                }
                ++i;
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem2 item = this.items[this.selectedIndex];
            Rectangle rect = item.getBounds();
            if (event.getBounds().intersects(rect.x, rect.y, rect.width + 50, rect.height)) {
                item.onPaint(gc, true);
            }
        }
        this.drawClose(gc);
        this.drawChevron(gc);
        this.drawExpand(gc);
        this.drawBorder(gc);
        int width = size.x - this.borderLeft - this.borderRight;
        int height = size.y - this.borderTop - this.borderBottom - this.tabHeight - 5;
        int x = this.xClient - this.marginWidth;
        int y = this.yClient - this.marginHeight;
        this.drawSelectionBackground(gc, new int[]{x, y, x, y + height, x + width, y + height, x + width, y});
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
    }

    void onResize() {
        Control control;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.updateItems()) {
            this.redraw();
        }
        Point size = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && size.y != this.oldSize.y) {
            this.redraw();
        } else {
            int x1 = Math.min(size.x, this.oldSize.x);
            if (size.x != this.oldSize.x) {
                x1 -= 10;
            }
            int y1 = Math.min(size.y, this.oldSize.y);
            if (size.y != this.oldSize.y) {
                y1 -= 10;
            }
            int x2 = Math.max(size.x, this.oldSize.x);
            int y2 = Math.max(size.y, this.oldSize.y);
            this.redraw(0, y1, x2 + 10, y2 - y1, false);
            this.redraw(x1, 0, x2 - x1, y2, false);
        }
        this.oldSize = size;
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 32: 
            case 64: {
                event.doit = this.onArrowTraversal(event);
                event.detail = 0;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    public void removeCTabFolderCloseListener(CTabFolderCloseListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.closeListeners.length) {
            if (listener == this.closeListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.closeListeners.length == 1) {
            this.closeListeners = new CTabFolderCloseListener[0];
            this.showClose = false;
            this.setButtonBounds();
            return;
        }
        CTabFolderCloseListener[] newTabListeners = new CTabFolderCloseListener[this.closeListeners.length - 1];
        System.arraycopy(this.closeListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.closeListeners, index + 1, newTabListeners, index, this.closeListeners.length - index - 1);
        this.closeListeners = newTabListeners;
    }

    public void removeCTabFolderExpandListener(CTabFolderExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.expandListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.expandListeners.length) {
            if (listener == this.expandListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.expandListeners.length == 1) {
            this.expandListeners = new CTabFolderExpandListener[0];
            this.showExpand = false;
            this.updateItems();
            this.redraw();
            return;
        }
        CTabFolderExpandListener[] newListeners = new CTabFolderExpandListener[this.expandListeners.length - 1];
        System.arraycopy(this.expandListeners, 0, newListeners, 0, index);
        System.arraycopy(this.expandListeners, index + 1, newListeners, index, this.expandListeners.length - index - 1);
        this.expandListeners = newListeners;
    }

    public void removeCTabFolderListener(CTabFolderListener listener) {
        this.removeCTabFolderCloseListener(listener);
    }

    public void removeCTabFolderListListener(CTabFolderListListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.listListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.listListeners.length) {
            if (listener == this.listListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.listListeners.length == 1) {
            this.listListeners = new CTabFolderListListener[0];
            return;
        }
        CTabFolderListListener[] newListeners = new CTabFolderListListener[this.listListeners.length - 1];
        System.arraycopy(this.listListeners, 0, newListeners, 0, index);
        System.arraycopy(this.listListeners, index + 1, newListeners, index, this.listListeners.length - index - 1);
        this.listListeners = newListeners;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(34);
        }
        super.setBackground(color);
        this.redraw();
    }

    public void setBorderColor(Color color) {
        this.checkWidget();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showHighlight == show) {
            return;
        }
        this.showHighlight = show;
        this.redraw();
    }

    boolean setButtonBounds() {
        int decoratorWidth = 16;
        boolean changed = false;
        Point size = this.getSize();
        int oldX = this.closeRect.x;
        int oldY = this.closeRect.y;
        int oldWidth = this.closeRect.width;
        int oldHeight = this.closeRect.height;
        this.closeRect.width = 0;
        this.closeRect.height = 0;
        this.closeRect.y = 0;
        this.closeRect.x = 0;
        if (this.showClose && this.selectedIndex != -1) {
            this.closeRect.x = size.x - this.borderRight - decoratorWidth;
            if (this.borderRight > 0) {
                ++this.closeRect.x;
            }
            if (this.single) {
                this.closeRect.x -= 3;
            }
            this.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.closeRect.width = decoratorWidth;
            this.closeRect.height = this.tabHeight;
        }
        if (oldX != this.closeRect.x || oldWidth != this.closeRect.width || oldY != this.closeRect.y || oldHeight != this.closeRect.height) {
            changed = true;
        }
        oldX = this.expandRect.x;
        oldY = this.expandRect.y;
        oldWidth = this.expandRect.width;
        oldHeight = this.expandRect.height;
        if (this.showExpand) {
            this.expandRect.x = size.x - this.borderRight - this.closeRect.width - decoratorWidth;
            if (this.borderRight > 0) {
                ++this.expandRect.x;
            }
            if (this.single) {
                this.expandRect.x -= 3;
            }
            this.expandRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.expandRect.width = decoratorWidth;
            this.expandRect.height = this.tabHeight;
        }
        if (oldX != this.expandRect.x || oldWidth != this.expandRect.width || oldY != this.expandRect.y || oldHeight != this.expandRect.height) {
            changed = true;
        }
        oldX = this.chevronRect.x;
        oldY = this.chevronRect.y;
        oldWidth = this.chevronRect.width;
        oldHeight = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.items.length > 1) {
            CTabItem2 item = this.items[this.items.length - 1];
            int rightEdge = size.x - this.borderRight - this.closeRect.width - this.expandRect.width;
            if (this.single || this.topTabIndex > 0 || item.x + item.width > rightEdge) {
                this.chevronRect.x = size.x - this.borderRight - this.closeRect.width - this.expandRect.width - decoratorWidth;
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
                if (this.single) {
                    this.chevronRect.x -= 3;
                }
                this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                this.chevronRect.width = decoratorWidth;
                this.chevronRect.height = this.tabHeight;
            }
        }
        if (oldX != this.chevronRect.x || oldWidth != this.chevronRect.width || oldY != this.chevronRect.y || oldHeight != this.chevronRect.height) {
            changed = true;
        }
        return changed;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        this.redraw(this.expandRect.x, this.expandRect.y, this.expandRect.width, this.expandRect.height, false);
    }

    void setFirstItem(int index) {
        if (index < 0 || index > this.items.length - 1) {
            return;
        }
        if (index == this.topTabIndex) {
            return;
        }
        this.topTabIndex = index;
        this.setItemLocation();
        this.redraw();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(this.tabHeight)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(33);
        }
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem2 item, boolean after) {
        this.checkWidget();
        int index = -1;
        if (item != null) {
            index = this.indexOf(item);
        }
        this.setInsertMark(index, after);
    }

    public void setInsertMark(int index, boolean after) {
        this.checkWidget();
        if (index < -1 || index >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        if (this.items.length == 0) {
            return false;
        }
        Point size = this.getSize();
        int y = this.onBottom ? Math.max(this.borderBottom, size.y - this.borderBottom - this.tabHeight) : this.borderTop;
        boolean changed = false;
        if (this.single) {
            int defaultX = size.x + 10;
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].x != defaultX) {
                    changed = true;
                }
                this.items[i].x = defaultX;
                ++i;
            }
            if (this.selectedIndex > -1) {
                CTabItem2 item = this.items[this.selectedIndex];
                int oldX = item.x;
                int oldY = item.y;
                int tabWidth = size.x - this.borderLeft - this.borderRight - this.closeRect.width - this.expandRect.width - this.chevronRect.width;
                int indent = Math.max(0, (tabWidth - item.width) / 2);
                item.x = this.borderLeft + indent;
                item.y = y;
                if (item.x != oldX || item.y != oldY) {
                    changed = true;
                }
            }
        } else {
            CTabItem2 tab;
            int x = -1;
            int i = this.topTabIndex - 1;
            while (i >= 0) {
                tab = this.items[i];
                if (!(changed || tab.x == (x -= tab.width) && tab.y == y)) {
                    changed = true;
                }
                tab.x = x;
                tab.y = y;
                --i;
            }
            x = this.borderLeft <= 1 ? 0 : 3;
            i = this.topTabIndex;
            while (i < this.items.length) {
                tab = this.items[i];
                tab.x = x;
                tab.y = y;
                x += tab.width;
                ++i;
            }
            int rightEdge = size.x - this.borderRight - this.closeRect.width - this.expandRect.width - this.chevronRect.width;
            if (rightEdge > 0) {
                CTabItem2 item = this.items[this.items.length - 1];
                if (item.x + item.width < rightEdge) {
                    this.setLastItem(this.items.length - 1);
                    changed = true;
                }
            }
        }
        return changed;
    }

    boolean setItemSize() {
        if (this.isDisposed()) {
            return false;
        }
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0 || this.items.length == 0) {
            return false;
        }
        boolean changed = false;
        this.xClient = this.borderLeft + this.marginWidth;
        this.yClient = this.onBottom ? this.borderTop + this.marginHeight : this.borderTop + this.tabHeight + 5 + this.marginHeight;
        int[] widths = new int[this.items.length];
        GC gc = new GC(this);
        int i = 0;
        while (i < this.items.length) {
            widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex);
            ++i;
        }
        gc.dispose();
        int tabAreaWidth = size.x - this.borderLeft - this.borderRight - this.closeRect.width - this.expandRect.width - this.chevronRect.width;
        if (this.items.length > 1) {
            int selectedWidth = this.selectedIndex == -1 ? 0 : widths[this.selectedIndex];
            int count = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
            int averageWidth = (tabAreaWidth - selectedWidth) / count;
            int oldAverageWidth = 0;
            while (averageWidth > oldAverageWidth) {
                int width = tabAreaWidth - selectedWidth;
                int i2 = 0;
                while (i2 < this.items.length) {
                    if (i2 != this.selectedIndex && widths[i2] < averageWidth) {
                        width -= widths[i2];
                        --count;
                    }
                    ++i2;
                }
                oldAverageWidth = averageWidth;
                if (count <= 0) continue;
                averageWidth = width / count;
            }
            averageWidth = Math.max(averageWidth, this.MIN_TAB_WIDTH * this.tabHeight);
            int i3 = 0;
            while (i3 < this.items.length) {
                if (i3 != this.selectedIndex && widths[i3] > averageWidth) {
                    widths[i3] = averageWidth;
                }
                ++i3;
            }
        }
        int totalWidth = 0;
        int i4 = 0;
        while (i4 < this.items.length) {
            CTabItem2 tab = this.items[i4];
            if (tab.height != this.tabHeight || tab.width != widths[i4]) {
                changed = true;
            }
            tab.height = this.tabHeight;
            tab.width = widths[i4];
            totalWidth += widths[i4];
            ++i4;
        }
        if (totalWidth <= tabAreaWidth) {
            this.topTabIndex = 0;
        }
        return changed;
    }

    void setLastItem(int index) {
        if (index < 0 || index > this.items.length - 1) {
            return;
        }
        Rectangle area = this.getClientArea();
        if (area.width <= 0) {
            return;
        }
        int maxWidth = area.width - this.closeRect.width - this.expandRect.width - this.chevronRect.width;
        int tabWidth = this.items[index].width;
        while (index > 0) {
            if ((tabWidth += this.items[index - 1].width) > maxWidth) break;
            --index;
        }
        if (this.topTabIndex == index) {
            return;
        }
        this.topTabIndex = index;
        this.setItemLocation();
        this.redraw();
    }

    public void setSelection(CTabItem2 item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int index = this.indexOf(item);
        this.setSelection(index);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (this.selectedIndex == index) {
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        Control control = this.items[index].control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (oldIndex != -1 && (control = this.items[oldIndex].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.setItemSize();
        this.setItemLocation();
        this.showItem(this.items[this.selectedIndex]);
        this.setButtonBounds();
        this.redraw();
    }

    void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(31);
        }
        this.selectionBackground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        int i;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[0]};
                percents = new int[]{};
            }
        }
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int i2 = 0;
                while (i2 < this.gradientColors.length) {
                    same = this.gradientColors[i2] == null ? colors[i2] == null : this.gradientColors[i2].equals(colors[i2]);
                    if (!same) break;
                    ++i2;
                }
                if (same) {
                    i2 = 0;
                    while (i2 < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[i2] == percents[i2];
                        if (!same) break;
                        ++i2;
                    }
                }
                if (same) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        } else {
            this.gradientColors = new Color[colors.length];
            i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i];
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(30);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            SWT.error(5);
        }
        this.fixedTabHeight = height > 0;
        int oldHeight = this.tabHeight;
        this.tabHeight = height;
        this.updateTabHeight(oldHeight);
    }

    public void setTopRight(Control control) {
        this.checkWidget();
    }

    public void showItem(CTabItem2 item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        Point size = this.getSize();
        int index = this.indexOf(item);
        if (size.x <= this.borderLeft + this.borderRight || index < this.topTabIndex) {
            this.setFirstItem(index);
            return;
        }
        int rightEdge = size.x - this.borderRight - this.closeRect.width - this.expandRect.width - this.chevronRect.width;
        if (item.x + item.width < rightEdge) {
            return;
        }
        this.setLastItem(index);
    }

    void showList(Rectangle rect, int alignment) {
        final Shell shell = new Shell(this.getShell(), 18432);
        shell.setLayout(new FillLayout());
        final Table table = new Table(shell, 0);
        int i = 0;
        while (i < this.items.length) {
            CTabItem2 tab = this.items[i];
            TableItem item = new TableItem(table, 0);
            item.setText(tab.getText());
            item.setImage(tab.getImage());
            ++i;
        }
        if (this.selectedIndex != -1) {
            table.setSelection(this.selectedIndex);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 16: {
                        shell.dispose();
                        break;
                    }
                    case 4: 
                    case 14: {
                        int index = table.getSelectionIndex();
                        if (index != CTabFolder2.this.selectedIndex) {
                            CTabFolder2.this.setSelection(index, true);
                            CTabFolder2.this.setFocus();
                        }
                        shell.dispose();
                    }
                }
            }
        };
        table.addListener(4, listener);
        table.addListener(14, listener);
        table.addListener(16, listener);
        Point size = shell.computeSize(-1, -1);
        Rectangle displayRect = this.getMonitor().getClientArea();
        Rectangle clientArea = this.getClientArea();
        size.y = Math.min(displayRect.height / 3, size.y);
        shell.setSize(size);
        Point p1 = this.getDisplay().map(this, null, clientArea.x, clientArea.y);
        Point p2 = this.getDisplay().map(this, null, rect.x, rect.y);
        int x = 0;
        int y = 0;
        x = alignment == 16384 ? p2.x : p2.x + rect.width - size.x;
        if (x < displayRect.x) {
            x = displayRect.x;
        }
        if (x + size.x > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - size.x;
        }
        if (this.onBottom) {
            y = p1.y + clientArea.height - size.y;
            if (y < displayRect.y) {
                y = p2.y + rect.height;
            }
        } else {
            y = p1.y;
            if (y + size.y > displayRect.y + displayRect.height) {
                y = p2.y - size.y;
            }
        }
        shell.setLocation(x, y);
        shell.open();
        table.setFocus();
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void showToolTip(int x, int y) {
        Listener[] listener;
        final Shell tip = new Shell(this.getShell(), 16384);
        final Label label = new Label(tip, 0x1000000);
        Display display = tip.getDisplay();
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        if (!this.updateToolTip(x, y, label)) {
            tip.dispose();
            return;
        }
        final int[] events = new int[]{7, 32, 5};
        listener = new Listener[]{new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 32: {
                        if (CTabFolder2.this.updateToolTip(event.x, event.y, label)) break;
                    }
                    case 7: {
                        int i = 0;
                        while (i < events.length) {
                            CTabFolder2.this.removeListener(events[i], listener[0]);
                            ++i;
                        }
                        tip.dispose();
                        CTabFolder2.this.tipShowing = false;
                    }
                }
            }
        }};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener[0]);
            ++i;
        }
        this.tipShowing = true;
        tip.setVisible(true);
    }

    boolean updateItems() {
        boolean changed = false;
        if (this.setItemSize()) {
            changed = true;
        }
        if (this.setItemLocation()) {
            changed = true;
        }
        if (this.setButtonBounds()) {
            changed = true;
        }
        return changed;
    }

    boolean updateTabHeight(int oldHeight) {
        int index;
        if (!this.fixedTabHeight) {
            int tempHeight = 0;
            GC gc = new GC(this);
            int i = 0;
            while (i < this.items.length) {
                tempHeight = Math.max(tempHeight, this.items[i].preferredHeight(gc));
                ++i;
            }
            gc.dispose();
            this.tabHeight = tempHeight;
        }
        if (this.tabHeight == oldHeight) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            this.curve = CTabFolder2.bezier(0, this.tabHeight + 2, 30, this.tabHeight + 2, 20, 1, 50, 1, 50);
            index = -1;
            int i = 0;
            while (i < this.curve.length / 2) {
                if (this.curve[2 * i + 1] <= this.tabHeight) break;
                index = i++;
            }
            if (index > 0) {
                int[] newCurve = new int[this.curve.length - 2 * (index - 1)];
                System.arraycopy(this.curve, 2 * (index - 1), newCurve, 0, newCurve.length);
                this.curve = newCurve;
            }
        } else {
            this.curve = CTabFolder2.bezier(0, 0, 30, 0, 20, this.tabHeight + 2, 50, this.tabHeight + 2, 50);
            index = -1;
            int i = 0;
            while (i < this.curve.length / 2) {
                if (this.curve[2 * i + 1] > this.tabHeight) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index > 0) {
                int[] newCurve = new int[2 * (index - 1)];
                System.arraycopy(this.curve, 0, newCurve, 0, newCurve.length);
                this.curve = newCurve;
            }
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    boolean updateToolTip(int x, int y, Label label) {
        CTabItem2 item = this.getItem(new Point(x, y));
        if (item == null) {
            return false;
        }
        String tooltip = item.getToolTipText();
        if (tooltip == null) {
            return false;
        }
        if (tooltip.equals(label.getText())) {
            return true;
        }
        Shell tip = label.getShell();
        label.setText(tooltip);
        Point labelSize = label.computeSize(-1, -1);
        labelSize.x += 2;
        labelSize.y += 2;
        label.setSize(labelSize);
        tip.pack();
        Rectangle area = tip.getClientArea();
        label.setSize(area.width, area.height);
        Point cursorLocation = this.getDisplay().getCursorLocation();
        int cursorHeight = 21;
        Point size = tip.getSize();
        Rectangle rect = tip.getMonitor().getBounds();
        Point pt = new Point(cursorLocation.x, cursorLocation.y + cursorHeight + 2);
        pt.x = Math.max(pt.x, rect.x);
        if (pt.x + size.x > rect.x + rect.width) {
            pt.x = rect.x + rect.width - size.x;
        }
        if (pt.y + size.y > rect.y + rect.height) {
            pt.y = cursorLocation.y - 2 - size.y;
        }
        tip.setLocation(pt);
        return true;
    }
}

