/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CBanner
extends Composite {
    Control left;
    Control middle;
    Control right;
    int[] curve;
    int curveStart;
    static final int OFFSCREEN = -200;
    static final int CURVE_WIDTH = 50;
    static final int CURVE_RIGHT = 30;
    static final int CURVE_LEFT = 30;
    static final int LEFT_MIDDLE_GAP = 8;
    static final int BORDER_BOTTOM = 2;
    static final int BORDER_TOP = 3;
    static final int BORDER_LEFT = 2;
    static final int BORDER_RIGHT = 2;
    static final int BORDER_STRIPE = 2;
    static final int INDENT = 5;
    static RGB BORDER1 = null;
    static RGB BORDER2 = null;

    public CBanner(Composite parent, int style) {
        super(parent, CBanner.checkStyle(style));
        if (BORDER1 == null) {
            BORDER1 = this.getDisplay().getSystemColor(18).getRGB();
        }
        if (BORDER2 == null) {
            BORDER2 = this.getDisplay().getSystemColor(18).getRGB();
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CBanner.this.onPaint(event.gc);
            }
        });
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CBanner.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                CBanner.this.onDispose();
            }
        });
    }

    static int[] bezier(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3, int count) {
        double a0 = x0;
        double a1 = 3 * (x1 - x0);
        double a2 = 3 * (x0 + x2 - 2 * x1);
        double a3 = x3 - x0 + 3 * x1 - 3 * x2;
        double b0 = y0;
        double b1 = 3 * (y1 - y0);
        double b2 = 3 * (y0 + y2 - 2 * y1);
        double b3 = y3 - y0 + 3 * y1 - 3 * y2;
        int[] polygon = new int[2 * count + 2];
        int i = 0;
        while (i <= count) {
            double t = (double)i / (double)count;
            polygon[2 * i] = (int)(a0 + a1 * t + a2 * t * t + a3 * t * t * t);
            polygon[2 * i + 1] = (int)(b0 + b1 * t + b2 * t * t + b3 * t * t * t);
            ++i;
        }
        return polygon;
    }

    static int checkStyle(int style) {
        return 262144;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point rightSize = new Point(0, 0);
        if (this.right != null) {
            rightSize = this.right.computeSize(-1, hHint);
        }
        Point middleSize = new Point(0, 0);
        if (this.middle != null) {
            middleSize = this.middle.computeSize(-1, hHint);
        }
        Point leftSize = new Point(0, 0);
        if (this.left != null) {
            int width = wHint - rightSize.x - middleSize.x - 50 - 10 - 2 - 2;
            if (this.middle != null) {
                width -= 8;
            }
            leftSize = this.left.computeSize(wHint != -1 ? width : -1, -1);
        }
        Point size = new Point(0, 0);
        size.x = leftSize.x + middleSize.x + 50 - 10 + rightSize.x;
        if (this.left != null && this.middle != null) {
            size.x += 8;
        }
        size.y = Math.max(Math.max(leftSize.y, middleSize.y), rightSize.y);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - 2;
        int trimY = y - 3;
        int trimWidth = width + 2 + 2;
        int trimHeight = height + 3 + 2 + 4;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public Rectangle getClientArea() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Control getLeft() {
        this.checkWidget();
        return this.left;
    }

    public Control getMiddle() {
        this.checkWidget();
        return this.middle;
    }

    public Control getRight() {
        this.checkWidget();
        return this.right;
    }

    public void layout(boolean changed) {
        int y;
        int height;
        this.checkWidget();
        Point size = this.getSize();
        Point rightSize = this.right == null ? new Point(0, 0) : this.right.computeSize(-1, -1);
        Point middleSize = this.middle == null ? new Point(0, 0) : this.middle.computeSize(-1, -1);
        int width = size.x - rightSize.x - middleSize.x - 50 + 10 - 2 - 2;
        if (this.middle != null) {
            width -= 8;
        }
        Point leftSize = this.left == null ? new Point(0, 0) : this.left.computeSize(width, -1);
        int x = 2;
        int oldStart = this.curveStart;
        Rectangle leftRect = null;
        Rectangle middleRect = null;
        Rectangle rightRect = null;
        if (this.left != null) {
            height = size.y - 3 - 2 - 2;
            y = 5;
            leftRect = new Rectangle(x, y, leftSize.x, Math.min(height, leftSize.y));
            x += leftSize.x;
        }
        if (this.middle != null) {
            if (this.left != null) {
                x += 8;
            }
            height = Math.min(size.y - 3 - 2 - 4, middleSize.y);
            y = 5;
            middleRect = new Rectangle(x, y, middleSize.x, height);
            x += middleSize.x;
        }
        this.curveStart = x - 5;
        x += 40;
        if (this.right != null) {
            height = Math.min(size.y - 3 - 2 - 4, rightSize.y);
            y = 5;
            rightRect = new Rectangle(x, y, rightSize.x, height);
        }
        if (this.curveStart < oldStart) {
            this.redraw(this.curveStart, 0, oldStart + 50 - this.curveStart, size.y, false);
        }
        if (this.curveStart > oldStart) {
            this.redraw(oldStart, 0, this.curveStart + 50 - oldStart, size.y, false);
        }
        this.update();
        if (leftRect != null) {
            this.left.setBounds(leftRect);
        }
        if (middleRect != null) {
            this.middle.setBounds(middleRect);
        }
        if (rightRect != null) {
            this.right.setBounds(rightRect);
        }
    }

    private void onDispose() {
        this.left = null;
        this.right = null;
    }

    private void onPaint(GC gc) {
        if (this.curve == null) {
            this.updateCurve();
        }
        Point size = this.getSize();
        Color background = this.getBackground();
        gc.setBackground(background);
        gc.fillRectangle(0, 0, size.x, size.y);
        int[] line1 = new int[this.curve.length + 6];
        int[] line2 = new int[this.curve.length + 6];
        int index = 0;
        int x = this.curveStart;
        int y = 0;
        line1[index] = x + 1;
        line2[index++] = x + 1;
        line1[index] = size.y - 2;
        line2[index++] = size.y - 2 + 1;
        int i = 0;
        while (i < this.curve.length / 2) {
            line1[index] = x + this.curve[2 * i];
            line2[index++] = x + this.curve[2 * i];
            line1[index] = y + this.curve[2 * i + 1];
            line2[index++] = y + this.curve[2 * i + 1] + 1;
            ++i;
        }
        line1[index] = x + 50;
        line2[index++] = x + 50;
        line1[index] = 0;
        line2[index++] = 1;
        line1[index] = size.x;
        line2[index++] = size.x;
        line1[index] = 0;
        line2[index++] = 1;
        int x1 = Math.max(0, this.curveStart - 200);
        Color border2 = new Color(this.getDisplay(), BORDER2);
        gc.setForeground(background);
        gc.setBackground(border2);
        gc.fillGradientRectangle(x1, size.y - 2 + 1, this.curveStart - x1 + 1, 1, false);
        gc.setForeground(border2);
        gc.drawPolyline(line2);
        border2.dispose();
        Color border1 = new Color(this.getDisplay(), BORDER1);
        gc.setForeground(background);
        gc.setBackground(border1);
        gc.fillGradientRectangle(x1, size.y - 2, this.curveStart - x1 + 1, 1, false);
        gc.setForeground(border1);
        gc.drawPolyline(line1);
        border1.dispose();
    }

    private void onResize() {
        this.updateCurve();
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setLeft(Control leftControl) {
        this.checkWidget();
        if (leftControl != null && leftControl.getParent() != this) {
            SWT.error(5);
        }
        if (this.left != null && !this.left.isDisposed()) {
            this.left.setBounds(-200, -200, 0, 0);
        }
        this.left = leftControl;
        this.layout();
    }

    public void setMiddle(Control middleControl) {
        this.checkWidget();
        if (middleControl != null && middleControl.getParent() != this) {
            SWT.error(5);
        }
        if (this.middle != null && !this.middle.isDisposed()) {
            this.middle.setBounds(-200, -200, 0, 0);
        }
        this.middle = middleControl;
        this.layout();
    }

    public void setRight(Control rightControl) {
        this.checkWidget();
        if (rightControl != null && rightControl.getParent() != this) {
            SWT.error(5);
        }
        if (this.right != null && !this.right.isDisposed()) {
            this.right.setBounds(-200, -200, 0, 0);
        }
        this.right = rightControl;
        this.layout();
    }

    void updateCurve() {
        Point size = this.getSize();
        this.curve = CBanner.bezier(0, size.y - 2 + 1, 30, size.y - 2 + 1, 20, 0, 50, 0, 50);
        int index = -1;
        int i = 0;
        while (i < this.curve.length / 2) {
            if (this.curve[2 * i + 1] <= size.y - 2) break;
            index = i++;
        }
        if (index > -1) {
            int[] newCurve = new int[this.curve.length - 2 * (index + 1)];
            System.arraycopy(this.curve, 2 * (index + 1), newCurve, 0, newCurve.length);
            this.curve = newCurve;
        }
    }
}

