/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiEditorInput;

public abstract class MultiEditor
extends EditorPart {
    private int activeEditorIndex;
    private IEditorPart[] innerEditors;

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.innerEditors.length) {
            IEditorPart e = this.innerEditors[i];
            e.doSave(monitor);
            ++i;
        }
    }

    public Composite createInnerPartControl(Composite parent, final IEditorPart e) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new FillLayout());
        e.createPartControl(content);
        parent.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    MultiEditor.this.activateEditor(e);
                }
            }
        });
        return content;
    }

    public void dispose() {
        super.dispose();
        IEditorPart[] editors = this.getInnerEditors();
        int i = 0;
        while (i < editors.length) {
            editors[i].dispose();
            ++i;
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.init(site, (MultiEditorInput)input);
    }

    public void init(IEditorSite site, MultiEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite(site);
        this.setTitle(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public boolean isDirty() {
        int i = 0;
        while (i < this.innerEditors.length) {
            IEditorPart e = this.innerEditors[i];
            if (e.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.innerEditors[this.activeEditorIndex].setFocus();
        this.updateGradient(this.innerEditors[this.activeEditorIndex]);
    }

    public final IEditorPart getActiveEditor() {
        return this.innerEditors[this.activeEditorIndex];
    }

    public final IEditorPart[] getInnerEditors() {
        return this.innerEditors;
    }

    public final void setChildren(IEditorPart[] children) {
        this.innerEditors = children;
        this.activeEditorIndex = 0;
    }

    protected void activateEditor(IEditorPart part) {
        IEditorPart oldEditor = this.getActiveEditor();
        this.activeEditorIndex = this.getIndex(part);
        IEditorPart e = this.getActiveEditor();
        EditorSite innerSite = (EditorSite)e.getEditorSite();
        ((WorkbenchPage)innerSite.getPage()).requestActivation(e);
        this.updateGradient(oldEditor);
    }

    protected int getIndex(IEditorPart editor) {
        int i = 0;
        while (i < this.innerEditors.length) {
            if (this.innerEditors[i] == editor) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void updateGradient(IEditorPart editor) {
        boolean activePart;
        boolean activeEditor = editor == this.getSite().getPage().getActiveEditor();
        boolean bl = activePart = editor == this.getSite().getPage().getActivePart();
        Gradient g = activePart ? (this.getShellActivated() ? Gradient.BLUE : Gradient.BLACK) : (activeEditor ? Gradient.WHITE : Gradient.GRAY);
        this.drawGradient(editor, g);
    }

    protected abstract void drawGradient(IEditorPart var1, Gradient var2);

    protected boolean getShellActivated() {
        WorkbenchWindow window = (WorkbenchWindow)this.getSite().getPage().getWorkbenchWindow();
        return window.getShellActivated();
    }

    public static class Gradient {
        public Color fgColor;
        public Color[] bgColors;
        public int[] bgPercents;
        private static Gradient BLUE = new Gradient();
        private static Gradient BLACK = new Gradient();
        private static Gradient GRAY = new Gradient();
        private static Gradient WHITE = new Gradient();

        static {
            Gradient.BLUE.fgColor = WorkbenchColors.getSystemColor(30);
            Gradient.BLUE.bgColors = WorkbenchColors.getActiveEditorGradient();
            Gradient.BLUE.bgPercents = WorkbenchColors.getActiveEditorGradientPercents();
            Gradient.BLACK.fgColor = WorkbenchColors.getSystemColor(33);
            Gradient.BLACK.bgColors = WorkbenchColors.getDeactivatedEditorGradient();
            Gradient.BLACK.bgPercents = WorkbenchColors.getDeactivatedEditorGradientPercents();
            Gradient.WHITE.fgColor = WorkbenchColors.getSystemColor(2);
            Gradient.WHITE.bgColors = WorkbenchColors.getActiveNoFocusEditorGradient();
            Gradient.WHITE.bgPercents = WorkbenchColors.getActiveNoFocusEditorGradientPercents();
            Gradient.GRAY.fgColor = null;
            Gradient.GRAY.bgColors = null;
            Gradient.GRAY.bgPercents = null;
        }
    }
}

