/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class StatusLineContributionItem
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private CLabel label;
    private Composite statusLine = null;
    private String text = "";
    private int widthHint = -1;

    public StatusLineContributionItem(String id) {
        this(id, 40);
    }

    public StatusLineContributionItem(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        this.statusLine = parent;
        this.label = new CLabel(this.statusLine, 4);
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        if (this.widthHint < 0) {
            GC gc = new GC((Drawable)this.statusLine);
            gc.setFont(this.statusLine.getFont());
            this.widthHint = gc.getFontMetrics().getAverageCharWidth() * this.charWidth;
            gc.dispose();
        }
        statusLineLayoutData.widthHint = this.widthHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
    }

    public Point getDisplayLocation() {
        if (this.label != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.label.getLocation());
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager contributionManager = this.getParent();
                if (contributionManager != null) {
                    contributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }
}

