/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;

public class ViewRegistry
implements IViewRegistry {
    private List views = new ArrayList();
    private List categories = new ArrayList();
    private Category miscCategory;

    public void add(Category desc) {
        if (this.findCategory(desc.getId()) == null) {
            this.categories.add(desc);
        }
    }

    public void add(IViewDescriptor desc) {
        this.views.add(desc);
    }

    public IViewDescriptor find(String id) {
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public Category findCategory(String id) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category cat = (Category)iterator.next();
            if (!id.equals(cat.getRootPath())) continue;
            return cat;
        }
        return null;
    }

    public Category[] getCategories() {
        int nSize = this.categories.size();
        Category[] retArray = new Category[nSize];
        this.categories.toArray(retArray);
        return retArray;
    }

    public int getCategoryCount() {
        return this.categories.size();
    }

    public Category getMiscCategory() {
        return this.miscCategory;
    }

    public int getViewCount() {
        return this.views.size();
    }

    public IViewDescriptor[] getViews() {
        int nSize = this.views.size();
        IViewDescriptor[] retArray = new IViewDescriptor[nSize];
        this.views.toArray(retArray);
        return retArray;
    }

    public void mapViewsToCategories() {
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor desc = (IViewDescriptor)iterator.next();
            Category cat = null;
            String[] catPath = desc.getCategoryPath();
            if (catPath != null) {
                String rootCat = catPath[0];
                cat = this.findCategory(rootCat);
            }
            if (cat != null) {
                cat.addElement(desc);
                continue;
            }
            if (this.miscCategory == null) {
                this.miscCategory = new Category();
                this.categories.add(this.miscCategory);
            }
            if (catPath != null) {
                String fmt = "Category {0} not found for view {1}.  This view added to ''{2}'' category.";
                WorkbenchPlugin.log(MessageFormat.format(fmt, catPath[0], desc.getID(), this.miscCategory.getLabel()));
            }
            this.miscCategory.addElement(desc);
        }
    }
}

