/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineWithProgressManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

class WorkbenchMonitorProvider {
    List workingMonitors = Collections.synchronizedList(new ArrayList());
    RefreshJob refreshJob = new RefreshJob();

    WorkbenchMonitorProvider() {
    }

    IProgressMonitor getMonitor(Job job) {
        if (job instanceof RefreshJob) {
            return new NullProgressMonitor();
        }
        if (job instanceof UIJob) {
            return this.getUIProgressMonitor(job.getName());
        }
        return this.getBackgroundProgressMonitor(job.getName());
    }

    private IStatusLineWithProgressManager getStatusLineManager() {
        StatusLineManager manager;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window instanceof WorkbenchWindow && (manager = ((WorkbenchWindow)window).getStatusLineManager()) instanceof IStatusLineWithProgressManager) {
            return (IStatusLineWithProgressManager)manager;
        }
        return null;
    }

    private IProgressMonitor getBackgroundProgressMonitor(String jobName) {
        return new BackgroundProgressMonitor(jobName);
    }

    private IProgressMonitor getUIProgressMonitor(final String jobName) {
        return new IProgressMonitor(){
            IProgressMonitor internalMonitor;

            public void beginTask(String name, int totalWork) {
                if (name == null || name.length() == 0) {
                    this.getInternalMonitor().beginTask(jobName, totalWork);
                } else {
                    this.getInternalMonitor().beginTask(name, totalWork);
                }
            }

            public void done() {
                this.getInternalMonitor().done();
            }

            public void internalWorked(double work) {
                this.getInternalMonitor().internalWorked(work);
            }

            public boolean isCanceled() {
                return this.getInternalMonitor().isCanceled();
            }

            public void setCanceled(boolean value) {
                this.getInternalMonitor().setCanceled(value);
            }

            public void setTaskName(String name) {
                this.getInternalMonitor().setTaskName(name);
            }

            public void subTask(String name) {
                this.getInternalMonitor().subTask(name);
            }

            public void worked(int work) {
                this.getInternalMonitor().worked(work);
            }

            private IProgressMonitor getInternalMonitor() {
                if (this.internalMonitor == null) {
                    IStatusLineWithProgressManager manager = WorkbenchMonitorProvider.this.getStatusLineManager();
                    this.internalMonitor = manager == null ? new NullProgressMonitor() : manager.getProgressMonitor();
                }
                return this.internalMonitor;
            }
        };
    }

    BackgroundProgressMonitor nextMonitor(IProgressMonitor finishedMonitor) {
        this.workingMonitors.remove(finishedMonitor);
        if (this.workingMonitors.size() > 0) {
            return (BackgroundProgressMonitor)this.workingMonitors.get(0);
        }
        return null;
    }

    private class BackgroundProgressMonitor
    implements IProgressMonitor {
        double allWork;
        double worked;
        String taskName;
        String subTask = "";

        BackgroundProgressMonitor(String jobName) {
            this.taskName = jobName;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                this.taskName = name;
            }
            this.allWork = totalWork;
            this.subTask = "";
            this.worked = 0.0;
            this.updateMessage();
        }

        public void done() {
            if (PlatformUI.isWorkbenchRunning()) {
                WorkbenchMonitorProvider.this.refreshJob.clearStatusLine();
            }
            WorkbenchMonitorProvider.this.refreshJob.schedule(100L);
        }

        public void internalWorked(double work) {
            this.worked += work;
            if (this.worked >= this.allWork) {
                this.done();
            } else {
                this.updateMessage();
            }
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
            this.taskName = name;
            this.updateMessage();
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        private void updateMessage() {
            if (PlatformUI.isWorkbenchRunning() && WorkbenchMonitorProvider.this.refreshJob.setMessage(this.getDisplayString())) {
                WorkbenchMonitorProvider.this.refreshJob.schedule(100L);
            }
        }

        String getDisplayString() {
            if (this.worked == -1.0) {
                if (this.subTask.length() == 0) {
                    return this.taskName;
                }
                return ProgressMessages.format("MonitorProvider.twoValueUnknownMessage", new String[]{this.taskName, this.subTask});
            }
            int done = (int)(this.worked * 100.0 / this.allWork);
            String percentDone = String.valueOf(done);
            if (this.subTask.length() == 0) {
                return ProgressMessages.format("MonitorProvider.oneValueMessage", new String[]{this.taskName, percentDone});
            }
            return ProgressMessages.format("MonitorProvider.twoValueMessage", new String[]{this.taskName, this.subTask, String.valueOf(done)});
        }
    }

    private class RefreshJob
    extends WorkbenchJob {
        String message;
        boolean clear = false;

        public RefreshJob() {
            super(ProgressMessages.getString("StatusLineProgressListener.Refresh"));
            this.setPriority(50);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IStatusLineWithProgressManager manager = WorkbenchMonitorProvider.this.getStatusLineManager();
            if (manager == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.clear) {
                this.clear = false;
                BackgroundProgressMonitor next = WorkbenchMonitorProvider.this.nextMonitor(monitor);
                if (next == null) {
                    manager.clearProgress();
                } else {
                    manager.setProgressMessage(next.getDisplayString());
                }
            } else {
                manager.setProgressMessage(this.message);
            }
            return Status.OK_STATUS;
        }

        synchronized boolean setMessage(String newMessage) {
            if (newMessage.equals(this.message)) {
                return false;
            }
            this.message = newMessage;
            return true;
        }

        synchronized void clearStatusLine() {
            this.clear = true;
        }
    }
}

