/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;
import org.eclipse.ui.progress.WorkbenchJob;

class ProgressViewUpdater
implements IJobProgressManagerListener {
    private static ProgressViewUpdater singleton;
    private ProgressContentProvider[] contentProviders;
    Job updateJob;
    UpdatesInfo currentInfo = new UpdatesInfo();
    Object updateLock = new Object();
    boolean debug = false;

    static ProgressViewUpdater getSingleton() {
        if (singleton == null) {
            singleton = new ProgressViewUpdater();
        }
        return singleton;
    }

    static boolean hasSingleton() {
        return singleton != null;
    }

    static void clearSingleton() {
        if (singleton != null) {
            ProgressManager.getInstance().removeListener(singleton);
        }
        singleton = null;
    }

    private ProgressViewUpdater() {
        this.createUpdateJob();
        this.contentProviders = new ProgressContentProvider[0];
        ProgressManager.getInstance().addListener(this);
    }

    void addContentProvider(ProgressContentProvider newProvider) {
        ProgressContentProvider[] newProviders = new ProgressContentProvider[this.contentProviders.length + 1];
        System.arraycopy(this.contentProviders, 0, newProviders, 0, this.contentProviders.length);
        newProviders[this.contentProviders.length] = newProvider;
        this.contentProviders = newProviders;
    }

    void removeContentProvider(ProgressContentProvider provider) {
        HashSet<ProgressContentProvider> newProviders = new HashSet<ProgressContentProvider>();
        int i = 0;
        while (i < this.contentProviders.length) {
            if (!this.contentProviders[i].equals(provider)) {
                newProviders.add(this.contentProviders[i]);
            }
            ++i;
        }
        ProgressContentProvider[] newArray = new ProgressContentProvider[newProviders.size()];
        newProviders.toArray(newArray);
        this.contentProviders = newArray;
        if (this.contentProviders.length == 0) {
            ProgressViewUpdater.clearSingleton();
        }
    }

    void scheduleUpdate() {
        if (PlatformUI.isWorkbenchRunning()) {
            this.updateJob.schedule(100L);
        }
    }

    private void createUpdateJob() {
        this.updateJob = new WorkbenchJob(ProgressMessages.getString("ProgressContentProvider.UpdateProgressJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ProgressViewUpdater.this.contentProviders.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressViewUpdater.this.currentInfo.updateAll) {
                    int i = 0;
                    while (i < ProgressViewUpdater.this.contentProviders.length) {
                        ((ProgressViewUpdater)ProgressViewUpdater.this).contentProviders[i].viewer.refresh(true);
                        ++i;
                    }
                } else {
                    Object[] deletionItems;
                    Object[] additionItems;
                    Object[] updateItems;
                    Object object = ProgressViewUpdater.this.updateLock;
                    synchronized (object) {
                        ProgressViewUpdater.this.currentInfo.processForUpdate();
                        updateItems = ProgressViewUpdater.this.currentInfo.refreshes.toArray();
                        additionItems = ProgressViewUpdater.this.currentInfo.additions.toArray();
                        deletionItems = ProgressViewUpdater.this.currentInfo.deletions.toArray();
                    }
                    int v = 0;
                    while (v < ProgressViewUpdater.this.contentProviders.length) {
                        ProgressTreeViewer viewer = ((ProgressViewUpdater)ProgressViewUpdater.this).contentProviders[v].viewer;
                        int i = 0;
                        while (i < updateItems.length) {
                            viewer.refresh(updateItems[i], true);
                            ++i;
                        }
                        viewer.add(viewer.getInput(), additionItems);
                        viewer.remove(deletionItems);
                        ++v;
                    }
                }
                Object object = ProgressViewUpdater.this.updateLock;
                synchronized (object) {
                    ProgressViewUpdater.this.currentInfo.reset();
                }
                return Status.OK_STATUS;
            }
        };
        this.updateJob.setSystem(true);
        this.updateJob.setPriority(50);
    }

    UpdatesInfo getCurrentInfo() {
        return this.currentInfo;
    }

    public void refresh(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(info);
        }
        this.scheduleUpdate();
    }

    public void refreshAll() {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.updateAll = true;
        }
        this.scheduleUpdate();
    }

    public void add(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.add(info);
        }
        this.scheduleUpdate();
    }

    public void remove(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.remove(info);
        }
        this.scheduleUpdate();
    }

    public boolean showsDebug() {
        return this.debug;
    }

    boolean isUpdateJob(Job job) {
        return job.equals(this.updateJob);
    }

    class UpdatesInfo {
        Collection additions = new HashSet();
        Collection deletions = new HashSet();
        Collection refreshes = new HashSet();
        boolean updateAll = false;

        private UpdatesInfo() {
        }

        void add(JobInfo addition) {
            this.additions.add(addition);
        }

        void remove(JobInfo removal) {
            this.deletions.add(removal);
        }

        void refresh(JobInfo refresh) {
            this.refreshes.add(refresh);
        }

        void reset() {
            this.additions.clear();
            this.deletions.clear();
            this.refreshes.clear();
        }

        void processForUpdate() {
            HashSet<JobInfo> staleAdditions = new HashSet<JobInfo>();
            Iterator additionsIterator = this.additions.iterator();
            while (additionsIterator.hasNext()) {
                JobInfo next = (JobInfo)additionsIterator.next();
                if (!this.deletions.contains(next) && next.getJob().getState() != 0) continue;
                staleAdditions.add(next);
            }
            this.additions.removeAll(staleAdditions);
            HashSet<JobInfo> obsoleteRefresh = new HashSet<JobInfo>();
            Iterator refreshIterator = this.refreshes.iterator();
            while (refreshIterator.hasNext()) {
                JobInfo next = (JobInfo)refreshIterator.next();
                if (this.deletions.contains(next) || this.additions.contains(next)) {
                    obsoleteRefresh.add(next);
                }
                if (next.getJob().getState() != 0) continue;
                obsoleteRefresh.add(next);
                this.deletions.add(next);
            }
            this.refreshes.removeAll(obsoleteRefresh);
        }
    }
}

