/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.part.ViewPart;

public class ProgressView
extends ViewPart
implements IViewPart {
    ProgressTreeViewer viewer;
    Action cancelAction;
    Action deleteAction;
    Action showErrorAction;
    Action clearErrorsAction;

    public void createPartControl(Composite parent) {
        this.viewer = new ProgressTreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(this.getViewerSorter());
        this.initContentProvider();
        this.initLabelProvider();
        this.initContextMenu();
        this.initPulldownMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
    }

    protected void initContentProvider() {
        ProgressContentProvider provider = new ProgressContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
    }

    protected void initLabelProvider() {
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.createCancelAction();
        this.createDeleteAction();
        this.createShowErrorAction();
        this.createClearErrorsAction();
        menuMgr.add((IAction)this.cancelAction);
        menuMgr.add((IAction)this.deleteAction);
        menuMgr.add((IAction)this.showErrorAction);
        menuMgr.add((IAction)this.clearErrorsAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProgressView.this.deleteAction.setEnabled(false);
                ProgressView.this.showErrorAction.setEnabled(false);
                JobInfo info = ProgressView.this.getSelectedInfo();
                if (info == null) {
                    return;
                }
                if (info.getErrorStatus() != null) {
                    ProgressView.this.deleteAction.setEnabled(true);
                    ProgressView.this.showErrorAction.setEnabled(true);
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.viewer.getTree().setMenu(menu);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = ((ViewSite)this.getSite()).getActionBars().getMenuManager();
        menuMgr.add((IAction)new Action(ProgressMessages.getString("ProgressView.VerboseAction"), 2){

            public void run() {
                ProgressViewUpdater updater = ProgressViewUpdater.getSingleton();
                updater.debug = !updater.debug;
                this.setChecked(updater.debug);
                updater.refreshAll();
            }
        });
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection currentSelection = provider.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return null;
    }

    JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()).isJobInfo()) {
            return (JobInfo)element;
        }
        return null;
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.getString("ProgressView.CancelAction")){

            public void run() {
                JobInfo element = ProgressView.this.getSelectedInfo();
                if (element == null) {
                    return;
                }
                element.cancel();
                ProgressManager.getInstance().refresh(element);
            }
        };
    }

    private void createDeleteAction() {
        this.deleteAction = new Action(ProgressMessages.getString("ProgressView.DeleteAction")){

            public void run() {
                JobInfo element = ProgressView.this.getSelectedInfo();
                if (element == null) {
                    return;
                }
                ProgressManager.getInstance().clearJob(element.getJob());
            }
        };
    }

    private void createClearErrorsAction() {
        this.clearErrorsAction = new Action(ProgressMessages.getString("ProgressView.ClearAllAction")){

            public void run() {
                ProgressManager.getInstance().clearAllErrors();
            }
        };
    }

    private void createShowErrorAction() {
        this.showErrorAction = new Action(ProgressMessages.getString("ProgressView.ShowErrorAction")){

            public void run() {
                JobInfo element = ProgressView.this.getSelectedInfo();
                ErrorDialog.openError((Shell)ProgressView.this.viewer.getControl().getShell(), (String)element.getDisplayString(), (String)element.getErrorStatus().getMessage(), (IStatus)element.getErrorStatus());
            }
        };
    }
}

