/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class AnimationItem {
    IWorkbenchWindow window;
    Canvas imageCanvas;
    GC imageCanvasGC;

    public AnimationItem(IWorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
    }

    public void createControl(Composite parent) {
        final AnimationManager manager = AnimationManager.getInstance();
        this.imageCanvas = new Canvas(parent, 0);
        this.imageCanvas.setBackground(parent.getDisplay().getSystemColor(22));
        this.imageCanvas.setToolTipText(ProgressMessages.getString("AnimationItem.HoverHelp"));
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                AnimationItem.this.paintImage(event, manager.getImage(), manager.getImageData()[0]);
            }
        });
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnimationItem.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                ProgressManagerUtil.openProgressView(AnimationItem.this.window);
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.imageCanvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent arg0) {
                arg0.result = manager.isAnimated() ? ProgressMessages.getString("AnimationItem.InProgressStatus") : ProgressMessages.getString("AnimationItem.NotRunningStatus");
            }
        });
        this.imageCanvas.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
            }
        });
        manager.addItem(this);
    }

    void paintImage(PaintEvent event, Image image, ImageData imageData) {
        Image paintImage = image;
        int w = imageData.width;
        int h = imageData.height;
        event.gc.drawImage(paintImage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, w, h);
    }

    public Control getControl() {
        return this.imageCanvas;
    }

    public Rectangle getImageBounds() {
        return AnimationManager.getInstance().getImageBounds();
    }
}

