/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public abstract class WorkbenchWizardListSelectionPage
extends WorkbenchWizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "WizardListSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final String STORE_SELECTED_FILTERED_WIZARD_ID = "WizardListSelectionPage.STORE_SELECTED_FILTERED_WIZARD_ID";
    private static final String STORE_SELECTED_UNFILTERED_WIZARD_ID = "WizardListSelectionPage.STORE_SELECTED_UNFILTERED_WIZARD_ID";
    private static final String UNFILTERED_TAB_SELECTED = "WizardListSelectionPage..UNFILTERED_TAB_SELECTED";
    private TableViewer filteredViewer;
    private TableViewer unfilteredViewer;
    private String message;
    private TabFolder tabFolder;

    protected WorkbenchWizardListSelectionPage(IWorkbench aWorkbench, IStructuredSelection currentSelection, AdaptableList wizardElements, String message) {
        super("singleWizardSelectionPage", aWorkbench, currentSelection, wizardElements);
        this.setDescription(WorkbenchMessages.getString("WizardList.description"));
        this.message = message;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(272));
        outerContainer.setFont(font);
        Label messageLabel = new Label(outerContainer, 0);
        messageLabel.setText(this.message);
        messageLabel.setFont(font);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.tabFolder = new TabFolder(outerContainer, 0);
            this.layoutTopControl((Control)this.tabFolder);
            this.tabFolder.setFont(parent.getFont());
            this.filteredViewer = this.createViewer((Composite)this.tabFolder, true);
            this.unfilteredViewer = this.createViewer((Composite)this.tabFolder, false);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WorkbenchWizardListSelectionPage.this.tabFolder.getSelectionIndex() == 0) {
                        WorkbenchWizardListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)WorkbenchWizardListSelectionPage.this.filteredViewer, WorkbenchWizardListSelectionPage.this.filteredViewer.getSelection()));
                    } else {
                        WorkbenchWizardListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)WorkbenchWizardListSelectionPage.this.unfilteredViewer, WorkbenchWizardListSelectionPage.this.unfilteredViewer.getSelection()));
                    }
                }
            });
        } else {
            this.unfilteredViewer = this.createViewer(outerContainer, false);
            this.layoutTopControl(this.unfilteredViewer.getControl());
        }
        this.restoreWidgetValues();
        this.setControl((Control)outerContainer);
    }

    private TableViewer createViewer(Composite parent, boolean filtering) {
        Table table = new Table(parent, 2048);
        table.setFont(parent.getFont());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new WizardContentProvider(filtering));
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.setInput((Object)this.wizardElements);
        if (parent instanceof TabFolder) {
            TabItem tabItem = new TabItem((TabFolder)parent, 0);
            tabItem.setControl(viewer.getControl());
            tabItem.setText(filtering ? ActivityMessages.getString("ActivityFiltering.filtered") : ActivityMessages.getString("ActivityFiltering.unfiltered"));
        }
        return viewer;
    }

    protected abstract IWizardNode createWizardNode(WorkbenchWizardElement var1);

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getViewer(), event.getViewer().getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private void layoutTopControl(Control control) {
        GridData data = new GridData(1808);
        int availableRows = DialogUtil.availableRows(control.getParent());
        data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
        control.setLayoutData((Object)data);
    }

    private void restoreWidgetValues() {
        boolean unfilteredSelected = this.getDialogSettings().getBoolean(UNFILTERED_TAB_SELECTED);
        this.updateViewerSelection(this.unfilteredViewer, STORE_SELECTED_UNFILTERED_WIZARD_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.updateViewerSelection(this.filteredViewer, STORE_SELECTED_FILTERED_WIZARD_ID);
            if (unfilteredSelected) {
                this.tabFolder.setSelection(1);
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.unfilteredViewer, this.unfilteredViewer.getSelection()));
            }
        }
    }

    private void saveViewerSelection(TableViewer viewer, String key) {
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        if (sel.size() > 0) {
            WorkbenchWizardElement selectedWizard = (WorkbenchWizardElement)sel.getFirstElement();
            this.getDialogSettings().put(key, selectedWizard.getID());
        }
    }

    public void saveWidgetValues() {
        this.saveViewerSelection(this.unfilteredViewer, STORE_SELECTED_UNFILTERED_WIZARD_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.saveViewerSelection(this.filteredViewer, STORE_SELECTED_FILTERED_WIZARD_ID);
            this.getDialogSettings().put(UNFILTERED_TAB_SELECTED, this.tabFolder.getSelectionIndex() == 1);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WorkbenchWizardElement currentWizardSelection = (WorkbenchWizardElement)selection.getFirstElement();
        if (currentWizardSelection == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(currentWizardSelection));
        this.setMessage(currentWizardSelection.getDescription());
    }

    private void updateViewerSelection(TableViewer viewer, String key) {
        String wizardId = this.getDialogSettings().get(key);
        WorkbenchWizardElement wizard = this.findWizard(wizardId);
        if (wizard != null) {
            StructuredSelection selection = new StructuredSelection((Object)wizard);
            viewer.setSelection((ISelection)selection);
        }
    }
}

