/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchAdapter;

public class WorkbenchWizardElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution {
    private String id;
    private String name;
    private ImageDescriptor imageDescriptor;
    private String description;
    private SelectionEnabler selectionEnabler;
    private IConfigurationElement configurationElement;
    static /* synthetic */ Class class$0;

    public WorkbenchWizardElement(String name) {
        this.name = name;
    }

    public boolean canHandleSelection(IStructuredSelection selection) {
        return this.getSelectionEnabler().isEnabledForSelection((ISelection)selection);
    }

    public IStructuredSelection adaptedSelection(IStructuredSelection selection) {
        if (this.canHandleSelection(selection)) {
            return selection;
        }
        IStructuredSelection adaptedSelection = this.convertToResources(selection);
        if (this.canHandleSelection(adaptedSelection)) {
            return adaptedSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public Object createExecutableExtension() throws CoreException {
        return WorkbenchPlugin.createExtension(this.configurationElement, "class");
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return this.imageDescriptor;
    }

    public String getLabel(Object element) {
        return this.name;
    }

    protected SelectionEnabler getSelectionEnabler() {
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new SelectionEnabler(this.configurationElement);
        }
        return this.selectionEnabler;
    }

    public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setID(String value) {
        this.id = value;
    }

    public void setImageDescriptor(ImageDescriptor value) {
        this.imageDescriptor = value;
    }

    private IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return originalSelection;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator elements = originalSelection.iterator();
        while (elements.hasNext()) {
            Object currentElement = elements.next();
            if (resourceClass.isInstance(currentElement)) {
                result.add(currentElement);
                continue;
            }
            if (!(currentElement instanceof IAdaptable)) {
                return StructuredSelection.EMPTY;
            }
            Object adapter = ((IAdaptable)currentElement).getAdapter(resourceClass);
            if (!resourceClass.isInstance(adapter)) {
                return StructuredSelection.EMPTY;
            }
            result.add(adapter);
        }
        return new StructuredSelection(result.toArray());
    }

    public boolean fromPlugin() {
        return this.configurationElement != null;
    }

    public String getLocalId() {
        return this.getID();
    }

    public String getPluginId() {
        return this.fromPlugin() ? this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier() : null;
    }
}

