/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.dialogs.PerspContentProvider;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class SelectPerspectiveDialog
extends Dialog
implements ISelectionChangedListener {
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 200;
    private TableViewer filteredList;
    private TableViewer unfilteredList;
    private Button okButton;
    private IPerspectiveDescriptor perspDesc;
    private IPerspectiveRegistry perspReg;

    public SelectPerspectiveDialog(Shell parentShell, IPerspectiveRegistry perspReg) {
        super(parentShell);
        this.perspReg = perspReg;
    }

    protected void cancelPressed() {
        this.perspDesc = null;
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("SelectPerspective.shellTitle"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.select_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        if (WorkbenchActivityHelper.isFiltering()) {
            final TabFolder tabFolder = new TabFolder(composite, 0);
            tabFolder.setFont(parent.getFont());
            this.layoutTopControl((Control)tabFolder);
            this.filteredList = this.createViewer((Composite)tabFolder, true);
            this.unfilteredList = this.createViewer((Composite)tabFolder, false);
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tabFolder.getSelectionIndex() == 0) {
                        SelectPerspectiveDialog.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)SelectPerspectiveDialog.this.filteredList, SelectPerspectiveDialog.this.filteredList.getSelection()));
                    } else {
                        SelectPerspectiveDialog.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)SelectPerspectiveDialog.this.unfilteredList, SelectPerspectiveDialog.this.unfilteredList.getSelection()));
                    }
                }
            });
        } else {
            this.unfilteredList = this.createViewer(composite, false);
            this.layoutTopControl(this.unfilteredList.getControl());
        }
        return composite;
    }

    private TableViewer createViewer(Composite parent, boolean filtering) {
        TableViewer list = new TableViewer(parent, 2816);
        list.getTable().setFont(parent.getFont());
        list.setLabelProvider((IBaseLabelProvider)new PerspectiveLabelProvider());
        list.setContentProvider((IContentProvider)new PerspContentProvider(filtering));
        list.setSorter(new ViewerSorter());
        list.setInput((Object)this.perspReg);
        list.addSelectionChangedListener((ISelectionChangedListener)this);
        list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectPerspectiveDialog.this.handleDoubleClickEvent();
            }
        });
        if (parent instanceof TabFolder) {
            TabItem tabItem = new TabItem((TabFolder)parent, 0);
            tabItem.setControl(list.getControl());
            tabItem.setText(filtering ? ActivityMessages.getString("ActivityFiltering.filtered") : ActivityMessages.getString("ActivityFiltering.unfiltered"));
        }
        return list;
    }

    public IPerspectiveDescriptor getSelection() {
        return this.perspDesc;
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 200;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        Object obj;
        this.perspDesc = null;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (!sel.isEmpty() && (obj = sel.getFirstElement()) instanceof IPerspectiveDescriptor) {
            this.perspDesc = (IPerspectiveDescriptor)obj;
        }
    }
}

