/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceContentProvider;

public abstract class FilteredPreferenceDialog
extends PreferenceDialog {
    protected TreeViewer filteredViewer;
    protected TreeViewer unfilteredViewer;
    protected TabFolder tabFolder;

    public FilteredPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected Control createTreeAreaContents(Composite composite) {
        if (WorkbenchActivityHelper.isFiltering()) {
            this.tabFolder = new TabFolder(composite, 0);
            this.tabFolder.setFont(composite.getFont());
            this.filteredViewer = this.createTreeViewer(this.tabFolder, true);
            this.unfilteredViewer = this.createTreeViewer(this.tabFolder, false);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilteredPreferenceDialog.this.tabFolder.getSelectionIndex() == 0) {
                        FilteredPreferenceDialog.this.showPage(FilteredPreferenceDialog.this.getSingleSelection(FilteredPreferenceDialog.this.filteredViewer.getSelection()));
                    } else {
                        FilteredPreferenceDialog.this.showPage(FilteredPreferenceDialog.this.getSingleSelection(FilteredPreferenceDialog.this.unfilteredViewer.getSelection()));
                    }
                }
            });
            this.layoutTreeAreaControl((Control)this.tabFolder);
            return this.tabFolder;
        }
        this.unfilteredViewer = this.createTreeViewer(composite);
        this.unfilteredViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.unfilteredViewer.setContentProvider((IContentProvider)new FilteredPreferenceContentProvider(false));
        this.unfilteredViewer.setInput((Object)this.getPreferenceManager());
        this.layoutTreeAreaControl(this.unfilteredViewer.getControl());
        return this.unfilteredViewer.getControl();
    }

    private TreeViewer createTreeViewer(TabFolder parent, boolean filtering) {
        TreeViewer tree = this.createTreeViewer((Composite)parent);
        tree.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        tree.setContentProvider((IContentProvider)new FilteredPreferenceContentProvider(filtering));
        tree.setInput((Object)this.getPreferenceManager());
        TabItem tabItem = new TabItem(parent, 0);
        tabItem.setControl(tree.getControl());
        tabItem.setText(filtering ? ActivityMessages.getString("ActivityFiltering.filtered") : ActivityMessages.getString("ActivityFiltering.unfiltered"));
        return tree;
    }

    protected TreeViewer getTreeViewer() {
        if (this.tabFolder == null) {
            return this.unfilteredViewer;
        }
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.filteredViewer;
        }
        return this.unfilteredViewer;
    }

    protected void updateTreeFont(Font dialogFont) {
        this.unfilteredViewer.getControl().setFont(dialogFont);
        if (this.filteredViewer != null) {
            this.filteredViewer.getControl().setFont(dialogFont);
        }
    }
}

