/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts.ws;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.ContextActivationServiceEvent;
import org.eclipse.ui.contexts.ICompoundContextActivationService;
import org.eclipse.ui.contexts.IContextActivationService;
import org.eclipse.ui.contexts.IContextActivationServiceListener;
import org.eclipse.ui.contexts.IMutableContextActivationService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.contexts.IWorkbenchPageContextSupport;
import org.eclipse.ui.contexts.IWorkbenchPartSiteContextSupport;
import org.eclipse.ui.internal.contexts.AbstractContextActivationService;
import org.eclipse.ui.internal.util.Util;

final class WorkbenchWindowContextActivationService
extends AbstractContextActivationService {
    private Set activeContextIds = new HashSet();
    private final IContextActivationServiceListener contextActivationServiceListener = new IContextActivationServiceListener(){

        public void contextActivationServiceChanged(ContextActivationServiceEvent contextActivationServiceEvent) {
            WorkbenchWindowContextActivationService.this.update();
        }
    };
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchWindowContextActivationService.this.update();
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchWindowContextActivationService.this.update();
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchWindowContextActivationService.this.update();
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchWindowContextActivationService.this.update();
        }
    };
    private IWorkbench workbench;
    private IContextActivationService workbenchCompoundContextActivationService;
    private IContextActivationService workbenchPageCompoundContextActivationService;
    private IContextActivationService workbenchPartSiteMutableContextActivationService;
    private IWorkbenchWindow workbenchWindow;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    WorkbenchWindowContextActivationService(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            throw new NullPointerException();
        }
        IWorkbench workbench = workbenchWindow.getWorkbench();
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.workbenchWindow = workbenchWindow;
        this.workbench = workbench;
        workbenchWindow.addPageListener(this.pageListener);
        workbenchWindow.addPerspectiveListener(this.perspectiveListener);
        workbenchWindow.getPartService().addPartListener(this.partListener);
        this.update();
    }

    public Set getActiveContextIds() {
        return Collections.unmodifiableSet(this.activeContextIds);
    }

    private void setActiveContextIds(Set activeContextIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activeContextIds = Util.safeCopy(activeContextIds, (Class)clazz);
        if (!this.activeContextIds.equals(activeContextIds)) {
            this.activeContextIds = activeContextIds;
            this.fireContextActivationServiceChanged(new ContextActivationServiceEvent(this, true));
        }
    }

    private void update() {
        ICompoundContextActivationService workbenchCompoundContextActivationService = null;
        IWorkbenchPage workbenchPage = this.workbenchWindow.getActivePage();
        ICompoundContextActivationService workbenchPageCompoundContextActivationService = null;
        IWorkbenchPart workbenchPart = null;
        IWorkbenchPartSite workbenchPartSite = null;
        IMutableContextActivationService workbenchPartSiteMutableContextActivationService = null;
        IWorkbenchContextSupport workbenchContextSupport = this.workbench.getContextSupport();
        workbenchCompoundContextActivationService = workbenchContextSupport.getCompoundContextActivationService();
        if (workbenchPage != null) {
            IWorkbenchPageContextSupport workbenchPageContextSupport = workbenchPage.getContextSupport();
            workbenchPageCompoundContextActivationService = workbenchPageContextSupport.getCompoundContextActivationService();
            workbenchPart = workbenchPage.getActivePart();
        }
        if (workbenchPart != null) {
            workbenchPartSite = workbenchPart.getSite();
        }
        if (workbenchPartSite != null) {
            IWorkbenchPartSiteContextSupport workbenchPartSiteContextSupport;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.ui.contexts.IWorkbenchPartSiteContextSupport;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workbenchPartSiteContextSupport = (IWorkbenchPartSiteContextSupport)workbenchPartSite.getAdapter(clazz)) != null) {
                workbenchPartSiteMutableContextActivationService = workbenchPartSiteContextSupport.getMutableContextActivationService();
            }
        }
        if (this.workbenchCompoundContextActivationService != workbenchCompoundContextActivationService) {
            if (this.workbenchCompoundContextActivationService != null) {
                this.workbenchCompoundContextActivationService.removeContextActivationServiceListener(this.contextActivationServiceListener);
            }
            this.workbenchCompoundContextActivationService = workbenchCompoundContextActivationService;
            if (this.workbenchCompoundContextActivationService != null) {
                this.workbenchCompoundContextActivationService.addContextActivationServiceListener(this.contextActivationServiceListener);
            }
        }
        if (this.workbenchPageCompoundContextActivationService != workbenchPageCompoundContextActivationService) {
            if (this.workbenchPageCompoundContextActivationService != null) {
                this.workbenchPageCompoundContextActivationService.removeContextActivationServiceListener(this.contextActivationServiceListener);
            }
            this.workbenchPageCompoundContextActivationService = workbenchPageCompoundContextActivationService;
            if (this.workbenchPageCompoundContextActivationService != null) {
                this.workbenchPageCompoundContextActivationService.addContextActivationServiceListener(this.contextActivationServiceListener);
            }
        }
        if (this.workbenchPartSiteMutableContextActivationService != workbenchPartSiteMutableContextActivationService) {
            if (this.workbenchPartSiteMutableContextActivationService != null) {
                this.workbenchPartSiteMutableContextActivationService.removeContextActivationServiceListener(this.contextActivationServiceListener);
            }
            this.workbenchPartSiteMutableContextActivationService = workbenchPartSiteMutableContextActivationService;
            if (this.workbenchPartSiteMutableContextActivationService != null) {
                this.workbenchPartSiteMutableContextActivationService.addContextActivationServiceListener(this.contextActivationServiceListener);
            }
        }
        HashSet activeContextIds = new HashSet();
        if (this.workbenchCompoundContextActivationService != null) {
            activeContextIds.addAll(workbenchCompoundContextActivationService.getActiveContextIds());
        }
        if (this.workbenchPageCompoundContextActivationService != null) {
            activeContextIds.addAll(workbenchPageCompoundContextActivationService.getActiveContextIds());
        }
        if (this.workbenchPartSiteMutableContextActivationService != null) {
            activeContextIds.addAll(workbenchPartSiteMutableContextActivationService.getActiveContextIds());
        }
        this.setActiveContextIds(activeContextIds);
    }
}

