/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.contexts.ContextContextBindingDefinition;
import org.eclipse.ui.internal.contexts.ContextDefinition;
import org.eclipse.ui.internal.util.Util;

final class Persistence {
    static final String PACKAGE_BASE = "contexts";
    static final String PACKAGE_FULL = "org.eclipse.ui.contexts";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_CHILD_CONTEXT_ID = "childContextId";
    static final String TAG_CONTEXT = "context";
    static final String TAG_CONTEXT_CONTEXT_BINDING = "contextContextBinding";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT_CONTEXT_ID = "parentContextId";
    static final String TAG_PARENT_ID = "parentId";
    static final String TAG_PATTERN = "pattern";
    static final String TAG_PLUGIN_ID = "pluginId";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static ContextContextBindingDefinition readContextContextBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String childContextId = memento.getString(TAG_CHILD_CONTEXT_ID);
        String parentContextId = memento.getString(TAG_PARENT_CONTEXT_ID);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ContextContextBindingDefinition(childContextId, parentContextId, pluginId);
    }

    static List readContextContextBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ContextContextBindingDefinition> list = new ArrayList<ContextContextBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readContextContextBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static ContextDefinition readContextDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String parentId = memento.getString(TAG_PARENT_ID);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ContextDefinition(id, name, parentId, pluginId);
    }

    static List readContextDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ContextDefinition> list = new ArrayList<ContextDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readContextDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static void writeContextContextBindingDefinition(IMemento memento, ContextContextBindingDefinition contextContextBindingDefinition) {
        if (memento == null || contextContextBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_CHILD_CONTEXT_ID, contextContextBindingDefinition.getChildContextId());
        memento.putString(TAG_PARENT_CONTEXT_ID, contextContextBindingDefinition.getParentContextId());
        memento.putString(TAG_PLUGIN_ID, contextContextBindingDefinition.getPluginId());
    }

    static void writeContextContextBindingDefinitions(IMemento memento, String name, List contextContextBindingDefinitions) {
        if (memento == null || name == null || contextContextBindingDefinitions == null) {
            throw new NullPointerException();
        }
        contextContextBindingDefinitions = new ArrayList(contextContextBindingDefinitions);
        Iterator iterator = contextContextBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.contexts.ContextContextBindingDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = contextContextBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeContextContextBindingDefinition(memento.createChild(name), (ContextContextBindingDefinition)iterator.next());
        }
    }

    static void writeContextDefinition(IMemento memento, ContextDefinition contextDefinition) {
        if (memento == null || contextDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, contextDefinition.getId());
        memento.putString(TAG_NAME, contextDefinition.getName());
        memento.putString(TAG_PARENT_ID, contextDefinition.getParentId());
        memento.putString(TAG_PLUGIN_ID, contextDefinition.getPluginId());
    }

    static void writeContextDefinitions(IMemento memento, String name, List contextDefinitions) {
        if (memento == null || name == null || contextDefinitions == null) {
            throw new NullPointerException();
        }
        contextDefinitions = new ArrayList(contextDefinitions);
        Iterator iterator = contextDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.contexts.ContextDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = contextDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeContextDefinition(memento.createChild(name), (ContextDefinition)iterator.next());
        }
    }

    private Persistence() {
    }
}

