/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.contexts.ContextEvent;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextContextBinding;
import org.eclipse.ui.contexts.IContextListener;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class Context
implements IContext {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private static final Set strongReferences;
    private Set contextContextBindings;
    private transient IContextContextBinding[] contextContextBindingsAsArray;
    private List contextListeners;
    private boolean defined;
    private boolean enabled;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private String name;
    private String parentId;
    private transient String string;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.internal.contexts.Context;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
        strongReferences = new HashSet();
    }

    Context(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    public void addContextListener(IContextListener contextListener) {
        if (contextListener == null) {
            throw new NullPointerException();
        }
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList();
        }
        if (!this.contextListeners.contains(contextListener)) {
            this.contextListeners.add(contextListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Context castedObject = (Context)object;
        int compareTo = Util.compare(this.contextContextBindingsAsArray, castedObject.contextContextBindingsAsArray);
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare(this.enabled, castedObject.enabled)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.parentId), (Comparable)((Object)castedObject.parentId));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Context)) {
            return false;
        }
        Context castedObject = (Context)object;
        boolean equals = true;
        equals &= Util.equals(this.contextContextBindings, castedObject.contextContextBindings);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.enabled, castedObject.enabled);
        equals &= Util.equals(this.id, castedObject.id);
        equals &= Util.equals(this.name, castedObject.name);
        return equals &= Util.equals(this.parentId, castedObject.parentId);
    }

    void fireContextChanged(ContextEvent contextEvent) {
        if (contextEvent == null) {
            throw new NullPointerException();
        }
        if (this.contextListeners != null) {
            int i = 0;
            while (i < this.contextListeners.size()) {
                ((IContextListener)this.contextListeners.get(i)).contextChanged(contextEvent);
                ++i;
            }
        }
    }

    public Set getContextContextBindings() {
        return this.contextContextBindings;
    }

    public String getId() {
        return this.id;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public String getParentId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.parentId;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.contextContextBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.parentId);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeContextListener(IContextListener contextListener) {
        if (contextListener == null) {
            throw new NullPointerException();
        }
        if (this.contextListeners != null) {
            this.contextListeners.remove(contextListener);
        }
        if (this.contextListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setContextContextBindings(Set contextContextBindings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.contexts.IContextContextBinding;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(contextContextBindings = Util.safeCopy(contextContextBindings, (Class)clazz), this.contextContextBindings)) {
            this.contextContextBindings = contextContextBindings;
            this.contextContextBindingsAsArray = this.contextContextBindings.toArray(new IContextContextBinding[this.contextContextBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setParentId(String parentId) {
        if (!Util.equals(parentId, this.parentId)) {
            this.parentId = parentId;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.contextContextBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.parentId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

