/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.contexts.ContextActivationServiceEvent;
import org.eclipse.ui.contexts.ICompoundContextActivationService;
import org.eclipse.ui.contexts.IContextActivationService;
import org.eclipse.ui.contexts.IContextActivationServiceListener;
import org.eclipse.ui.internal.contexts.AbstractContextActivationService;
import org.eclipse.ui.internal.util.Util;

public final class CompoundContextActivationService
extends AbstractContextActivationService
implements ICompoundContextActivationService {
    private Set activeContextIds = new HashSet();
    private final IContextActivationServiceListener contextActivationServiceListener = new IContextActivationServiceListener(){

        public void contextActivationServiceChanged(ContextActivationServiceEvent contextActivationServiceEvent) {
            CompoundContextActivationService.this.update();
        }
    };
    private final HashSet contextActivationServices = new HashSet();
    static /* synthetic */ Class class$0;

    public void addContextActivationService(IContextActivationService contextActivationService) {
        if (contextActivationService == null) {
            throw new NullPointerException();
        }
        contextActivationService.addContextActivationServiceListener(this.contextActivationServiceListener);
        this.contextActivationServices.add(contextActivationService);
        this.update();
    }

    public Set getActiveContextIds() {
        return Collections.unmodifiableSet(this.activeContextIds);
    }

    public void removeContextActivationService(IContextActivationService contextActivationService) {
        if (contextActivationService == null) {
            throw new NullPointerException();
        }
        this.contextActivationServices.remove(contextActivationService);
        contextActivationService.removeContextActivationServiceListener(this.contextActivationServiceListener);
        this.update();
    }

    private void setActiveContextIds(Set activeContextIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activeContextIds = Util.safeCopy(activeContextIds, (Class)clazz);
        if (!this.activeContextIds.equals(activeContextIds)) {
            this.activeContextIds = activeContextIds;
            this.fireContextActivationServiceChanged(new ContextActivationServiceEvent(this, true));
        }
    }

    private void update() {
        HashSet activeContextIds = new HashSet();
        Iterator iterator = this.contextActivationServices.iterator();
        while (iterator.hasNext()) {
            IContextActivationService contextActivationService = (IContextActivationService)iterator.next();
            activeContextIds.addAll(contextActivationService.getActiveContextIds());
        }
        this.setActiveContextIds(activeContextIds);
    }
}

