/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.CommandHandlerServiceEvent;
import org.eclipse.ui.commands.CommandHandlerServiceFactory;
import org.eclipse.ui.commands.ICommandHandlerService;
import org.eclipse.ui.commands.ICommandHandlerServiceListener;
import org.eclipse.ui.commands.ICompoundCommandHandlerService;
import org.eclipse.ui.commands.IMutableCommandHandlerService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.IWorkbenchPageCommandSupport;
import org.eclipse.ui.commands.IWorkbenchPartSiteCommandSupport;
import org.eclipse.ui.internal.commands.AbstractCommandHandlerService;
import org.eclipse.ui.internal.util.Util;

final class WorkbenchWindowCommandHandlerService
extends AbstractCommandHandlerService {
    private final ICommandHandlerServiceListener commandHandlerServiceListener = new ICommandHandlerServiceListener(){

        public void commandHandlerServiceChanged(CommandHandlerServiceEvent commandHandlerServiceEvent) {
            WorkbenchWindowCommandHandlerService.this.update();
        }
    };
    private Map handlersByCommandId = new HashMap();
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchWindowCommandHandlerService.this.update();
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchWindowCommandHandlerService.this.update();
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchWindowCommandHandlerService.this.update();
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchWindowCommandHandlerService.this.update();
        }
    };
    private IWorkbench workbench;
    private ICommandHandlerService workbenchCompoundCommandHandlerService;
    private ICommandHandlerService workbenchPageCompoundCommandHandlerService;
    private ICommandHandlerService workbenchPartSiteMutableCommandHandlerService;
    private IWorkbenchWindow workbenchWindow;
    ICompoundCommandHandlerService localCompoundCommandHandlerService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    WorkbenchWindowCommandHandlerService(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            throw new NullPointerException();
        }
        IWorkbench workbench = workbenchWindow.getWorkbench();
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.workbenchWindow = workbenchWindow;
        this.workbench = workbench;
        workbenchWindow.addPageListener(this.pageListener);
        workbenchWindow.addPerspectiveListener(this.perspectiveListener);
        workbenchWindow.getPartService().addPartListener(this.partListener);
        this.localCompoundCommandHandlerService = CommandHandlerServiceFactory.getCompoundCommandHandlerService();
        this.localCompoundCommandHandlerService.addCommandHandlerServiceListener(this.commandHandlerServiceListener);
        this.update();
    }

    public void addCommandHandlerService(ICommandHandlerService commandHandlerService) {
        this.localCompoundCommandHandlerService.addCommandHandlerService(commandHandlerService);
        this.update();
    }

    public void removeCommandHandlerService(ICommandHandlerService commandHandlerService) {
        this.localCompoundCommandHandlerService.removeCommandHandlerService(commandHandlerService);
        this.update();
    }

    public Map getHandlersByCommandId() {
        return Collections.unmodifiableMap(this.handlersByCommandId);
    }

    private void setHandlersByCommandId(Map handlersByCommandId) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.commands.IHandler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        handlersByCommandId = Util.safeCopy(handlersByCommandId, clazz2, (Class)clazz, false, true);
        if (!this.handlersByCommandId.equals(handlersByCommandId)) {
            this.handlersByCommandId = handlersByCommandId;
            this.fireCommandHandlerServiceChanged(new CommandHandlerServiceEvent(this, true));
        }
    }

    private void update() {
        ICompoundCommandHandlerService workbenchCompoundCommandHandlerService = null;
        IWorkbenchPage workbenchPage = this.workbenchWindow.getActivePage();
        ICompoundCommandHandlerService workbenchPageCompoundCommandHandlerService = null;
        IWorkbenchPart workbenchPart = null;
        IWorkbenchPartSite workbenchPartSite = null;
        IMutableCommandHandlerService workbenchPartSiteMutableCommandHandlerService = null;
        IWorkbenchCommandSupport workbenchCommandSupport = this.workbench.getCommandSupport();
        workbenchCompoundCommandHandlerService = workbenchCommandSupport.getCompoundCommandHandlerService();
        if (workbenchPage != null) {
            IWorkbenchPageCommandSupport workbenchPageCommandSupport = workbenchPage.getCommandSupport();
            workbenchPageCompoundCommandHandlerService = workbenchPageCommandSupport.getCompoundCommandHandlerService();
            workbenchPart = workbenchPage.getActivePart();
        }
        if (workbenchPart != null) {
            workbenchPartSite = workbenchPart.getSite();
        }
        if (workbenchPartSite != null) {
            IWorkbenchPartSiteCommandSupport workbenchPartSiteCommandSupport;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Lorg.eclipse.ui.commands.IWorkbenchPartSiteCommandSupport;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workbenchPartSiteCommandSupport = (IWorkbenchPartSiteCommandSupport)workbenchPartSite.getAdapter(clazz)) != null) {
                workbenchPartSiteMutableCommandHandlerService = workbenchPartSiteCommandSupport.getMutableCommandHandlerService();
            }
        }
        if (this.workbenchCompoundCommandHandlerService != workbenchCompoundCommandHandlerService) {
            if (this.workbenchCompoundCommandHandlerService != null) {
                this.workbenchCompoundCommandHandlerService.removeCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
            this.workbenchCompoundCommandHandlerService = workbenchCompoundCommandHandlerService;
            if (this.workbenchCompoundCommandHandlerService != null) {
                this.workbenchCompoundCommandHandlerService.addCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
        }
        if (this.workbenchPageCompoundCommandHandlerService != workbenchPageCompoundCommandHandlerService) {
            if (this.workbenchPageCompoundCommandHandlerService != null) {
                this.workbenchPageCompoundCommandHandlerService.removeCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
            this.workbenchPageCompoundCommandHandlerService = workbenchPageCompoundCommandHandlerService;
            if (this.workbenchPageCompoundCommandHandlerService != null) {
                this.workbenchPageCompoundCommandHandlerService.addCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
        }
        if (this.workbenchPartSiteMutableCommandHandlerService != workbenchPartSiteMutableCommandHandlerService) {
            if (this.workbenchPartSiteMutableCommandHandlerService != null) {
                this.workbenchPartSiteMutableCommandHandlerService.removeCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
            this.workbenchPartSiteMutableCommandHandlerService = workbenchPartSiteMutableCommandHandlerService;
            if (this.workbenchPartSiteMutableCommandHandlerService != null) {
                this.workbenchPartSiteMutableCommandHandlerService.addCommandHandlerServiceListener(this.commandHandlerServiceListener);
            }
        }
        HashMap handlersByCommandId = new HashMap();
        handlersByCommandId.putAll(this.localCompoundCommandHandlerService.getHandlersByCommandId());
        if (this.workbenchCompoundCommandHandlerService != null) {
            handlersByCommandId.putAll(workbenchCompoundCommandHandlerService.getHandlersByCommandId());
        }
        if (this.workbenchPageCompoundCommandHandlerService != null) {
            handlersByCommandId.putAll(workbenchPageCompoundCommandHandlerService.getHandlersByCommandId());
        }
        if (this.workbenchPartSiteMutableCommandHandlerService != null) {
            handlersByCommandId.putAll(workbenchPartSiteMutableCommandHandlerService.getHandlersByCommandId());
        }
        this.setHandlersByCommandId(handlersByCommandId);
    }
}

