/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.CategoryDefinition;
import org.eclipse.ui.internal.commands.CommandDefinition;
import org.eclipse.ui.internal.commands.ContextBindingDefinition;
import org.eclipse.ui.internal.commands.ImageBindingDefinition;
import org.eclipse.ui.internal.commands.KeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;

final class Persistence {
    private static Map stringToValueMap = new TreeMap();
    private static final String ALT = "Alt";
    private static final String COMMAND = "Command";
    private static final String CTRL = "Ctrl";
    private static final String MODIFIER_SEPARATOR = "+";
    static final String PACKAGE_BASE = "commands";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String PACKAGE_FULL = "org.eclipse.ui.commands";
    private static final String SHIFT = "Shift";
    private static final String STROKE_SEPARATOR = " ";
    static final String TAG_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration";
    static final String TAG_ACTIVITY_BINDING = "contextBinding";
    static final String TAG_ACTIVITY_ID = "activityId";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_COMMAND = "command";
    static final String TAG_COMMAND_ID = "commandId";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_ID = "id";
    static final String TAG_IMAGE_BINDING = "imageBinding";
    static final String TAG_IMAGE_STYLE = "imageStyle";
    static final String TAG_IMAGE_URI = "imageUri";
    static final String TAG_KEY_CONFIGURATION = "keyConfiguration";
    static final String TAG_KEY_CONFIGURATION_ID = "keyConfigurationId";
    static final String TAG_KEY_SEQUENCE = "keySequence";
    static final String TAG_KEY_SEQUENCE_BINDING = "keyBinding";
    static final String TAG_LOCALE = "locale";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT_ID = "parentId";
    static final String TAG_PLATFORM = "platform";
    static final String TAG_PLUGIN_ID = "pluginId";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        stringToValueMap.put("BACKSPACE", new Integer(8));
        stringToValueMap.put("TAB", new Integer(9));
        stringToValueMap.put("RETURN", new Integer(13));
        stringToValueMap.put("ENTER", new Integer(13));
        stringToValueMap.put("ESCAPE", new Integer(27));
        stringToValueMap.put("ESC", new Integer(27));
        stringToValueMap.put("DELETE", new Integer(127));
        stringToValueMap.put("SPACE", new Integer(32));
        stringToValueMap.put("ARROW_UP", new Integer(0x1000001));
        stringToValueMap.put("ARROW_DOWN", new Integer(0x1000002));
        stringToValueMap.put("ARROW_LEFT", new Integer(0x1000003));
        stringToValueMap.put("ARROW_RIGHT", new Integer(0x1000004));
        stringToValueMap.put("PAGE_UP", new Integer(0x1000005));
        stringToValueMap.put("PAGE_DOWN", new Integer(0x1000006));
        stringToValueMap.put("HOME", new Integer(0x1000007));
        stringToValueMap.put("END", new Integer(0x1000008));
        stringToValueMap.put("INSERT", new Integer(0x1000009));
        stringToValueMap.put("F1", new Integer(0x100000A));
        stringToValueMap.put("F2", new Integer(0x100000B));
        stringToValueMap.put("F3", new Integer(0x100000C));
        stringToValueMap.put("F4", new Integer(0x100000D));
        stringToValueMap.put("F5", new Integer(0x100000E));
        stringToValueMap.put("F6", new Integer(0x100000F));
        stringToValueMap.put("F7", new Integer(0x1000010));
        stringToValueMap.put("F8", new Integer(0x1000011));
        stringToValueMap.put("F9", new Integer(0x1000012));
        stringToValueMap.put("F10", new Integer(0x1000013));
        stringToValueMap.put("F11", new Integer(0x1000014));
        stringToValueMap.put("F12", new Integer(0x1000015));
    }

    private static KeySequence deprecatedSequenceToKeySequence(int[] sequence) {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        int i = 0;
        while (i < sequence.length) {
            keyStrokes.add(Persistence.deprecatedStrokeToKeyStroke(sequence[i]));
            ++i;
        }
        return KeySequence.getInstance(keyStrokes);
    }

    private static KeyStroke deprecatedStrokeToKeyStroke(int stroke) {
        return SWTKeySupport.convertAcceleratorToKeyStroke(stroke);
    }

    private static int[] parseDeprecatedSequence(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int length = stringTokenizer.countTokens();
        int[] strokes = new int[length];
        int i = 0;
        while (i < length) {
            strokes[i] = Persistence.parseDeprecatedStroke(stringTokenizer.nextToken());
            ++i;
        }
        return strokes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseDeprecatedStroke(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, MODIFIER_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int size = list.size();
        int value = 0;
        if (size % 2 != 1) return value;
        String token = (String)list.get(size - 1);
        Integer integer = (Integer)stringToValueMap.get(token.toUpperCase());
        if (integer != null) {
            value = integer;
        } else if (token.length() == 1) {
            value = token.toUpperCase().charAt(0);
        }
        if (value == 0) return value;
        int i = 0;
        while (i < size - 1) {
            token = (String)list.get(i);
            if (i % 2 == 0) {
                if (token.equalsIgnoreCase(CTRL)) {
                    if ((value & 0x40000) != 0) {
                        return 0;
                    }
                    value |= 0x40000;
                } else if (token.equalsIgnoreCase(ALT)) {
                    if ((value & 0x10000) != 0) {
                        return 0;
                    }
                    value |= 0x10000;
                } else if (token.equalsIgnoreCase(SHIFT)) {
                    if ((value & 0x20000) != 0) {
                        return 0;
                    }
                    value |= 0x20000;
                } else {
                    if (!token.equalsIgnoreCase(COMMAND)) return 0;
                    if ((value & 0x400000) != 0) {
                        return 0;
                    }
                    value |= 0x400000;
                }
            } else if (!MODIFIER_SEPARATOR.equals(token)) {
                return 0;
            }
            ++i;
        }
        return value;
    }

    static ActiveKeyConfigurationDefinition readActiveKeyConfigurationDefinition(IMemento memento, String pluginIdOverride) {
        String pluginId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String keyConfigurationId = memento.getString(TAG_KEY_CONFIGURATION_ID);
        if (keyConfigurationId == null) {
            keyConfigurationId = memento.getString("value");
        }
        String string = pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        if (pluginIdOverride == null && pluginId == null) {
            pluginId = memento.getString("plugin");
        }
        return new ActiveKeyConfigurationDefinition(keyConfigurationId, pluginId);
    }

    static List readActiveKeyConfigurationDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActiveKeyConfigurationDefinition> list = new ArrayList<ActiveKeyConfigurationDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActiveKeyConfigurationDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static ContextBindingDefinition readActivityBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            activityId = memento.getString("contextId");
        }
        if ("org.eclipse.ui.globalScope".equals(activityId)) {
            activityId = null;
        }
        String commandId = memento.getString(TAG_COMMAND_ID);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ContextBindingDefinition(activityId, commandId, pluginId);
    }

    static List readActivityBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ContextBindingDefinition> list = new ArrayList<ContextBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActivityBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static CategoryDefinition readCategoryDefinition(IMemento memento, String pluginIdOverride) {
        String pluginId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String string = pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        if (pluginIdOverride == null && pluginId == null) {
            pluginId = memento.getString("plugin");
        }
        return new CategoryDefinition(description, id, name, pluginId);
    }

    static List readCategoryDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryDefinition> list = new ArrayList<CategoryDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCategoryDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static CommandDefinition readCommandDefinition(IMemento memento, String pluginIdOverride) {
        String pluginId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String categoryId = memento.getString(TAG_CATEGORY_ID);
        if (categoryId == null) {
            categoryId = memento.getString(TAG_CATEGORY);
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String string = pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        if (pluginIdOverride == null && pluginId == null) {
            pluginId = memento.getString("plugin");
        }
        return new CommandDefinition(categoryId, description, id, name, pluginId);
    }

    static List readCommandDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CommandDefinition> list = new ArrayList<CommandDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCommandDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    private static int[] readDeprecatedSequence(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren("stroke");
        if (mementos == null) {
            throw new NullPointerException();
        }
        int[] strokes = new int[mementos.length];
        int i = 0;
        while (i < mementos.length) {
            strokes[i] = Persistence.readDeprecatedStroke(mementos[i]);
            ++i;
        }
        return strokes;
    }

    private static int readDeprecatedStroke(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        Integer value = memento.getInteger("value");
        return value != null ? value : 0;
    }

    static ImageBindingDefinition readImageBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String commandId = memento.getString(TAG_COMMAND_ID);
        String imageStyle = memento.getString(TAG_IMAGE_STYLE);
        String imageUri = memento.getString(TAG_IMAGE_URI);
        String locale = memento.getString(TAG_LOCALE);
        String platform = memento.getString(TAG_PLATFORM);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ImageBindingDefinition(commandId, imageStyle, imageUri, locale, platform, pluginId);
    }

    static List readImageBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ImageBindingDefinition> list = new ArrayList<ImageBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readImageBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static KeyConfigurationDefinition readKeyConfigurationDefinition(IMemento memento, String pluginIdOverride) {
        String pluginId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String parentId = memento.getString(TAG_PARENT_ID);
        if (parentId == null) {
            parentId = memento.getString("parent");
        }
        String string = pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        if (pluginIdOverride == null && pluginId == null) {
            pluginId = memento.getString("plugin");
        }
        return new KeyConfigurationDefinition(description, id, name, parentId, pluginId);
    }

    static List readKeyConfigurationDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<KeyConfigurationDefinition> list = new ArrayList<KeyConfigurationDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readKeyConfigurationDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static KeySequenceBindingDefinition readKeySequenceBindingDefinition(IMemento memento, String pluginIdOverride) {
        String pluginId;
        String keyConfigurationId;
        String commandId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            activityId = memento.getString("contextId");
        }
        if (activityId == null) {
            activityId = memento.getString("scope");
        }
        if ("org.eclipse.ui.globalScope".equals(activityId)) {
            activityId = null;
        }
        if ((commandId = memento.getString(TAG_COMMAND_ID)) == null) {
            commandId = memento.getString(TAG_COMMAND);
        }
        if (commandId == null) {
            commandId = memento.getString(TAG_ID);
        }
        if ((keyConfigurationId = memento.getString(TAG_KEY_CONFIGURATION_ID)) == null) {
            keyConfigurationId = memento.getString("configuration");
        }
        KeySequence keySequence = null;
        String keySequenceAsString = memento.getString(TAG_KEY_SEQUENCE);
        if (keySequenceAsString != null) {
            try {
                keySequence = KeySequence.getInstance(keySequenceAsString);
            }
            catch (ParseException parseException) {}
        } else {
            IMemento mementoSequence = memento.getChild("sequence");
            if (mementoSequence != null) {
                keySequence = Persistence.deprecatedSequenceToKeySequence(Persistence.readDeprecatedSequence(mementoSequence));
            } else {
                String string = memento.getString("string");
                if (string != null) {
                    keySequence = Persistence.deprecatedSequenceToKeySequence(Persistence.parseDeprecatedSequence(string));
                }
            }
        }
        String locale = memento.getString(TAG_LOCALE);
        String platform = memento.getString(TAG_PLATFORM);
        String string = pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        if (pluginIdOverride == null && pluginId == null) {
            pluginId = memento.getString("plugin");
        }
        return new KeySequenceBindingDefinition(activityId, commandId, keyConfigurationId, keySequence, locale, platform, pluginId);
    }

    static List readKeySequenceBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<KeySequenceBindingDefinition> list = new ArrayList<KeySequenceBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readKeySequenceBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static void writeActiveKeyConfigurationDefinition(IMemento memento, ActiveKeyConfigurationDefinition activeKeyConfigurationDefinition) {
        if (memento == null || activeKeyConfigurationDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_KEY_CONFIGURATION_ID, activeKeyConfigurationDefinition.getKeyConfigurationId());
        memento.putString(TAG_PLUGIN_ID, activeKeyConfigurationDefinition.getPluginId());
    }

    static void writeActiveKeyConfigurationDefinitions(IMemento memento, String name, List activeKeyConfigurationDefinitions) {
        if (memento == null || name == null || activeKeyConfigurationDefinitions == null) {
            throw new NullPointerException();
        }
        activeKeyConfigurationDefinitions = new ArrayList(activeKeyConfigurationDefinitions);
        Iterator iterator = activeKeyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activeKeyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActiveKeyConfigurationDefinition(memento.createChild(name), (ActiveKeyConfigurationDefinition)iterator.next());
        }
    }

    static void writeActivityBindingDefinition(IMemento memento, ContextBindingDefinition activityBindingDefinition) {
        if (memento == null || activityBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, activityBindingDefinition.getActivityId());
        memento.putString(TAG_COMMAND_ID, activityBindingDefinition.getCommandId());
        memento.putString(TAG_PLUGIN_ID, activityBindingDefinition.getPluginId());
    }

    static void writeActivityBindingDefinitions(IMemento memento, String name, List activityBindingDefinitions) {
        if (memento == null || name == null || activityBindingDefinitions == null) {
            throw new NullPointerException();
        }
        activityBindingDefinitions = new ArrayList(activityBindingDefinitions);
        Iterator iterator = activityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.ContextBindingDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityBindingDefinition(memento.createChild(name), (ContextBindingDefinition)iterator.next());
        }
    }

    static void writeCategoryDefinition(IMemento memento, CategoryDefinition categoryDefinition) {
        if (memento == null || categoryDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_DESCRIPTION, categoryDefinition.getDescription());
        memento.putString(TAG_ID, categoryDefinition.getId());
        memento.putString(TAG_NAME, categoryDefinition.getName());
        memento.putString(TAG_PLUGIN_ID, categoryDefinition.getPluginId());
    }

    static void writeCategoryDefinitions(IMemento memento, String name, List categoryDefinitions) {
        if (memento == null || name == null || categoryDefinitions == null) {
            throw new NullPointerException();
        }
        categoryDefinitions = new ArrayList(categoryDefinitions);
        Iterator iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.CategoryDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryDefinition(memento.createChild(name), (CategoryDefinition)iterator.next());
        }
    }

    static void writeCommandDefinition(IMemento memento, CommandDefinition commandDefinition) {
        if (memento == null || commandDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_CATEGORY_ID, commandDefinition.getCategoryId());
        memento.putString(TAG_DESCRIPTION, commandDefinition.getDescription());
        memento.putString(TAG_ID, commandDefinition.getId());
        memento.putString(TAG_NAME, commandDefinition.getName());
        memento.putString(TAG_PLUGIN_ID, commandDefinition.getPluginId());
    }

    static void writeCommandDefinitions(IMemento memento, String name, List commandDefinitions) {
        if (memento == null || name == null || commandDefinitions == null) {
            throw new NullPointerException();
        }
        commandDefinitions = new ArrayList(commandDefinitions);
        Iterator iterator = commandDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.CommandDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = commandDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCommandDefinition(memento.createChild(name), (CommandDefinition)iterator.next());
        }
    }

    static void writeImageBindingDefinition(IMemento memento, ImageBindingDefinition imageBindingDefinition) {
        if (memento == null || imageBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_COMMAND_ID, imageBindingDefinition.getCommandId());
        memento.putString(TAG_IMAGE_STYLE, imageBindingDefinition.getImageStyle());
        memento.putString(TAG_IMAGE_URI, imageBindingDefinition.getImageUri());
        memento.putString(TAG_LOCALE, imageBindingDefinition.getLocale());
        memento.putString(TAG_PLATFORM, imageBindingDefinition.getPlatform());
        memento.putString(TAG_PLUGIN_ID, imageBindingDefinition.getPluginId());
    }

    static void writeImageBindingDefinitions(IMemento memento, String name, List imageBindingDefinitions) {
        if (memento == null || name == null || imageBindingDefinitions == null) {
            throw new NullPointerException();
        }
        imageBindingDefinitions = new ArrayList(imageBindingDefinitions);
        Iterator iterator = imageBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.ImageBindingDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = imageBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeImageBindingDefinition(memento.createChild(name), (ImageBindingDefinition)iterator.next());
        }
    }

    static void writeKeyConfigurationDefinition(IMemento memento, KeyConfigurationDefinition keyConfigurationDefinition) {
        if (memento == null || keyConfigurationDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_DESCRIPTION, keyConfigurationDefinition.getDescription());
        memento.putString(TAG_ID, keyConfigurationDefinition.getId());
        memento.putString(TAG_NAME, keyConfigurationDefinition.getName());
        memento.putString(TAG_PARENT_ID, keyConfigurationDefinition.getParentId());
        memento.putString(TAG_PLUGIN_ID, keyConfigurationDefinition.getPluginId());
    }

    static void writeKeyConfigurationDefinitions(IMemento memento, String name, List keyConfigurationDefinitions) {
        if (memento == null || name == null || keyConfigurationDefinitions == null) {
            throw new NullPointerException();
        }
        keyConfigurationDefinitions = new ArrayList(keyConfigurationDefinitions);
        Iterator iterator = keyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.KeyConfigurationDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = keyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeyConfigurationDefinition(memento.createChild(name), (KeyConfigurationDefinition)iterator.next());
        }
    }

    static void writeKeySequenceBindingDefinition(IMemento memento, KeySequenceBindingDefinition keySequenceBindingDefinition) {
        if (memento == null || keySequenceBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, keySequenceBindingDefinition.getContextId());
        memento.putString(TAG_COMMAND_ID, keySequenceBindingDefinition.getCommandId());
        memento.putString(TAG_KEY_CONFIGURATION_ID, keySequenceBindingDefinition.getKeyConfigurationId());
        memento.putString(TAG_KEY_SEQUENCE, keySequenceBindingDefinition.getKeySequence() != null ? keySequenceBindingDefinition.getKeySequence().toString() : null);
        memento.putString(TAG_LOCALE, keySequenceBindingDefinition.getLocale());
        memento.putString(TAG_PLATFORM, keySequenceBindingDefinition.getPlatform());
        memento.putString(TAG_PLUGIN_ID, keySequenceBindingDefinition.getPluginId());
    }

    static void writeKeySequenceBindingDefinitions(IMemento memento, String name, List keySequenceBindingDefinitions) {
        if (memento == null || name == null || keySequenceBindingDefinitions == null) {
            throw new NullPointerException();
        }
        keySequenceBindingDefinitions = new ArrayList(keySequenceBindingDefinitions);
        Iterator iterator = keySequenceBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.internal.commands.KeySequenceBindingDefinition;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = keySequenceBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeySequenceBindingDefinition(memento.createChild(name), (KeySequenceBindingDefinition)iterator.next());
        }
    }

    private Persistence() {
    }
}

