/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.commands.CommandHandlerServiceEvent;
import org.eclipse.ui.commands.ICommandHandlerService;
import org.eclipse.ui.commands.ICommandHandlerServiceListener;
import org.eclipse.ui.commands.ICompoundCommandHandlerService;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.commands.AbstractCommandHandlerService;
import org.eclipse.ui.internal.util.Util;

public final class CompoundCommandHandlerService
extends AbstractCommandHandlerService
implements ICompoundCommandHandlerService {
    private final ICommandHandlerServiceListener commandHandlerServiceListener = new ICommandHandlerServiceListener(){

        public void commandHandlerServiceChanged(CommandHandlerServiceEvent commandHandlerServiceEvent) {
            CompoundCommandHandlerService.this.update();
        }
    };
    private final HashSet commandHandlerServices = new HashSet();
    private Map handlersByCommandId = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addCommandHandlerService(ICommandHandlerService commandHandlerService) {
        if (commandHandlerService == null) {
            throw new NullPointerException();
        }
        commandHandlerService.addCommandHandlerServiceListener(this.commandHandlerServiceListener);
        this.commandHandlerServices.add(commandHandlerService);
        this.update();
    }

    public Map getHandlersByCommandId() {
        return Collections.unmodifiableMap(this.handlersByCommandId);
    }

    public void removeCommandHandlerService(ICommandHandlerService commandHandlerService) {
        if (commandHandlerService == null) {
            throw new NullPointerException();
        }
        this.commandHandlerServices.remove(commandHandlerService);
        commandHandlerService.removeCommandHandlerServiceListener(this.commandHandlerServiceListener);
        this.update();
    }

    private void setHandlersByCommandId(Map handlersByCommandId) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.commands.IHandler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        handlersByCommandId = Util.safeCopy(handlersByCommandId, clazz2, (Class)clazz, false, true);
        if (!this.handlersByCommandId.equals(handlersByCommandId)) {
            this.handlersByCommandId = handlersByCommandId;
            this.fireCommandHandlerServiceChanged(new CommandHandlerServiceEvent(this, true));
        }
    }

    private void update() {
        HashMap<String, IHandler> handlersByCommandId = new HashMap<String, IHandler>();
        Iterator iterator = this.commandHandlerServices.iterator();
        while (iterator.hasNext()) {
            ICommandHandlerService commandHandlerService = (ICommandHandlerService)iterator.next();
            Iterator iterator2 = commandHandlerService.getHandlersByCommandId().entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String commandId = (String)entry.getKey();
                IHandler handler = (IHandler)entry.getValue();
                if (!handlersByCommandId.containsKey(commandId)) {
                    handlersByCommandId.put(commandId, handler);
                    continue;
                }
                if (handler != null && handler.equals(handlersByCommandId.get(commandId))) continue;
                handlersByCommandId.put(commandId, null);
            }
        }
        this.setHandlersByCommandId(handlersByCommandId);
    }
}

