/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.colors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.colors.ColorDefinition;

public class ColorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final ResourceBundle RESOURCE_BUNDLE;
    private ListViewer colorList;
    private ColorSelector colorSelector;
    private Text commentText;
    private Text descriptionText;
    private Map preferencesToSet = new HashMap(7);
    private Button resetButton;
    private Map valuesToSet = new HashMap(7);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.internal.colors.ColorsPreferencePage;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    private void createColorControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.value"));
        Dialog.applyDialogFont((Control)label);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.colorSelector = new ColorSelector(composite);
        this.colorSelector.getButton().setLayoutData((Object)new GridData());
        this.colorSelector.setEnabled(false);
        this.resetButton = new Button(composite, 8);
        this.resetButton.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.reset"));
        this.resetButton.setEnabled(false);
    }

    private void createColorList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.colors"));
        Dialog.applyDialogFont((Control)label);
        this.colorList = new ListViewer(composite, 2820);
        this.colorList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.colorList.setInput((Object)ColorDefinition.getDefinitions());
        this.colorList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ColorDefinition)element).getLabel();
            }
        });
        this.colorList.getControl().setFont(JFaceResources.getViewerFont());
        data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        this.colorList.getControl().setLayoutData((Object)data);
    }

    private void createCommentControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.comment"));
        Dialog.applyDialogFont((Control)label);
        this.commentText = new Text(composite, 2120);
        this.commentText.setLayoutData((Object)new GridData(1808));
    }

    protected Control createContents(Composite parent) {
        Composite mainColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainColumn.setFont(parent.getFont());
        mainColumn.setLayout((Layout)layout);
        this.createColorList(mainColumn);
        Composite controlColumn = new Composite(mainColumn, 0);
        controlColumn.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlColumn.setLayout((Layout)layout);
        this.createColorControl(controlColumn);
        this.createCommentControl(controlColumn);
        this.createDescriptionControl(mainColumn);
        this.hookListeners();
        return mainColumn;
    }

    private void createDescriptionControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.description"));
        Dialog.applyDialogFont((Control)label);
        this.descriptionText = new Text(composite, 2120);
        data = new GridData(1808);
        this.descriptionText.setLayoutData((Object)data);
    }

    private ColorDefinition getAncestor(ColorDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return null;
        }
        int idx = Arrays.binarySearch(ColorDefinition.getDefinitions(), defaultsTo, ColorDefinition.ID_COMPARATOR);
        if (idx < 0) {
            return null;
        }
        return ColorDefinition.getDefinitions()[idx];
    }

    private RGB getAncestorValue(ColorDefinition definition) {
        ColorDefinition ancestor = this.getAncestor(definition);
        if (ancestor == null) {
            return null;
        }
        return this.getValue(ancestor);
    }

    private ColorDefinition[] getDescendantColors(ColorDefinition definition) {
        ArrayList<ColorDefinition> list = new ArrayList<ColorDefinition>(5);
        String id = definition.getId();
        ColorDefinition[] sorted = new ColorDefinition[ColorDefinition.getDefinitions().length];
        System.arraycopy(ColorDefinition.getDefinitions(), 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, ColorDefinition.HIERARCHY_COMPARATOR);
        int i = 0;
        while (i < sorted.length) {
            if (id.equals(sorted[i].getDefaultsTo())) {
                list.add(sorted[i]);
            }
            ++i;
        }
        return list.toArray(new ColorDefinition[list.size()]);
    }

    private RGB getValue(ColorDefinition definition) {
        String id = definition.getId();
        RGB updatedRGB = (RGB)this.preferencesToSet.get(id);
        if (updatedRGB == null && (updatedRGB = (RGB)this.valuesToSet.get(id)) == null) {
            updatedRGB = JFaceResources.getColorRegistry().getRGB(id);
        }
        return updatedRGB;
    }

    private void hookListeners() {
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ColorDefinition definition = (ColorDefinition)((IStructuredSelection)ColorsPreferencePage.this.colorList.getSelection()).getFirstElement();
                RGB newRGB = (RGB)event.getNewValue();
                if (definition != null && newRGB != null && !newRGB.equals(event.getOldValue())) {
                    ColorsPreferencePage.this.setPreferenceValue(definition, newRGB);
                }
                ColorsPreferencePage.this.updateControls(definition);
            }
        });
        this.colorList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    ColorsPreferencePage.this.updateControls(null);
                } else {
                    ColorsPreferencePage.this.updateControls((ColorDefinition)((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDefinition definition = (ColorDefinition)((IStructuredSelection)ColorsPreferencePage.this.colorList.getSelection()).getFirstElement();
                if (ColorsPreferencePage.this.resetColor(definition)) {
                    ColorsPreferencePage.this.updateControls(definition);
                }
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(workbench.getPreferenceStore());
    }

    private boolean isDefault(ColorDefinition definition) {
        String id = definition.getId();
        return this.preferencesToSet.containsKey(id) ? (definition.getValue() != null ? this.preferencesToSet.get(id).equals(StringConverter.asRGB((String)this.getPreferenceStore().getDefaultString(id), null)) : this.preferencesToSet.get(id).equals(this.getAncestorValue(definition))) : (definition.getValue() != null ? this.getPreferenceStore().isDefault(id) : this.getValue(definition).equals((Object)this.getAncestorValue(definition)));
    }

    protected void performDefaults() {
        ColorDefinition[] definitions = ColorDefinition.getDefinitions();
        ColorDefinition[] definitionsCopy = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, definitionsCopy, 0, definitions.length);
        Arrays.sort(definitionsCopy, ColorDefinition.HIERARCHY_COMPARATOR);
        int i = 0;
        while (i < definitionsCopy.length) {
            this.resetColor(definitionsCopy[i]);
            ++i;
        }
        this.updateControls((ColorDefinition)((IStructuredSelection)this.colorList.getSelection()).getFirstElement());
    }

    public boolean performOk() {
        RGB rgb;
        String id;
        Iterator i = this.preferencesToSet.keySet().iterator();
        while (i.hasNext()) {
            String storeString;
            id = (String)i.next();
            rgb = (RGB)this.preferencesToSet.get(id);
            String rgbString = StringConverter.asString((RGB)rgb);
            if (rgbString.equals(storeString = this.getPreferenceStore().getString(id))) continue;
            JFaceResources.getColorRegistry().put(id, rgb);
            this.getPreferenceStore().setValue(id, rgbString);
        }
        this.preferencesToSet.clear();
        i = this.valuesToSet.keySet().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            rgb = (RGB)this.valuesToSet.get(id);
            JFaceResources.getColorRegistry().put(id, rgb);
        }
        this.valuesToSet.clear();
        return true;
    }

    private boolean resetColor(ColorDefinition definition) {
        RGB newRGB;
        if (!this.isDefault(definition) && (newRGB = definition.getValue() != null ? StringConverter.asRGB((String)this.getPreferenceStore().getDefaultString(definition.getId()), null) : this.getAncestorValue(definition)) != null) {
            this.setPreferenceValue(definition, newRGB);
            return true;
        }
        return false;
    }

    private void setDescendantRegistryValues(ColorDefinition definition, RGB newRGB) {
        ColorDefinition[] children = this.getDescendantColors(definition);
        int i = 0;
        while (i < children.length) {
            if (this.isDefault(children[i])) {
                this.valuesToSet.put(children[i].getId(), newRGB);
                this.setDescendantRegistryValues(children[i], newRGB);
            }
            ++i;
        }
    }

    protected void setPreferenceValue(ColorDefinition definition, RGB newRGB) {
        this.setDescendantRegistryValues(definition, newRGB);
        this.preferencesToSet.put(definition.getId(), newRGB);
    }

    private void updateControls(ColorDefinition definition) {
        if (definition != null) {
            this.colorSelector.setColorValue(this.getValue(definition));
        }
        if (definition != null) {
            this.resetButton.setEnabled(true);
            this.colorSelector.setEnabled(true);
            if (this.isDefault(definition)) {
                if (definition.getDefaultsTo() != null) {
                    int idx = Arrays.binarySearch(ColorDefinition.getDefinitions(), definition.getDefaultsTo(), ColorDefinition.ID_COMPARATOR);
                    if (idx >= 0) {
                        this.commentText.setText(MessageFormat.format(RESOURCE_BUNDLE.getString("ColorsPreferencePage.currentlyMappedTo"), ColorDefinition.getDefinitions()[idx].getLabel()));
                    } else {
                        this.commentText.setText("");
                    }
                } else {
                    this.commentText.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.currentlyDefault"));
                }
            } else {
                this.commentText.setText(RESOURCE_BUNDLE.getString("ColorsPreferencePage.customValue"));
            }
            String description = definition.getDescription();
            this.descriptionText.setText(description == null ? "" : description);
        } else {
            this.resetButton.setEnabled(false);
            this.colorSelector.setEnabled(false);
            this.commentText.setText("");
            this.descriptionText.setText("");
        }
    }
}

