/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.colors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.ui.internal.colors.ColorDefinition;
import org.eclipse.ui.internal.registry.RegistryReader;

class ColorDefinitionReader
extends RegistryReader {
    private static String ATT_DEFAULTS_TO = "defaultsTo";
    private static String ATT_ID = "id";
    private static String ATT_LABEL = "label";
    private static String ATT_VALUE = "value";
    private static String CHILD_DESCRIPTION = "description";
    private static String EXTENSION_ID = "colorDefinitions";
    private static final ResourceBundle RESOURCE_BUNDLE;
    private Collection values;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.internal.colors.ColorDefinitionReader;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    ColorDefinitionReader() {
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        String defaultMapping = element.getAttribute(ATT_DEFAULTS_TO);
        String value = element.getAttribute(ATT_VALUE);
        if (value == null && defaultMapping == null || value != null && defaultMapping != null) {
            this.logError(element, RESOURCE_BUNDLE.getString("ColorDefinitionReader.badDefault"));
            return true;
        }
        String description = null;
        IConfigurationElement[] descriptions = element.getChildren(CHILD_DESCRIPTION);
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        this.values.add(new ColorDefinition(name, id, defaultMapping, value, description, element.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier()));
        return true;
    }

    Collection readRegistry(IPluginRegistry in) {
        if (this.values == null) {
            this.values = new ArrayList();
        } else {
            this.values.clear();
        }
        this.readRegistry(in, "org.eclipse.ui", EXTENSION_ID);
        return this.values;
    }
}

