/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.activities.ws.ActivityContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;

public class SwapActivityHelper {
    private ListViewer activeViewer;
    private ListViewer potentialViewer;
    private Composite mainComposite;
    static /* synthetic */ Class class$0;

    private boolean belongsToACategory(String activityId) {
        IWorkbenchActivitySupport support;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return false;
        }
        IActivityManager activityManager = support.getActivityManager();
        Iterator categoryItr = activityManager.getDefinedCategoryIds().iterator();
        while (categoryItr.hasNext()) {
            ICategory category = activityManager.getCategory((String)categoryItr.next());
            Iterator bindingItr = category.getCategoryActivityBindings().iterator();
            while (bindingItr.hasNext()) {
                ICategoryActivityBinding binding = (ICategoryActivityBinding)bindingItr.next();
                if (!binding.getActivityId().equals(activityId)) continue;
                return true;
            }
        }
        return false;
    }

    private void createButton(Composite parent, ListViewer source, ListViewer destination, boolean leftToRight) {
        Button button = new Button(parent, 4 | (leftToRight ? 131072 : 16384));
        button.setLayoutData((Object)new GridData());
        button.addSelectionListener((SelectionListener)new SwapSelectionListener(source, destination));
    }

    public void createControl(Composite parent) {
        IWorkbenchActivitySupport support;
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.mainComposite.setLayout((Layout)layout);
        this.potentialViewer = this.createViewer(ActivityMessages.getString("SwapActivityHelper.disabled_activities"));
        Composite swapComposite = new Composite(this.mainComposite, 0);
        this.activeViewer = this.createViewer(ActivityMessages.getString("SwapActivityHelper.enabled_activities"));
        this.createSwapButtons(swapComposite);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return;
        }
        IActivityManager activityManager = support.getActivityManager();
        Set activityIds = activityManager.getDefinedActivityIds();
        ArrayList<IActivity> active = new ArrayList<IActivity>();
        ArrayList<IActivity> potential = new ArrayList<IActivity>();
        Iterator i = activityIds.iterator();
        while (i.hasNext()) {
            IActivity activity = activityManager.getActivity((String)i.next());
            if (!this.belongsToACategory(activity.getId())) continue;
            if (activity.isEnabled()) {
                active.add(activity);
                continue;
            }
            potential.add(activity);
        }
        this.potentialViewer.setInput(potential);
        this.activeViewer.setInput(active);
    }

    private void createSwapButtons(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        this.createButton(parent, this.potentialViewer, this.activeViewer, true);
        this.createButton(parent, this.activeViewer, this.potentialViewer, false);
        parent.setLayoutData((Object)new GridData(4));
    }

    private ListViewer createViewer(String label) {
        IWorkbenchActivitySupport support;
        Group group = new Group(this.mainComposite, 0);
        group.setText(label);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new FillLayout());
        ListViewer viewer = new ListViewer((Composite)group);
        IActivityManager manager = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) != null) {
            manager = support.getActivityManager();
        }
        viewer.setLabelProvider((IBaseLabelProvider)new ActivityLabelProvider(manager));
        viewer.setContentProvider((IContentProvider)new ActivityContentProvider());
        viewer.setSorter(new ViewerSorter());
        return viewer;
    }

    public Composite getControl() {
        return this.mainComposite;
    }

    public void updateActivityStates() {
        IWorkbenchActivitySupport support;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return;
        }
        IActivityManager activityManager = support.getActivityManager();
        HashSet<String> finalState = new HashSet<String>(activityManager.getEnabledActivityIds());
        Collection disabledActivities = (Collection)this.potentialViewer.getInput();
        Iterator i = disabledActivities.iterator();
        while (i.hasNext()) {
            finalState.remove(((IActivity)i.next()).getId());
        }
        Collection enabledActivities = (Collection)this.activeViewer.getInput();
        Iterator i2 = enabledActivities.iterator();
        while (i2.hasNext()) {
            finalState.add(((IActivity)i2.next()).getId());
        }
        support.setEnabledActivityIds(finalState);
    }

    private class SwapSelectionListener
    implements SelectionListener {
        private ListViewer sourceViewer;
        private ListViewer destinationViewer;

        public SwapSelectionListener(ListViewer sourceViewer, ListViewer destinationViewer) {
            this.sourceViewer = sourceViewer;
            this.destinationViewer = destinationViewer;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            List selection = ((IStructuredSelection)this.sourceViewer.getSelection()).toList();
            if (selection.size() > 0) {
                Collection sourceInput = (Collection)this.sourceViewer.getInput();
                Collection destInput = (Collection)this.destinationViewer.getInput();
                sourceInput.removeAll(selection);
                destInput.addAll(selection);
                this.sourceViewer.refresh();
                this.destinationViewer.refresh();
            }
        }
    }
}

