/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.commands.CommandHandlerServiceFactory;
import org.eclipse.ui.commands.IMutableCommandHandlerService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.IWorkbenchWindowCommandSupport;
import org.eclipse.ui.contexts.IWorkbenchWindowContextSupport;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.IPerspectiveService;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PartDropEvent;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveContributionItem;
import org.eclipse.ui.internal.PerspectiveListenerListOld;
import org.eclipse.ui.internal.PerspectivePresentation;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.SetPagePerspectiveAction;
import org.eclipse.ui.internal.ShortcutBarPart;
import org.eclipse.ui.internal.ShortcutBarPartDragDrop;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WWinPartService;
import org.eclipse.ui.internal.WWinPerspectiveService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.commands.ActionHandler;
import org.eclipse.ui.internal.commands.ws.WorkbenchWindowCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchWindowContextSupport;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class WorkbenchWindow
extends ApplicationWindow
implements IWorkbenchWindow {
    private int number;
    private PageList pageList = new PageList();
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerListOld perspectiveListeners = new PerspectiveListenerListOld();
    private IPartDropListener partDropListener;
    private WWinPerspectiveService perspectiveService = new WWinPerspectiveService(this);
    private WWinPartService partService = new WWinPartService(this);
    private ActionPresentation actionPresentation;
    private WWinActionBars actionBars;
    private Label separator2;
    private Label separator3;
    private ToolBarManager shortcutBar;
    private ShortcutBarPart shortcutBarPart;
    private ShortcutBarPartDragDrop shortcutDND;
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    private Menu perspectiveBarMenu;
    private Menu fastViewBarMenu;
    private MenuItem restoreItem;
    private AnimationItem animationItem;
    private Label noOpenPerspective;
    private Rectangle normalBounds;
    private boolean asMaximizedState = false;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private static final int FILL_ALL_ACTION_BARS = 14;
    private Map actionSetHandlersByCommandId = new HashMap();
    private Map globalActionHandlersByCommandId = new HashMap();
    public IMutableCommandHandlerService actionSetAndGlobalActionCommandHandlerService = CommandHandlerServiceFactory.getMutableCommandHandlerService();
    private IWorkbenchWindowCommandSupport workbenchWindowCommandSupport;
    private IWorkbenchWindowContextSupport workbenchWindowContextSupport;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void addSubmenu(int type) {
        this.submenus |= type;
    }

    public boolean containsSubmenu(int type) {
        return (this.submenus & type) != 0;
    }

    public WorkbenchWindow(int number) {
        super(null);
        this.number = number;
        PlatformUI.getWorkbench();
        this.addMenuBar();
        this.addCoolBar(0x800000);
        this.addStatusLine();
        this.addShortcutBar(8389184);
        this.actionPresentation = new ActionPresentation(this);
        this.partDropListener = new IPartDropListener(){

            public void dragOver(PartDropEvent e) {
                WorkbenchPage page = WorkbenchWindow.this.getActiveWorkbenchPage();
                Perspective persp = page.getActivePerspective();
                PerspectivePresentation presentation = persp.getPresentation();
                presentation.onPartDragOver(e);
            }

            public void drop(PartDropEvent e) {
                WorkbenchPage page = WorkbenchWindow.this.getActiveWorkbenchPage();
                Perspective persp = page.getActivePerspective();
                PerspectivePresentation presentation = persp.getPresentation();
                presentation.onPartDrop(e);
            }
        };
        this.getAdvisor().preWindowOpen(this.getWindowConfigurer());
        this.getAdvisor().fillActionBars(this, this.getWindowConfigurer().getActionBarConfigurer(), 14);
        this.workbenchWindowCommandSupport = new WorkbenchWindowCommandSupport(this);
        this.workbenchWindowContextSupport = new WorkbenchWindowContextSupport(this);
        ((WorkbenchWindowCommandSupport)this.workbenchWindowCommandSupport).addCommandHandlerService(this.actionSetAndGlobalActionCommandHandlerService);
    }

    void registerActionSets(IActionSet[] actionSets) {
        this.actionSetHandlersByCommandId.clear();
        int i = 0;
        while (i < actionSets.length) {
            if (actionSets[i] instanceof PluginActionSet) {
                PluginActionSet pluginActionSet = (PluginActionSet)actionSets[i];
                IAction[] pluginActions = pluginActionSet.getPluginActions();
                int j = 0;
                while (j < pluginActions.length) {
                    IAction pluginAction = pluginActions[j];
                    String commandId = pluginAction.getActionDefinitionId();
                    if (commandId != null) {
                        this.actionSetHandlersByCommandId.put(commandId, new ActionHandler(pluginAction));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setHandlersByCommandId();
    }

    void registerGlobalAction(IAction globalAction) {
        String commandId = globalAction.getActionDefinitionId();
        if (commandId != null) {
            this.globalActionHandlersByCommandId.put(commandId, new ActionHandler(globalAction));
        }
        this.setHandlersByCommandId();
    }

    void setHandlersByCommandId() {
        HashMap handlersByCommandId = new HashMap();
        handlersByCommandId.putAll(this.actionSetHandlersByCommandId);
        handlersByCommandId.putAll(this.globalActionHandlersByCommandId);
        this.actionSetAndGlobalActionCommandHandlerService.setHandlersByCommandId(handlersByCommandId);
    }

    public void addPageListener(IPageListener l) {
        this.pageListeners.addPageListener(l);
    }

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    void addPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        SetPagePerspectiveAction action = new SetPagePerspectiveAction(perspective, page);
        this.shortcutBar.appendToGroup(GRP_PERSPECTIVES, (IAction)action);
        this.shortcutBar.update(false);
    }

    protected void addShortcutBar(int style) {
        if (this.getShell() == null && this.shortcutBar == null) {
            this.shortcutBar = new ToolBarManager(style);
            this.shortcutBar.add((IContributionItem)new PerspectiveContributionItem(this));
            this.shortcutBar.add((IContributionItem)new Separator(GRP_PAGES));
            this.shortcutBar.add((IContributionItem)new Separator(GRP_PERSPECTIVES));
            this.shortcutBar.add((IContributionItem)new Separator(GRP_FAST_VIEWS));
            this.shortcutBar.add((IContributionItem)new ShowFastViewContribution(this));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean busyClose() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 83->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IWorkbenchPage busyOpenPage(String perspID, IAdaptable input) throws WorkbenchException {
        IWorkbenchPage newPage = null;
        if (this.pageList.isEmpty()) {
            newPage = new WorkbenchPage(this, perspID, input);
            this.pageList.add(newPage);
            this.firePageOpened(newPage);
            this.setActivePage(newPage);
        } else {
            IWorkbenchWindow window = this.getWorkbench().openWorkbenchWindow(perspID, input);
            newPage = window.getActivePage();
        }
        return newPage;
    }

    public int open() {
        int result = super.open();
        this.getWorkbenchImpl().fireWindowOpened(this);
        this.getAdvisor().postWindowOpen(this.getWindowConfigurer());
        return result;
    }

    protected boolean canHandleShellCloseEvent() {
        if (!super.canHandleShellCloseEvent()) {
            return false;
        }
        return this.getAdvisor().preWindowShellClose(this.getWindowConfigurer());
    }

    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = WorkbenchWindow.this.busyClose();
            }
        });
        return ret[0];
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    protected boolean isCoolBarLocked() {
        return this.getCoolBarManager().getLockLayout();
    }

    private void closeAllPages() {
        this.setActivePage(null);
        PageList oldList = this.pageList;
        this.pageList = new PageList();
        Iterator iterator = oldList.iterator();
        while (iterator.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            this.firePageClosed(page);
            page.dispose();
        }
        if (!this.closing) {
            this.showEmptyWindowMessage();
        }
    }

    public void closeAllPages(boolean save) {
        boolean ret;
        if (save && !(ret = this.saveAllPages(true))) {
            return;
        }
        this.closeAllPages();
    }

    protected boolean closePage(IWorkbenchPage in, boolean save) {
        WorkbenchPage newPage;
        boolean oldIsActive;
        if (!this.pageList.contains(in)) {
            return false;
        }
        WorkbenchPage oldPage = (WorkbenchPage)in;
        if (save && oldPage.isSaveNeeded() && !oldPage.saveAllEditors(true)) {
            return false;
        }
        boolean bl = oldIsActive = oldPage == this.getActiveWorkbenchPage();
        if (oldIsActive) {
            this.setActivePage(null);
        }
        this.pageList.remove(oldPage);
        this.firePageClosed(oldPage);
        oldPage.dispose();
        if (oldIsActive && (newPage = this.pageList.getNextActive()) != null) {
            this.setActivePage(newPage);
        }
        if (!this.closing && this.pageList.isEmpty()) {
            this.showEmptyWindowMessage();
        }
        return true;
    }

    private void showEmptyWindowMessage() {
        Composite parent = this.getClientComposite();
        if (this.noOpenPerspective == null) {
            this.noOpenPerspective = new Label(parent, 0);
            this.noOpenPerspective.setText(WorkbenchMessages.getString("WorkbenchWindow.noPerspective"));
            this.noOpenPerspective.setBounds(parent.getClientArea());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setLayout(this.getLayout());
        this.separator2 = new Label((Composite)shell, 258);
        this.createShortcutBar(shell);
        this.createProgressIndicator(shell);
        this.separator3 = new Label((Composite)shell, 514);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.workbench_window_context");
        this.trackShellActivation(shell);
        this.trackShellResize(shell);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null && event.type == 3) {
                    Point pt;
                    ToolBar toolBar;
                    if (event.widget instanceof ToolBar && (toolBar = (ToolBar)event.widget).getItem(pt = new Point(event.x, event.y)) != null) {
                        return;
                    }
                    currentPage.toggleFastView(null);
                }
            }
        };
        this.getCoolBarControl().addListener(3, listener);
        Control[] children = ((Composite)this.getStatusLineManager().getControl()).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                children[i].addListener(3, listener);
            }
            ++i;
        }
        this.getShortcutBar().getControl().addListener(3, listener);
    }

    private void createShortcutBar(Shell shell) {
        if (this.shortcutBar == null) {
            return;
        }
        this.shortcutBar.createControl((Composite)shell);
        this.shortcutBarPart = new ShortcutBarPart(this.shortcutBar);
        this.enableDragShortcutBarPart();
        ToolBar tb = this.shortcutBar.getControl();
        tb.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 35) {
                    WorkbenchWindow.this.showShortcutBarPopup(new Point(event.x, event.y));
                }
            }
        });
    }

    protected MenuManager createMenuManager() {
        MenuManager result = super.createMenuManager();
        return result;
    }

    void enableDragShortcutBarPart() {
        Control control = this.shortcutBarPart.getControl();
        if (control != null && this.shortcutDND == null) {
            this.shortcutDND = new ShortcutBarPartDragDrop(this.shortcutBarPart, control);
            this.shortcutDND.addDropListener(this.partDropListener);
        }
    }

    IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        IContributionItem[] array = this.shortcutBar.getItems();
        int length = array.length;
        int i = 0;
        while (i < length) {
            SetPagePerspectiveAction sp;
            IAction action;
            IContributionItem item = array[i];
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof SetPagePerspectiveAction && (sp = (SetPagePerspectiveAction)action).handles(perspective, page)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void firePageActivated(IWorkbenchPage page) {
        this.pageListeners.firePageActivated(page);
        this.partService.pageActivated(page);
    }

    private void firePageClosed(IWorkbenchPage page) {
        this.pageListeners.firePageClosed(page);
        this.partService.pageClosed(page);
    }

    private void firePageOpened(IWorkbenchPage page) {
        this.pageListeners.firePageOpened(page);
        this.partService.pageOpened(page);
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
        this.perspectiveService.firePerspectiveActivated(page, perspective);
    }

    void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        this.perspectiveService.firePerspectiveChanged(page, perspective, changeId);
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveService.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveService.firePerspectiveOpened(page, perspective);
    }

    public WWinActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    public IWorkbenchPage getActivePage() {
        return this.pageList.getActive();
    }

    WorkbenchPage getActiveWorkbenchPage() {
        return this.pageList.getActive();
    }

    protected Composite getClientComposite() {
        return (Composite)this.getContents();
    }

    public MenuManager getMenuManager() {
        return this.getMenuBarManager();
    }

    public int getNumber() {
        return this.number;
    }

    public IWorkbenchPage[] getPages() {
        return this.pageList.getPages();
    }

    public IPartService getPartService() {
        return this.partService;
    }

    protected Layout getLayout() {
        return new WorkbenchWindowLayout();
    }

    public IPerspectiveService getPerspectiveService() {
        return this.perspectiveService;
    }

    protected Label getSeparator2() {
        return this.separator2;
    }

    protected Label getSeparator3() {
        return this.separator3;
    }

    public ISelectionService getSelectionService() {
        return this.partService.getSelectionService();
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public ToolBarManager getShortcutBar() {
        return this.shortcutBar;
    }

    ShortcutBarPartDragDrop getShortcutDND() {
        return this.shortcutDND;
    }

    public StatusLineManager getStatusLineManager() {
        return super.getStatusLineManager();
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public String getToolbarLabel(String actionSetId) {
        ActionSetRegistry registry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor actionSet = registry.findActionSet(actionSetId);
        if (actionSet != null) {
            return actionSet.getLabel();
        }
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(actionSetId)) {
            return WorkbenchMessages.getString("WorkbenchWindow.FileToolbar");
        }
        if ("org.eclipse.ui.workbench.navigate".equalsIgnoreCase(actionSetId)) {
            return WorkbenchMessages.getString("WorkbenchWindow.NavigateToolbar");
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hardClose() {
        try {
            this.actionPresentation.clearActionSets();
            this.closeAllPages();
            this.getAdvisor().postWindowClose(this.getWindowConfigurer());
            this.getWorkbenchImpl().fireWindowClosed(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            boolean result = super.close();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        return super.close();
    }

    protected void initializeBounds() {
        this.getShell().setSize(800, 600);
    }

    public boolean isApplicationMenu(String menuID) {
        return this.getAdvisor().isApplicationMenu(this.getWindowConfigurer(), menuID);
    }

    boolean isWorkbenchCoolItemId(String id) {
        return this.windowConfigurer.containsCoolItem(id);
    }

    void lockCoolBar(boolean lock) {
        this.getCoolBarManager().setLockLayout(lock);
    }

    public boolean okToClose() {
        return this.getWorkbenchImpl().isClosing() || this.saveAllPages(true);
    }

    public IWorkbenchPage openPage(final String perspId, final IAdaptable input) throws WorkbenchException {
        Assert.isNotNull(perspId);
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchWindow.this.busyOpenPage(perspId, input);
                }
                catch (WorkbenchException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchWindow.exceptionMessage"));
    }

    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        String perspId = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
        return this.openPage(perspId, input);
    }

    public void removePageListener(IPageListener l) {
        this.pageListeners.removePageListener(l);
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    void removePerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            this.shortcutBar.remove(item);
            this.shortcutBar.update(false);
        }
    }

    private IStatus unableToRestorePage(IMemento pageMem) {
        String pageName = pageMem.getString("label");
        if (pageName == null) {
            pageName = "";
        }
        return new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("WorkbenchWindow.unableToRestorePerspective", new String[]{pageName}), null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus restoreState(IMemento memento, IPerspectiveDescriptor activeDescriptor) {
        block40: {
            block39: {
                Assert.isNotNull(this.getShell());
                result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("WorkbenchWindow.problemsRestoringWindow"), null);
                displayBounds = this.getShell().getDisplay().getBounds();
                shellBounds = new Rectangle(0, 0, 0, 0);
                bigInt = memento.getInteger("x");
                shellBounds.x = bigInt == null ? 0 : bigInt;
                bigInt = memento.getInteger("y");
                shellBounds.y = bigInt == null ? 0 : bigInt;
                bigInt = memento.getInteger("width");
                shellBounds.width = bigInt == null ? 0 : bigInt;
                bigInt = memento.getInteger("height");
                v0 = shellBounds.height = bigInt == null ? 0 : bigInt;
                if (!shellBounds.isEmpty()) {
                    if (!shellBounds.intersects(displayBounds)) {
                        clientArea = this.getShell().getDisplay().getClientArea();
                        shellBounds.x = clientArea.x;
                        shellBounds.y = clientArea.y;
                    }
                    this.getShell().setBounds(shellBounds);
                }
                if ("true".equals(memento.getString("maximized"))) {
                    this.getShell().setMaximized(true);
                }
                "true".equals(memento.getString("minimized"));
                if (this.getCoolBarManager() != null) {
                    coolBarMgr = this.getCoolBarManager();
                    coolBarMem = memento.getChild("coolbarLayout");
                    if (coolBarMem != null) {
                        lockedInt = coolBarMem.getInteger("locked");
                        if (lockedInt != null && lockedInt == 1) {
                            coolBarMgr.setLockLayout(true);
                        } else {
                            coolBarMgr.setLockLayout(false);
                        }
                        layout = new ArrayList<Separator>();
                        contributionMems = coolBarMem.getChildren("coolItem");
                        i = 0;
                        while (true) {
                            if (i >= contributionMems.length) {
                                coolBarMgr.setLayout(layout);
                                break block39;
                            }
                            contributionMem = contributionMems[i];
                            type = contributionMem.getString("itemType");
                            if (type != null) {
                                id = contributionMem.getString("id");
                                newItem = null;
                                if (type.equals("typeSeparator")) {
                                    newItem = id != null ? new Separator(id) : new Separator();
                                } else if (id != null && type.equals("typeGroupMarker")) {
                                    newItem = new GroupMarker(id);
                                } else if (id != null && type.equals("typeToolBarContribution")) {
                                    width = contributionMem.getInteger("x");
                                    height = contributionMem.getInteger("y");
                                    oldItem = coolBarMgr.find(id);
                                    if (oldItem instanceof ToolBarContributionItem) {
                                        newItem = (ToolBarContributionItem)oldItem;
                                    } else {
                                        newItem = new ToolBarContributionItem((IToolBarManager)new ToolBarManager(coolBarMgr.getStyle()), id);
                                        newItem.setVisible(false);
                                        refItem = this.findAlphabeticalOrder("additions", id, (IContributionManager)coolBarMgr);
                                        if (refItem != null) {
                                            coolBarMgr.insertAfter(refItem.getId(), (IContributionItem)newItem);
                                        } else {
                                            coolBarMgr.add((IContributionItem)newItem);
                                        }
                                    }
                                    if (width != null) {
                                        ((ToolBarContributionItem)newItem).setCurrentWidth(width.intValue());
                                    }
                                    if (height != null) {
                                        ((ToolBarContributionItem)newItem).setCurrentHeight(height.intValue());
                                    }
                                }
                                if (newItem != null) {
                                    layout.add(newItem);
                                    newItem.setParent((IContributionManager)coolBarMgr);
                                    coolBarMgr.markDirty();
                                }
                            }
                            ++i;
                        }
                    }
                    coolBarMem = memento.getChild("toolbarLayout");
                    if (coolBarMem != null) {
                        this.restoreOldCoolBar(coolBarMem);
                    }
                }
            }
            newActivePage = null;
            pageArray = memento.getChildren("page");
            i = 0;
            while (true) {
                block44: {
                    block45: {
                        block42: {
                            block43: {
                                if (i >= pageArray.length) {
                                    if (this.pageList.isEmpty()) {
                                        ** try [egrp 3[TRYBLOCK] [5 : 1088->1140)] { 
lbl87:
                                        // 1 sources

                                        break;
                                    }
                                    break block40;
                                }
                                pageMem = pageArray[i];
                                strFocus = pageMem.getString("focus");
                                if (strFocus == null || strFocus.length() == 0) break block44;
                                input = null;
                                inputMem = pageMem.getChild("input");
                                if (inputMem == null) break block45;
                                factoryID = inputMem.getString("factoryID");
                                if (factoryID == null) {
                                    WorkbenchPlugin.log("Unable to restore page - no input factory ID.");
                                    result.add(this.unableToRestorePage(pageMem));
                                } else {
                                    block41: {
                                        try {
                                            UIStats.start(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                                            factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
                                            if (factory == null) {
                                                WorkbenchPlugin.log("Unable to restore page - cannot instantiate input factory: " + factoryID);
                                                result.add(this.unableToRestorePage(pageMem));
                                                var16_21 = null;
                                                break block41;
                                            }
                                            input = factory.createElement(inputMem);
                                            if (input != null) break block42;
                                            WorkbenchPlugin.log("Unable to restore page - cannot instantiate input element: " + factoryID);
                                            result.add(this.unableToRestorePage(pageMem));
                                            break block43;
                                        }
                                        catch (Throwable var17_23) {
                                            var16_21 = null;
                                            UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                                            throw var17_23;
                                        }
                                    }
                                    UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                                }
                                break block44;
                            }
                            var16_21 = null;
                            UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                            break block44;
                        }
                        var16_21 = null;
                        UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                    }
                    newPage = null;
                    try {
                        newPage = new WorkbenchPage(this, input);
                        result.add(newPage.restoreState(pageMem, activeDescriptor));
                        this.pageList.add(newPage);
                        this.firePageOpened(newPage);
                    }
                    catch (WorkbenchException e) {
                        WorkbenchPlugin.log("Unable to restore perspective - constructor failed.");
                        result.add(e.getStatus());
                        break block44;
                    }
                    if (strFocus != null && strFocus.length() > 0) {
                        newActivePage = newPage;
                    }
                }
                ++i;
            }
            {
                defPerspID = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
                newPage = new WorkbenchPage(this, defPerspID, this.getAdvisor().getDefaultPageInput());
                this.pageList.add(newPage);
                this.firePageOpened(newPage);
            }
lbl154:
            // 1 sources

            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Unable to create default perspective - constructor failed.");
                result.add(e.getStatus());
                productName = WorkbenchPlugin.getDefault().getProductName();
                if (productName == null) {
                    productName = "";
                }
                this.getShell().setText(productName);
            }
        }
        if (newActivePage == null) {
            newActivePage = this.pageList.getNextActive();
        }
        this.setActivePage(newActivePage);
        return result;
    }

    private boolean restoreOldCoolBar(IMemento coolbarMem) {
        if (coolbarMem == null) {
            return false;
        }
        CoolBarManager coolBarMgr = this.getCoolBarManager();
        Integer locked = coolbarMem.getInteger("locked");
        boolean state = locked != null && locked == 1;
        coolBarMgr.setLockLayout(state);
        IMemento visibleLayout = coolbarMem.getChild("toolbarLayout");
        ArrayList<Integer> visibleWrapIndicies = new ArrayList<Integer>();
        ArrayList<String> visibleItems = new ArrayList<String>();
        if (visibleLayout != null && !this.readLayout(visibleLayout, visibleItems, visibleWrapIndicies)) {
            return false;
        }
        IMemento rememberedLayout = coolbarMem.getChild("layout");
        ArrayList rememberedWrapIndicies = new ArrayList();
        ArrayList rememberedItems = new ArrayList();
        if (rememberedLayout != null && !this.readLayout(rememberedLayout, rememberedItems, rememberedWrapIndicies)) {
            return false;
        }
        if (visibleItems != null) {
            String id;
            Iterator i;
            if (rememberedItems != null) {
                int currentIndex = 0;
                i = rememberedItems.iterator();
                while (i.hasNext()) {
                    id = (String)i.next();
                    int index = -1;
                    Iterator iter = visibleItems.iterator();
                    while (iter.hasNext()) {
                        String visibleId = (String)iter.next();
                        if (!visibleId.equals(id)) continue;
                        index = visibleItems.indexOf(visibleId);
                        break;
                    }
                    if (index == -1) {
                        int insertAt = Math.max(0, Math.min(currentIndex, visibleItems.size()));
                        boolean separateLine = false;
                        Iterator iter2 = rememberedWrapIndicies.iterator();
                        while (iter2.hasNext()) {
                            Integer wrapIndex = (Integer)iter2.next();
                            if (wrapIndex > insertAt) continue;
                            insertAt = visibleItems.size();
                            visibleWrapIndicies.add(new Integer(insertAt));
                            separateLine = true;
                        }
                        visibleItems.add(insertAt, id);
                        if (!separateLine) {
                            int j = 0;
                            while (j < visibleWrapIndicies.size()) {
                                Integer index2 = (Integer)visibleWrapIndicies.get(j);
                                if (index2 >= insertAt) {
                                    visibleWrapIndicies.set(j, new Integer(index2 + 1));
                                }
                                ++j;
                            }
                        }
                    }
                    ++currentIndex;
                }
            }
            ArrayList<Object> layout = new ArrayList<Object>(visibleItems.size());
            i = visibleItems.iterator();
            while (i.hasNext()) {
                id = (String)i.next();
                IContributionItem oldItem = null;
                ToolBarContributionItem newItem = null;
                if (id != null) {
                    oldItem = coolBarMgr.find(id);
                }
                if (oldItem instanceof ToolBarContributionItem) {
                    newItem = (ToolBarContributionItem)oldItem;
                } else {
                    newItem = new ToolBarContributionItem((IToolBarManager)new ToolBarManager(coolBarMgr.getStyle()), id);
                    newItem.setVisible(false);
                    IContributionItem refItem = this.findAlphabeticalOrder("additions", id, (IContributionManager)coolBarMgr);
                    if (refItem != null) {
                        coolBarMgr.insertAfter(refItem.getId(), (IContributionItem)newItem);
                    } else {
                        coolBarMgr.add((IContributionItem)newItem);
                    }
                }
                if (newItem == null) continue;
                layout.add(newItem);
                newItem.setParent((IContributionManager)coolBarMgr);
                coolBarMgr.markDirty();
            }
            int offset = 0;
            int i2 = 1;
            while (i2 < visibleWrapIndicies.size()) {
                int insertAt = (Integer)visibleWrapIndicies.get(i2) + offset;
                layout.add(insertAt, new Separator("UserSeparator"));
                ++offset;
                ++i2;
            }
            IContributionItem[] items = coolBarMgr.getItems();
            int i3 = 0;
            while (i3 < items.length) {
                IContributionItem item = items[i3];
                if (item.isGroupMarker()) {
                    layout.add(Math.max(Math.min(i3, layout.size()), 0), item);
                }
                ++i3;
            }
            coolBarMgr.setLayout(layout);
        }
        return true;
    }

    private boolean readLayout(IMemento memento, ArrayList itemIds, ArrayList wrapIndicies) {
        IMemento[] wraps = memento.getChildren("wrapIndex");
        if (wraps == null) {
            return false;
        }
        int i = 0;
        while (i < wraps.length) {
            IMemento wrapMem = wraps[i];
            Integer index = wrapMem.getInteger("index");
            if (index == null) {
                return false;
            }
            wrapIndicies.add(index);
            ++i;
        }
        IMemento[] savedItems = memento.getChildren("item");
        if (savedItems == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < savedItems.length) {
            IMemento savedMem = savedItems[i2];
            String id = savedMem.getString("id");
            if (id == null) {
                return false;
            }
            itemIds.add(id);
            ++i2;
        }
        return true;
    }

    private IContributionItem findAlphabeticalOrder(String startId, String itemId, IContributionManager mgr) {
        IContributionItem[] items = mgr.getItems();
        int insertIndex = 0;
        while (insertIndex < items.length) {
            IContributionItem item = items[insertIndex];
            if (item.getId().equals(startId)) break;
            ++insertIndex;
        }
        int i = insertIndex + 1;
        while (i < items.length) {
            IContributionItem item = items[i];
            String testId = item.getId();
            if (item.isGroupMarker() || itemId != null && itemId.compareTo(testId) < 1) break;
            insertIndex = i++;
        }
        if (insertIndex >= items.length) {
            return null;
        }
        return items[insertIndex];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        IWorkbenchCommandSupport commandSupport = this.getWorkbench().getCommandSupport();
        boolean keyFilterEnabled = commandSupport.isKeyFilterEnabled();
        ToolBarManager shortcutBar = this.getShortcutBar();
        ToolBar shortcutBarControl = null;
        if (shortcutBar != null) {
            shortcutBarControl = shortcutBar.getControl();
        }
        boolean shortcutbarWasEnabled = false;
        if (shortcutBarControl != null) {
            shortcutbarWasEnabled = shortcutBarControl.getEnabled();
        }
        try {
            if (shortcutBarControl != null && !shortcutBarControl.isDisposed()) {
                shortcutBarControl.setEnabled(false);
            }
            if (keyFilterEnabled) {
                commandSupport.disableKeyFilter();
            }
            super.run(fork, cancelable, runnable);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (shortcutBarControl != null && !shortcutBarControl.isDisposed()) {
                shortcutBarControl.setEnabled(shortcutbarWasEnabled);
            }
            if (!keyFilterEnabled) throw throwable;
            commandSupport.enableKeyFilter();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        if (shortcutBarControl != null && !shortcutBarControl.isDisposed()) {
            shortcutBarControl.setEnabled(shortcutbarWasEnabled);
        }
        if (!keyFilterEnabled) return;
        commandSupport.enableKeyFilter();
    }

    private boolean saveAllPages(boolean bConfirm) {
        boolean bRet = true;
        Iterator iterator = this.pageList.iterator();
        while (bRet && iterator.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            bRet = page.saveAllEditors(bConfirm);
        }
        return bRet;
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("WorkbenchWindow.problemsSavingWindow"), null);
        if (this.getShell().getMaximized() || this.asMaximizedState) {
            memento.putString("maximized", "true");
        }
        if (this.getShell().getMinimized()) {
            memento.putString("minimized", "true");
        }
        if (this.normalBounds == null) {
            this.normalBounds = this.getShell().getBounds();
        }
        memento.putInteger("x", this.normalBounds.x);
        memento.putInteger("y", this.normalBounds.y);
        memento.putInteger("width", this.normalBounds.width);
        memento.putInteger("height", this.normalBounds.height);
        if (this.getCoolBarManager() != null) {
            this.getCoolBarManager().refresh();
            IMemento coolBarMem = memento.createChild("coolbarLayout");
            if (this.getCoolBarManager().getLockLayout()) {
                coolBarMem.putInteger("locked", 1);
            } else {
                coolBarMem.putInteger("locked", 0);
            }
            IContributionItem[] items = this.getCoolBarManager().getItems();
            int i = 0;
            while (i < items.length) {
                IMemento coolItemMem = coolBarMem.createChild("coolItem");
                IContributionItem item = items[i];
                if (item.getId() != null) {
                    coolItemMem.putString("id", item.getId());
                }
                if (item.isSeparator()) {
                    coolItemMem.putString("itemType", "typeSeparator");
                } else if (item.isGroupMarker() && !item.isSeparator()) {
                    coolItemMem.putString("itemType", "typeGroupMarker");
                } else {
                    coolItemMem.putString("itemType", "typeToolBarContribution");
                    ToolBarContributionItem tbItem = (ToolBarContributionItem)item;
                    tbItem.saveWidgetState();
                    coolItemMem.putInteger("x", tbItem.getCurrentWidth());
                    coolItemMem.putInteger("y", tbItem.getCurrentHeight());
                }
                ++i;
            }
        }
        Iterator iterator = this.pageList.iterator();
        while (iterator.hasNext()) {
            IPersistableElement persistable;
            IAdaptable input;
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            IMemento pageMem = memento.createChild("page");
            pageMem.putString("label", page.getLabel());
            result.add(page.saveState(pageMem));
            if (page == this.getActiveWorkbenchPage()) {
                pageMem.putString("focus", "true");
            }
            if ((input = page.getInput()) == null) continue;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.ui.IPersistableElement;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((persistable = (IPersistableElement)input.getAdapter((Class)clazz)) == null) {
                WorkbenchPlugin.log("Unable to save page input: " + input + ", because it does not adapt to IPersistableElement");
                continue;
            }
            IMemento inputMem = pageMem.createChild("input");
            inputMem.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(inputMem);
        }
        return result;
    }

    void selectPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page, boolean selected) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            IAction action = ((ActionContributionItem)item).getAction();
            action.setChecked(selected);
        }
    }

    public void setActivePage(final IWorkbenchPage in) {
        if (this.getActiveWorkbenchPage() == in) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                WorkbenchPage newPage;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    currentPage.onDeactivate();
                }
                if (in == null || WorkbenchWindow.this.pageList.contains(in)) {
                    WorkbenchWindow.this.pageList.setActive(in);
                }
                if ((newPage = WorkbenchWindow.this.pageList.getActive()) != null) {
                    newPage.onActivate();
                    WorkbenchWindow.this.firePageActivated(newPage);
                    if (newPage.getPerspective() != null) {
                        WorkbenchWindow.this.firePerspectiveActivated(newPage, newPage.getPerspective());
                    }
                }
                if (WorkbenchWindow.this.isClosing()) {
                    return;
                }
                WorkbenchWindow.this.updateDisabled = false;
                WorkbenchWindow.this.updateActionSets();
                WorkbenchWindow.this.shortcutBar.update(false);
                WorkbenchWindow.this.getMenuManager().update("text");
                if (WorkbenchWindow.this.noOpenPerspective != null && in != null) {
                    WorkbenchWindow.this.noOpenPerspective.dispose();
                    WorkbenchWindow.this.noOpenPerspective = null;
                }
            }
        });
    }

    private void showShortcutBarPopup(Point pt) {
        ToolBar toolBar = this.shortcutBar.getControl();
        ToolItem toolItem = toolBar.getItem(toolBar.toControl(pt));
        if (toolItem == null) {
            return;
        }
        Object data = toolItem.getData();
        if (data instanceof ShowFastViewContribution) {
            if (this.fastViewBarMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                MenuItem closeItem = new MenuItem(menu, 0);
                closeItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
                closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.fastViewBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            IViewReference ref = (IViewReference)toolItem.getData("FastView");
                            WorkbenchWindow.this.getActiveWorkbenchPage().hideView(ref);
                        }
                    }
                });
                this.restoreItem = new MenuItem(menu, 32);
                this.restoreItem.setText(WorkbenchMessages.getString("WorkbenchWindow.restore"));
                this.restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.fastViewBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            IViewReference ref = (IViewReference)toolItem.getData("FastView");
                            WorkbenchWindow.this.getActiveWorkbenchPage().removeFastView(ref);
                        }
                    }
                });
                this.fastViewBarMenu = menu;
            }
            this.restoreItem.setSelection(true);
            this.fastViewBarMenu.setData((Object)toolItem);
            if (this.fastViewBarMenu != null) {
                this.fastViewBarMenu.setLocation(pt.x, pt.y);
                this.fastViewBarMenu.setVisible(true);
            }
        }
        if (!(data instanceof ActionContributionItem)) {
            return;
        }
        IAction action = ((ActionContributionItem)data).getAction();
        if (action instanceof SetPagePerspectiveAction) {
            if (this.perspectiveBarMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.perspectiveBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            ActionContributionItem item = (ActionContributionItem)toolItem.getData();
                            SetPagePerspectiveAction action = (SetPagePerspectiveAction)item.getAction();
                            action.getPage().closePerspective(action.getPerspective(), true);
                        }
                    }
                });
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.closeAll"));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.perspectiveBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            ActionContributionItem item = (ActionContributionItem)toolItem.getData();
                            SetPagePerspectiveAction action = (SetPagePerspectiveAction)item.getAction();
                            action.getPage().closeAllPerspectives();
                        }
                    }
                });
                this.perspectiveBarMenu = menu;
            }
            this.perspectiveBarMenu.setData((Object)toolItem);
            if (this.perspectiveBarMenu != null) {
                this.perspectiveBarMenu.setLocation(pt.x, pt.y);
                this.perspectiveBarMenu.setVisible(true);
            }
        }
    }

    private void trackShellActivation(Shell shell) {
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.getWorkbenchImpl().setActivatedWindow(WorkbenchWindow.this);
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IEditorPart editor;
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellActivated();
                    }
                    if ((editor = currentPage.getActiveEditor()) != null) {
                        PartSite site = (PartSite)editor.getSite();
                        site.getPane().shellActivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IEditorPart editor;
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellDeactivated();
                    }
                    if ((editor = currentPage.getActiveEditor()) != null) {
                        PartSite site = (PartSite)editor.getSite();
                        site.getPane().shellDeactivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    private void trackShellResize(Shell newShell) {
        newShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                this.saveBounds();
            }

            public void controlResized(ControlEvent e) {
                this.saveBounds();
            }

            private void saveBounds() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell == null) {
                    return;
                }
                if (shell.isDisposed()) {
                    return;
                }
                if (shell.getMinimized()) {
                    return;
                }
                if (shell.getMaximized()) {
                    WorkbenchWindow.this.asMaximizedState = true;
                    return;
                }
                WorkbenchWindow.this.asMaximizedState = false;
                WorkbenchWindow.this.normalBounds = shell.getBounds();
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled) {
            return;
        }
        this.getMenuBarManager().updateAll(false);
        this.getCoolBarManager().update(false);
        this.getStatusLineManager().update(false);
    }

    public void updateActionSets() {
        if (this.updateDisabled) {
            return;
        }
        WorkbenchPage currentPage = this.getActiveWorkbenchPage();
        if (currentPage == null) {
            this.actionPresentation.clearActionSets();
        } else {
            if (this.getCoolBarManager() != null) {
                this.getCoolBarManager().refresh();
            }
            this.actionPresentation.setActionSets(currentPage.getActionSets());
        }
        this.updateActionBars();
        String path = "window/launch";
        IMenuManager manager = this.getMenuBarManager().findMenuUsingPath(path);
        IContributionItem item = this.getMenuBarManager().findUsingPath(path);
        IActionSet[] actionSets = this.actionPresentation.getActionSets();
        this.registerActionSets(actionSets);
        if (manager == null || item == null) {
            return;
        }
        item.setVisible(manager.getItems().length >= 2);
    }

    void updatePerspectiveShortcut(IPerspectiveDescriptor oldDesc, IPerspectiveDescriptor newDesc, WorkbenchPage page) {
        if (this.updateDisabled) {
            return;
        }
        IContributionItem item = this.findPerspectiveShortcut(oldDesc, page);
        if (item != null) {
            SetPagePerspectiveAction action = (SetPagePerspectiveAction)((ActionContributionItem)item).getAction();
            action.update(newDesc);
        }
    }

    private boolean showProgressIndicator() {
        return PlatformUI.getWorkbench().getPreferenceStore().getBoolean("showProgressIndicator");
    }

    private void createProgressIndicator(Shell shell) {
        if (this.showProgressIndicator()) {
            this.animationItem = new AnimationItem(this);
            this.animationItem.createControl((Composite)shell);
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
            this.windowConfigurer.init();
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    public void fillActionBars(IActionBarConfigurer configurer, int flags) {
        this.getAdvisor().fillActionBars(this, configurer, flags);
    }

    public IWorkbenchWindowCommandSupport getCommandSupport() {
        return this.workbenchWindowCommandSupport;
    }

    public IWorkbenchWindowContextSupport getContextSupport() {
        return this.workbenchWindowContextSupport;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.commands.IWorkbenchWindowCommandSupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getCommandSupport();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Lorg.eclipse.ui.contexts.IWorkbenchWindowContextSupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getContextSupport();
        }
        return null;
    }

    class WorkbenchWindowLayout
    extends Layout {
        WorkbenchWindowLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = new Point(0, 0);
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                boolean skip = false;
                if (w == WorkbenchWindow.this.getCoolBarControl()) {
                    skip = true;
                    result.y += 23;
                } else if (WorkbenchWindow.this.getShortcutBar() != null && w == WorkbenchWindow.this.getShortcutBar().getControl()) {
                    skip = true;
                }
                if (!skip) {
                    Point e = w.computeSize(wHint, hHint, flushCache);
                    result.x = Math.max(result.x, e.x);
                    result.y += e.y + 0;
                }
                ++i;
            }
            result.x += 23;
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Label sep3;
            Control statusLine;
            Label sep2;
            Rectangle clientArea = composite.getClientArea();
            if (WorkbenchWindow.this.getSeperator1() != null) {
                Point sep1Size = WorkbenchWindow.this.getSeperator1().computeSize(-1, -1, flushCache);
                WorkbenchWindow.this.getSeperator1().setBounds(clientArea.x, clientArea.y, clientArea.width, sep1Size.y);
                clientArea.y += sep1Size.y;
                clientArea.height -= sep1Size.y;
            }
            int coolBarWidth = clientArea.width;
            Control coolBar = WorkbenchWindow.this.getCoolBarControl();
            if (coolBar != null) {
                if (WorkbenchWindow.this.getWindowConfigurer().getShowCoolBar()) {
                    int height = 23;
                    if (WorkbenchWindow.this.coolBarChildrenExist()) {
                        Point coolBarSize = coolBar.computeSize(clientArea.width, -1, flushCache);
                        height = coolBarSize.y;
                    }
                    coolBar.setBounds(clientArea.x, clientArea.y, coolBarWidth, height);
                    clientArea.y += height;
                    clientArea.height -= height;
                } else {
                    WorkbenchWindow.this.getCoolBarControl().setBounds(0, 0, 0, 0);
                }
            }
            if ((sep2 = WorkbenchWindow.this.getSeparator2()) != null) {
                if (WorkbenchWindow.this.getWindowConfigurer().getShowCoolBar()) {
                    Point sep2Size = sep2.computeSize(-1, -1, flushCache);
                    sep2.setBounds(clientArea.x, clientArea.y, clientArea.width, sep2Size.y);
                    clientArea.y += sep2Size.y;
                    clientArea.height -= sep2Size.y;
                } else {
                    sep2.setBounds(0, 0, 0, 0);
                }
            }
            int width = 23;
            if (WorkbenchWindow.this.showProgressIndicator() && WorkbenchWindow.this.animationItem != null) {
                Control progressWidget = WorkbenchWindow.this.animationItem.getControl();
                Rectangle bounds = WorkbenchWindow.this.animationItem.getImageBounds();
                int offset = 0;
                if (width > bounds.width) {
                    offset = (width - bounds.width) / 2;
                }
                progressWidget.setBounds(offset, clientArea.y + clientArea.height - bounds.height, width, bounds.height);
                width = Math.max(width, bounds.width);
            }
            if (WorkbenchWindow.this.getStatusLineManager() != null && (statusLine = WorkbenchWindow.this.getStatusLineManager().getControl()) != null) {
                if (WorkbenchWindow.this.getWindowConfigurer().getShowStatusLine()) {
                    ToolBar bar;
                    ToolBar shortcutBar;
                    if (WorkbenchWindow.this.getShortcutBar() != null && WorkbenchWindow.this.getWindowConfigurer().getShowShortcutBar() && (shortcutBar = WorkbenchWindow.this.getShortcutBar().getControl()) != null && shortcutBar instanceof ToolBar && (bar = shortcutBar).getItemCount() > 0) {
                        ToolItem item = bar.getItem(0);
                        width = Math.max(width, item.getWidth());
                        Rectangle trim = bar.computeTrim(0, 0, width, width);
                        width = trim.width;
                    }
                    Point statusLineSize = statusLine.computeSize(-1, -1, flushCache);
                    statusLine.setBounds(clientArea.x + width, clientArea.y + clientArea.height - statusLineSize.y, clientArea.width - width, statusLineSize.y);
                    clientArea.height -= statusLineSize.y + 0;
                } else {
                    WorkbenchWindow.this.getStatusLineManager().getControl().setBounds(0, 0, 0, 0);
                }
            }
            if (WorkbenchWindow.this.getShortcutBar() != null) {
                ToolBar shortCutBar = WorkbenchWindow.this.getShortcutBar().getControl();
                if (shortCutBar != null && WorkbenchWindow.this.getWindowConfigurer().getShowShortcutBar()) {
                    ToolBar bar;
                    if (shortCutBar instanceof ToolBar && (bar = shortCutBar).getItemCount() > 0) {
                        ToolItem item = bar.getItem(0);
                        width = item.getWidth();
                        Rectangle trim = bar.computeTrim(0, 0, width, width);
                        width = trim.width;
                    }
                    shortCutBar.setBounds(clientArea.x, clientArea.y, width, clientArea.height);
                    clientArea.x += width + 0;
                    clientArea.width -= width + 0;
                }
            } else {
                WorkbenchWindow.this.getShortcutBar().getControl().setBounds(0, 0, 0, 0);
            }
            if ((sep3 = WorkbenchWindow.this.getSeparator3()) != null) {
                if (WorkbenchWindow.this.getWindowConfigurer().getShowShortcutBar()) {
                    Point sep3Size = sep3.computeSize(-1, -1, flushCache);
                    sep3.setBounds(clientArea.x, clientArea.y, sep3Size.x, clientArea.height);
                    clientArea.x += sep3Size.x;
                } else {
                    sep3.setBounds(0, 0, 0, 0);
                }
            }
            if (WorkbenchWindow.this.getClientComposite() != null) {
                WorkbenchWindow.this.getClientComposite().setBounds(clientArea.x + 3, clientArea.y + 3 + 0, clientArea.width - 6, clientArea.height - 0 - 6);
            }
        }
    }

    class PageList {
        private List pageList = new ArrayList(4);
        private List pageStack = new ArrayList(4);
        private Object active;

        public boolean add(Object object) {
            this.pageList.add(object);
            this.pageStack.add(0, object);
            return true;
        }

        public Iterator iterator() {
            return this.pageList.iterator();
        }

        public boolean contains(Object object) {
            return this.pageList.contains(object);
        }

        public boolean remove(Object object) {
            if (this.active == object) {
                this.active = null;
            }
            this.pageStack.remove(object);
            return this.pageList.remove(object);
        }

        public boolean isEmpty() {
            return this.pageList.isEmpty();
        }

        public IWorkbenchPage[] getPages() {
            int nSize = this.pageList.size();
            IWorkbenchPage[] retArray = new IWorkbenchPage[nSize];
            this.pageList.toArray(retArray);
            return retArray;
        }

        public void setActive(Object page) {
            if (this.active == page) {
                return;
            }
            this.active = page;
            if (page != null) {
                this.pageStack.remove(page);
                this.pageStack.add(page);
            }
        }

        public WorkbenchPage getActive() {
            return (WorkbenchPage)this.active;
        }

        public WorkbenchPage getNextActive() {
            if (this.active == null) {
                if (this.pageStack.isEmpty()) {
                    return null;
                }
                return (WorkbenchPage)this.pageStack.get(this.pageStack.size() - 1);
            }
            if (this.pageStack.size() < 2) {
                return null;
            }
            return (WorkbenchPage)this.pageStack.get(this.pageStack.size() - 2);
        }
    }
}

