/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;

public class WorkbenchImages {
    private static Map descriptors = new HashMap();
    private static ImageRegistry imageRegistry;
    private static ReferenceCounter imageCache;
    private static final URL URL_BASIC;
    public static final String ICONS_PATH = "icons/full/";
    private static final String PATH_CTOOL = "icons/full/ctool16/";
    private static final String PATH_ETOOL = "icons/full/etool16/";
    private static final String PATH_DTOOL = "icons/full/dtool16/";
    private static final String PATH_CLOCALTOOL = "icons/full/clcl16/";
    private static final String PATH_ELOCALTOOL = "icons/full/elcl16/";
    private static final String PATH_DLOCALTOOL = "icons/full/dlcl16/";
    private static final String PATH_CVIEW = "icons/full/cview16/";
    private static final String PATH_EVIEW = "icons/full/eview16/";
    private static final String PATH_OBJECT = "icons/full/obj16/";
    private static final String PATH_DND = "icons/full/dnd/";
    private static final String PATH_WIZBAN = "icons/full/wizban/";

    static {
        imageCache = new ReferenceCounter();
        URL_BASIC = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
    }

    public static ReferenceCounter getImageCache() {
        return imageCache;
    }

    private static final void declareImage(String key, String path, boolean shared) {
        URL url = null;
        try {
            url = new URL(URL_BASIC, path);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        WorkbenchImages.declareImage(key, desc, shared);
    }

    private static final void declareImages() {
        WorkbenchImages.declareImage("IMG_CTOOL_PIN_EDITOR", "icons/full/etool16/pin_editor.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_PIN_EDITOR_HOVER", "icons/full/ctool16/pin_editor.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_PIN_EDITOR_DISABLED", "icons/full/dtool16/pin_editor.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVE_EDIT", "icons/full/etool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVE_EDIT_HOVER", "icons/full/ctool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVE_EDIT_DISABLED", "icons/full/dtool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEAS_EDIT", "icons/full/etool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEAS_EDIT_HOVER", "icons/full/ctool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEAS_EDIT_DISABLED", "icons/full/dtool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEALL_EDIT", "icons/full/etool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEALL_EDIT_HOVER", "icons/full/ctool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_SAVEALL_EDIT_DISABLED", "icons/full/dtool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO", "icons/full/etool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO_HOVER", "icons/full/ctool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO_DISABLED", "icons/full/dtool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO", "icons/full/etool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO_HOVER", "icons/full/ctool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO_DISABLED", "icons/full/dtool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT", "icons/full/etool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT_HOVER", "icons/full/ctool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT_DISABLED", "icons/full/dtool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY", "icons/full/etool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY_HOVER", "icons/full/ctool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY_DISABLED", "icons/full/dtool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE", "icons/full/etool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE_HOVER", "icons/full/ctool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE_DISABLED", "icons/full/dtool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE", "icons/full/etool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE_HOVER", "icons/full/ctool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE_DISABLED", "icons/full/dtool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_CTOOL_PRINT_EDIT", "icons/full/etool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_PRINT_EDIT_HOVER", "icons/full/ctool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_PRINT_EDIT_DISABLED", "icons/full/dtool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD", "icons/full/elcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD_HOVER", "icons/full/clcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD_DISABLED", "icons/full/dlcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK", "icons/full/elcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK_HOVER", "icons/full/clcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK_DISABLED", "icons/full/dlcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP", "icons/full/elcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP_HOVER", "icons/full/clcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP_DISABLED", "icons/full/dlcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_CTOOL_NEW_PAGE", "icons/full/eview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_NEW_PAGE_HOVER", "icons/full/cview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_HOME_NAV", "icons/full/clcl16/home_nav.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_DEF_PERSPECTIVE", "icons/full/eview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_CTOOL_DEF_PERSPECTIVE_HOVER", "icons/full/cview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_WORKINGSET_WIZ", "icons/full/wizban/workset_wiz.gif", false);
        WorkbenchImages.declareImage("IMG_VIEW_DEFAULTVIEW_MISC", "icons/full/cview16/defaultview_misc.gif", false);
        WorkbenchImages.declareImage("IMG_DLGBAN_SAVEAS_DLG", "icons/full/wizban/saveas_dlg.gif", false);
        WorkbenchImages.declareImage("IMG_OBJ_FILE", "icons/full/obj16/file_obj.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_FOLDER", "icons/full/obj16/fldr_obj.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_ELEMENTS", "icons/full/obj16/elements_obj.gif", true);
        WorkbenchImages.declareImage("IMG_DEF_VIEW", "icons/full/cview16/defaultview_misc.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW", "icons/full/elcl16/close_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW_HOVER", "icons/full/clcl16/close_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_PIN_VIEW", "icons/full/elcl16/pin_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_PIN_VIEW_HOVER", "icons/full/clcl16/pin_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW", "icons/full/elcl16/min_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW_HOVER", "icons/full/clcl16/min_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU", "icons/full/elcl16/view_menu.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU_HOVER", "icons/full/clcl16/view_menu.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_ERROR_TSK", "icons/full/obj16/error_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_WARN_TSK", "icons/full/obj16/warn_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_INFO_TSK", "icons/full/obj16/info_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_SOURCE", "icons/full/dnd/left_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_MASK", "icons/full/dnd/left_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_SOURCE", "icons/full/dnd/right_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_MASK", "icons/full/dnd/right_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_SOURCE", "icons/full/dnd/top_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_MASK", "icons/full/dnd/top_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_SOURCE", "icons/full/dnd/bottom_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_MASK", "icons/full/dnd/bottom_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_SOURCE", "icons/full/dnd/invalid_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_MASK", "icons/full/dnd/invalid_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_SOURCE", "icons/full/dnd/stack_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_MASK", "icons/full/dnd/stack_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_SOURCE", "icons/full/dnd/offscreen_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_MASK", "icons/full/dnd/offscreen_mask.bmp", true);
    }

    public static void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        descriptors.put(symbolicName, descriptor);
        if (shared) {
            imageRegistry.put(symbolicName, descriptor);
        }
    }

    public static Image getImage(String symbolicName) {
        return WorkbenchImages.getImageRegistry().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptor(String symbolicName) {
        return (ImageDescriptor)descriptors.get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptorFromProgram(String filename, int offset) {
        Assert.isNotNull(filename);
        String key = String.valueOf(filename) + "*" + offset;
        ImageDescriptor desc = WorkbenchImages.getImageDescriptor(key);
        if (desc == null) {
            desc = new ProgramImageDescriptor(filename, offset);
            descriptors.put(key, desc);
        }
        return desc;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        WorkbenchImages.declareImages();
        return imageRegistry;
    }
}

