/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.CommandHandlerServiceEvent;
import org.eclipse.ui.commands.CommandManagerEvent;
import org.eclipse.ui.commands.ICommandHandlerServiceListener;
import org.eclipse.ui.commands.ICommandManagerListener;
import org.eclipse.ui.commands.IWorkbenchWindowCommandSupport;
import org.eclipse.ui.contexts.ContextActivationServiceEvent;
import org.eclipse.ui.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.IContextActivationServiceListener;
import org.eclipse.ui.contexts.IContextManagerListener;
import org.eclipse.ui.contexts.IWorkbenchWindowContextSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.CommandManager;

public class WorkbenchCommandsAndContexts {
    final ICommandHandlerServiceListener commandHandlerServiceListener = new ICommandHandlerServiceListener(){

        public void commandHandlerServiceChanged(CommandHandlerServiceEvent commandHandlerServiceEvent) {
            WorkbenchCommandsAndContexts.this.commandHandlerServiceChanged();
        }
    };
    final ICommandManagerListener commandManagerListener = new ICommandManagerListener(){

        public final void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(false);
        }
    };
    final IContextActivationServiceListener contextActivationServiceListener = new IContextActivationServiceListener(){

        public void contextActivationServiceChanged(ContextActivationServiceEvent contextActivationServiceEvent) {
            WorkbenchCommandsAndContexts.this.contextActivationServiceChanged();
        }
    };
    final IContextManagerListener contextManagerListener = new IContextManagerListener(){

        public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(false);
        }
    };
    final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow workbenchWindow) {
            if (workbenchWindow != null) {
                IWorkbenchWindowContextSupport workbenchWindowContextSupport;
                IWorkbenchWindowCommandSupport workbenchWindowCommandSupport = workbenchWindow.getCommandSupport();
                if (workbenchWindowCommandSupport != null) {
                    workbenchWindowCommandSupport.getCommandHandlerService().addCommandHandlerServiceListener(WorkbenchCommandsAndContexts.this.commandHandlerServiceListener);
                }
                if ((workbenchWindowContextSupport = workbenchWindow.getContextSupport()) != null) {
                    workbenchWindowContextSupport.getContextActivationService().addContextActivationServiceListener(WorkbenchCommandsAndContexts.this.contextActivationServiceListener);
                }
            }
            WorkbenchCommandsAndContexts.this.commandHandlerServiceChanged();
            WorkbenchCommandsAndContexts.this.contextActivationServiceChanged();
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowClosed(IWorkbenchWindow workbenchWindow) {
            WorkbenchCommandsAndContexts.this.commandHandlerServiceChanged();
            WorkbenchCommandsAndContexts.this.contextActivationServiceChanged();
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowDeactivated(IWorkbenchWindow workbenchWindow) {
            WorkbenchCommandsAndContexts.this.commandHandlerServiceChanged();
            WorkbenchCommandsAndContexts.this.contextActivationServiceChanged();
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowOpened(IWorkbenchWindow workbenchWindow) {
            WorkbenchCommandsAndContexts.this.commandHandlerServiceChanged();
            WorkbenchCommandsAndContexts.this.contextActivationServiceChanged();
            WorkbenchCommandsAndContexts.this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    Workbench workbench;

    WorkbenchCommandsAndContexts(Workbench workbench) {
        this.workbench = workbench;
    }

    public void commandHandlerServiceChanged() {
        IWorkbenchWindowCommandSupport workbenchWindowCommandSupport;
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        Map handlersByCommandId = new HashMap();
        if (workbenchWindow != null && (workbenchWindowCommandSupport = workbenchWindow.getCommandSupport()) != null) {
            handlersByCommandId = workbenchWindowCommandSupport.getCommandHandlerService().getHandlersByCommandId();
        }
        ((CommandManager)this.workbench.getCommandManager()).setActionsById(handlersByCommandId);
    }

    public void contextActivationServiceChanged() {
        IWorkbenchWindowContextSupport workbenchWindowContextSupport;
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        Set activeContextIds = new HashSet();
        if (workbenchWindow != null && (workbenchWindowContextSupport = workbenchWindow.getContextSupport()) != null) {
            activeContextIds = workbenchWindowContextSupport.getContextActivationService().getActiveContextIds();
        }
        this.workbench.getCommandManager().setActiveActivityIds(activeContextIds);
    }

    public void updateActiveWorkbenchWindowMenuManager(boolean textOnly) {
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (workbenchWindow instanceof WorkbenchWindow) {
            MenuManager menuManager = ((WorkbenchWindow)workbenchWindow).getMenuManager();
            if (textOnly) {
                menuManager.update("text");
            } else {
                menuManager.updateAll(true);
            }
        }
    }
}

