/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.ViewActionBars;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.ViewDescriptor;

class ViewFactory {
    private ReferenceCounter counter;
    private HashMap mementoTable = new HashMap();
    private WorkbenchPage page;
    private IViewRegistry viewReg;

    public ViewFactory(WorkbenchPage page, IViewRegistry reg) {
        this.page = page;
        this.viewReg = reg;
        this.counter = new ReferenceCounter();
    }

    public IStatus busyRestoreView(final IViewReference ref) {
        if (ref.getPart(false) != null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        final String viewID = ref.getId();
        final IMemento stateMem = (IMemento)this.mementoTable.get(viewID);
        this.mementoTable.remove(viewID);
        final boolean[] resetPart = new boolean[]{true};
        final IStatus[] result = new IStatus[]{new Status(0, "org.eclipse.ui", 0, "", null)};
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
                if (resetPart[0]) {
                    ((ViewReference)ref).setPart(null);
                    ViewFactory.this.page.hideView(ref);
                }
                result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.exceptionRestoringView", new String[]{viewID}), e);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                PartPane pane2;
                IViewDescriptor desc = ViewFactory.this.viewReg.find(viewID);
                if (desc == null) {
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.couldNotCreate", new Object[]{viewID}), null);
                    return;
                }
                IViewPart view = null;
                String label = desc.getLabel();
                try {
                    try {
                        UIStats.start(UIStats.CREATE_PART, label);
                        view = desc.createView();
                    }
                    catch (Throwable throwable) {
                        Object var4_9 = null;
                        UIStats.end(UIStats.CREATE_PART, label);
                        throw throwable;
                    }
                    {
                        Object var4_10 = null;
                    }
                    UIStats.end(UIStats.CREATE_PART, label);
                    ((ViewReference)ref).setPart(view);
                }
                catch (CoreException e) {
                    PartPane pane2 = ((ViewReference)ref).getPane();
                    if (pane2 != null) {
                        ViewFactory.this.page.getPerspectivePresentation().removePart(pane2);
                        pane2.dispose();
                    }
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.initException", new Object[]{desc.getID()}), (Throwable)e);
                    return;
                }
                ViewSite site = new ViewSite(view, ViewFactory.this.page, desc);
                try {
                    try {
                        UIStats.start(UIStats.INIT_PART, label);
                        view.init(site, stateMem);
                    }
                    catch (Throwable throwable) {
                        Object pane2 = null;
                        UIStats.end(UIStats.INIT_PART, label);
                        throw throwable;
                    }
                    {
                        pane2 = null;
                        UIStats.end(UIStats.INIT_PART, label);
                    }
                }
                catch (PartInitException e) {
                    ViewFactory.this.releaseView(viewID);
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.exceptionRestoringView", new String[]{viewID}), (Throwable)((Object)e));
                    return;
                }
                if (view.getSite() != site) {
                    ViewFactory.this.releaseView(viewID);
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.siteException", new Object[]{desc.getID()}), null);
                    return;
                }
                pane2 = ((ViewReference)ref).getPane();
                if (pane2 == null) {
                    pane2 = new ViewPane(ref, ViewFactory.this.page);
                    ((ViewReference)ref).setPane(pane2);
                }
                site.setPane(pane2);
                site.setActionBars(new ViewActionBars(ViewFactory.this.page.getActionBars(), (ViewPane)pane2));
                resetPart[0] = false;
                site.getPane().createChildControl();
                result[0] = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        });
        return result[0];
    }

    public IViewReference createView(String id) throws PartInitException {
        IViewDescriptor desc = this.viewReg.find(id);
        if (desc == null) {
            throw new PartInitException(WorkbenchMessages.format("ViewFactory.couldNotCreate", new Object[]{id}));
        }
        IViewReference ref = (IViewReference)this.counter.get(desc);
        if (ref == null) {
            ref = new ViewReference(id);
            this.counter.put(desc, ref);
        } else {
            this.counter.addRef(desc);
        }
        return ref;
    }

    private void destroyView(IViewDescriptor desc, IViewPart view) {
        PartSite site = (PartSite)view.getSite();
        ViewActionBars actionBars = (ViewActionBars)site.getActionBars();
        actionBars.dispose();
        PartPane pane = site.getPane();
        pane.dispose();
        site.dispose();
    }

    public IViewReference getView(String id) {
        IViewDescriptor desc = this.viewReg.find(id);
        return (IViewReference)this.counter.get(desc);
    }

    public IViewRegistry getViewRegistry() {
        return this.viewReg;
    }

    public IViewReference[] getViews() {
        List list = this.counter.values();
        IViewReference[] array = new IViewReference[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (IViewReference)list.get(i);
            ++i;
        }
        return array;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public boolean hasView(String id) {
        IViewDescriptor desc = this.viewReg.find(id);
        Object view = this.counter.get(desc);
        return view != null;
    }

    public void releaseView(String id) {
        IViewPart view;
        IViewDescriptor desc = this.viewReg.find(id);
        IViewReference ref = (IViewReference)this.counter.get(desc);
        if (ref == null) {
            return;
        }
        int count = this.counter.removeRef(desc);
        if (count <= 0 && (view = (IViewPart)ref.getPart(false)) != null) {
            this.destroyView(desc, view);
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] mem = memento.getChildren("view");
        int i = 0;
        while (i < mem.length) {
            String id = mem[i].getString("id");
            this.mementoTable.put(id, mem[i].getChild("viewState"));
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus restoreView(final IViewReference ref) {
        final IStatus[] result = new IStatus[1];
        BusyIndicator.showWhile((Display)this.page.getWorkbenchWindow().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                result[0] = ViewFactory.this.busyRestoreView(ref);
            }
        });
        return result[0];
    }

    public IStatus saveState(IMemento memento) {
        final MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("ViewFactory.problemsSavingViews"), null);
        final IViewReference[] refs = this.getViews();
        int i = 0;
        while (i < refs.length) {
            final IMemento viewMemento = memento.createChild("view");
            viewMemento.putString("id", refs[i].getId());
            final IViewPart view = (IViewPart)refs[i].getPart(false);
            if (view != null) {
                final int index = i;
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable e) {
                        result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.couldNotSave", new String[]{refs[index].getTitle()}), e));
                    }

                    public void run() {
                        view.saveState(viewMemento.createChild("viewState"));
                    }
                });
            } else {
                IMemento mem = (IMemento)this.mementoTable.get(refs[i].getId());
                if (mem != null) {
                    IMemento child = viewMemento.createChild("viewState");
                    child.putMemento(mem);
                }
            }
            ++i;
        }
        return result;
    }

    private class ViewReference
    extends WorkbenchPartReference
    implements IViewReference {
        boolean create = true;

        public ViewReference(String id) {
            ViewDescriptor desc = (ViewDescriptor)ViewFactory.this.viewReg.find(id);
            ImageDescriptor iDesc = null;
            String title = null;
            if (desc != null) {
                iDesc = desc.getImageDescriptor();
                title = desc.getLabel();
            }
            this.init(id, title, null, iDesc);
        }

        public void dispose() {
            super.dispose();
            this.create = false;
        }

        public IWorkbenchPage getPage() {
            return ViewFactory.this.page;
        }

        public IWorkbenchPart getPart(boolean restore) {
            if (this.part != null) {
                return this.part;
            }
            if (!this.create) {
                return null;
            }
            if (restore) {
                IStatus status = ViewFactory.this.restoreView(this);
                if (status.getSeverity() == 4) {
                    this.create = false;
                    Workbench workbench = (Workbench)PlatformUI.getWorkbench();
                    if (!workbench.isStarting()) {
                        ErrorDialog.openError((Shell)ViewFactory.this.page.getWorkbenchWindow().getShell(), (String)WorkbenchMessages.getString("ViewFactory.unableToRestoreViewTitle"), (String)WorkbenchMessages.format("ViewFactory.unableToRestoreViewMessage", new String[]{this.getTitle()}), (IStatus)status, (int)6);
                    }
                } else {
                    this.releaseReferences();
                }
            }
            return this.part;
        }

        public String getRegisteredName() {
            if (this.part != null) {
                return this.part.getSite().getRegisteredName();
            }
            IViewRegistry reg = ViewFactory.this.viewReg;
            IViewDescriptor desc = reg.find(this.getId());
            if (desc != null) {
                return desc.getLabel();
            }
            return this.getTitle();
        }

        public IViewPart getView(boolean restore) {
            return (IViewPart)this.getPart(restore);
        }

        public boolean isFastView() {
            return ViewFactory.this.page.isFastView(this);
        }
    }
}

