/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ShowViewAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    private Comparator actionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (collator == null) {
                ShowViewMenu.collator = Collator.getInstance();
            }
            IAction a1 = (IAction)o1;
            IAction a2 = (IAction)o2;
            return collator.compare(a1.getText(), a2.getText());
        }
    };
    private Action showDlgAction = new Action(WorkbenchMessages.getString("ShowView.title")){

        public void run() {
            ShowViewMenu.this.showOther();
        }
    };
    private Map actions = new HashMap(21);
    private Map openedViews = new HashMap();
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };
    private static Collator collator;

    public ShowViewMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
        WorkbenchHelp.setHelp((IAction)this.showDlgAction, "org.eclipse.ui.show_view_other_action_context");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            return;
        }
        List viewIds = ((WorkbenchPage)page).getShowViewActionIds();
        viewIds = this.addOpenedViews(page, viewIds);
        ArrayList<IAction> actions = new ArrayList<IAction>(viewIds.size());
        Iterator i = viewIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            IAction action = this.getAction(id);
            if (action == null || WorkbenchActivityHelper.filterItem(action)) continue;
            actions.add(action);
        }
        Collections.sort(actions, this.actionComparator);
        i = actions.iterator();
        while (i.hasNext()) {
            innerMgr.add((IAction)i.next());
        }
        innerMgr.add((IContributionItem)new Separator());
        innerMgr.add((IAction)this.showDlgAction);
    }

    private List addOpenedViews(IWorkbenchPage page, List actions) {
        Object element;
        ArrayList views = this.getParts(page);
        ArrayList result = new ArrayList(views.size() + actions.size());
        int i = 0;
        while (i < actions.size()) {
            element = actions.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < views.size()) {
            element = views.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private IAction getAction(String id) {
        IViewRegistry reg;
        IViewDescriptor desc;
        Object action = (IAction)this.actions.get(id);
        if (action == null && (desc = (reg = WorkbenchPlugin.getDefault().getViewRegistry()).find(id)) != null) {
            action = new ShowViewAction(this.window, desc);
            this.actions.put(id, action);
        }
        return action;
    }

    private void showOther() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        ShowViewDialog dlg = new ShowViewDialog(this.window.getShell(), WorkbenchPlugin.getDefault().getViewRegistry());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        IViewDescriptor[] descs = dlg.getSelection();
        int i = 0;
        while (i < descs.length) {
            try {
                page.showView(descs[i].getID());
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("ShowView.errorTitle"), (String)e.getMessage(), (IStatus)e.getStatus());
            }
            ++i;
        }
    }

    private ArrayList getParts(IWorkbenchPage page) {
        ArrayList parts = (ArrayList)this.openedViews.get(page);
        if (parts == null) {
            parts = new ArrayList();
            this.openedViews.put(page, parts);
        }
        return parts;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fill(menu, index++);
            ++i;
        }
        this.dirty = false;
    }
}

