/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ShowInAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ShowInMenu
extends ContributionItem {
    private static final String NO_TARGETS_MSG = WorkbenchMessages.getString("Workbench.showInNoTargets");
    private IWorkbenchWindow window;
    private Map actions = new HashMap(21);
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowInMenu.this.dirty = true;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ShowInMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPart sourcePart = this.getSourcePart();
        if (sourcePart == null) {
            return;
        }
        ShowInContext context = this.getContext(sourcePart);
        if (context == null) {
            return;
        }
        if (context.getInput() == null && (context.getSelection() == null || context.getSelection().isEmpty())) {
            return;
        }
        IViewDescriptor[] viewDescs = this.getViewDescriptors(sourcePart);
        if (viewDescs.length == 0) {
            return;
        }
        int i = 0;
        while (i < viewDescs.length) {
            IAction action = this.getAction(viewDescs[i]);
            if (action != null) {
                innerMgr.add(action);
            }
            ++i;
        }
    }

    private IAction getAction(IViewDescriptor desc) {
        Object action = (IAction)this.actions.get(desc.getId());
        if (action == null && desc != null) {
            action = new ShowInAction(this.window, desc);
            this.actions.put(desc.getId(), action);
        }
        return action;
    }

    private ArrayList getShowInPartIds(IWorkbenchPart sourcePart) {
        String[] partIds;
        IShowInTargetList targetList;
        ArrayList<String> targetIds = new ArrayList<String>();
        WorkbenchPage page = (WorkbenchPage)this.getWindow().getActivePage();
        if (page != null) {
            targetIds.addAll(page.getShowInPartIds());
        }
        if ((targetList = this.getShowInTargetList(sourcePart)) != null && (partIds = targetList.getShowInTargetIds()) != null) {
            int i = 0;
            while (i < partIds.length) {
                if (!targetIds.contains(partIds[i])) {
                    targetIds.add(partIds[i]);
                }
                ++i;
            }
        }
        page.sortShowInPartIds(targetIds);
        return targetIds;
    }

    private IWorkbenchPart getSourcePart() {
        IWorkbenchPage page = this.getWindow().getActivePage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        Object o;
        if (sourcePart instanceof IShowInSource) {
            return (IShowInSource)((Object)sourcePart);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.part.IShowInSource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = sourcePart.getAdapter(clazz)) instanceof IShowInSource) {
            return (IShowInSource)o;
        }
        return null;
    }

    private IShowInTargetList getShowInTargetList(IWorkbenchPart sourcePart) {
        Object o;
        if (sourcePart instanceof IShowInTargetList) {
            return (IShowInTargetList)((Object)sourcePart);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.part.IShowInTargetList;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = sourcePart.getAdapter(clazz)) instanceof IShowInTargetList) {
            return (IShowInTargetList)o;
        }
        return null;
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    private IViewDescriptor[] getViewDescriptors(IWorkbenchPart sourcePart) {
        String srcId = sourcePart.getSite().getId();
        ArrayList ids = this.getShowInPartIds(sourcePart);
        ArrayList<IViewDescriptor> descs = new ArrayList<IViewDescriptor>();
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            IViewDescriptor desc;
            String id = (String)i.next();
            if (id.equals(srcId) || (desc = reg.find(id)) == null) continue;
            descs.add(desc);
        }
        return descs.toArray(new IViewDescriptor[descs.size()]);
    }
}

