/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPropertyListener;

public class PerspectiveHistory {
    private static final int DEFAULT_DEPTH = 50;
    private ArrayList shortcuts;
    private IPerspectiveRegistry reg;
    private ListenerList listeners = new ListenerList();

    public PerspectiveHistory(IPerspectiveRegistry reg) {
        this.shortcuts = new ArrayList(50);
        this.reg = reg;
    }

    public void addListener(IPropertyListener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(IPropertyListener l) {
        this.listeners.remove((Object)l);
    }

    private void fireChange() {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertyListener element = (IPropertyListener)array[i];
            element.propertyChanged(this, 0);
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren("desc");
        int i = 0;
        while (i < children.length && i < 50) {
            IPerspectiveDescriptor desc = this.reg.findPerspectiveWithId(children[i].getID());
            if (desc != null) {
                this.shortcuts.add(desc);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        Iterator iter = this.shortcuts.iterator();
        while (iter.hasNext()) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)iter.next();
            memento.createChild("desc", desc.getId());
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void add(String id) {
        IPerspectiveDescriptor desc = this.reg.findPerspectiveWithId(id);
        if (desc != null) {
            this.add(desc);
        }
    }

    public void add(IPerspectiveDescriptor desc) {
        if (this.shortcuts.contains(desc)) {
            return;
        }
        int size = this.shortcuts.size();
        int preferredSize = 50;
        while (size >= preferredSize) {
            this.shortcuts.remove(--size);
        }
        this.shortcuts.add(0, desc);
        this.fireChange();
    }

    public void refreshFromRegistry() {
        boolean change = false;
        Iterator iter = this.shortcuts.iterator();
        while (iter.hasNext()) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)iter.next();
            if (this.reg.findPerspectiveWithId(desc.getId()) != null) continue;
            iter.remove();
            change = true;
        }
        if (change) {
            this.fireChange();
        }
    }

    public int copyItems(List dest, int destStart, int count) {
        int itemCount = count;
        if (itemCount > this.shortcuts.size()) {
            itemCount = this.shortcuts.size();
        }
        int i = 0;
        while (i < itemCount) {
            dest.add(destStart + i, this.shortcuts.get(i));
            ++i;
        }
        return itemCount;
    }
}

