/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.commands.IWorkbenchPartSiteCommandSupport;
import org.eclipse.ui.contexts.IWorkbenchPartSiteContextSupport;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.commands.ws.WorkbenchPartSiteCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchPartSiteContextSupport;

public class PartSite
implements IWorkbenchPartSite {
    private IWorkbenchPart part;
    private IWorkbenchPage page;
    private PartPane pane;
    private IConfigurationElement configElement;
    private String extensionID;
    private String pluginID;
    private String extensionName;
    private ISelectionProvider selectionProvider;
    private SubActionBars actionBars;
    private KeyBindingService keyBindingService;
    private ArrayList menuExtenders;
    private IWorkbenchPartSiteCommandSupport workbenchPartSiteCommandSupport;
    private IWorkbenchPartSiteContextSupport workbenchPartSiteContextSupport;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PartSite(IWorkbenchPart part, IWorkbenchPage page) {
        this.part = part;
        this.page = page;
        this.extensionID = "org.eclipse.ui.UnknownID";
        this.extensionName = "Unknown Name";
        this.workbenchPartSiteCommandSupport = new WorkbenchPartSiteCommandSupport();
        this.workbenchPartSiteContextSupport = new WorkbenchPartSiteContextSupport();
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            int i = 0;
            while (i < this.menuExtenders.size()) {
                ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                ++i;
            }
            this.menuExtenders = null;
        }
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getId() {
        return this.extensionID;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public PartPane getPane() {
        return this.pane;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public String getPluginId() {
        return this.pluginID;
    }

    public String getRegisteredName() {
        return this.extensionName;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.page.getWorkbenchWindow().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.page.getWorkbenchWindow();
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        this.menuExtenders.add(new PopupMenuExtender(menuID, menuMgr, selProvider, this.part));
    }

    public void registerContextMenu(MenuManager menuMgr, ISelectionProvider selProvider) {
        this.registerContextMenu(this.getId(), menuMgr, selProvider);
    }

    public String[] getContextMenuIds() {
        if (this.menuExtenders == null) {
            return new String[0];
        }
        String[] menuIds = new String[this.menuExtenders.size()];
        int index = 0;
        Iterator iter = this.menuExtenders.iterator();
        while (iter.hasNext()) {
            menuIds[index++] = ((PopupMenuExtender)iter.next()).getMenuId();
        }
        return menuIds;
    }

    public void setActionBars(SubActionBars bars) {
        this.actionBars = bars;
    }

    public void setConfigurationElement(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.extensionID = configElement.getAttribute("id");
        IPluginDescriptor pd = configElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        this.pluginID = pd.getUniqueIdentifier();
        String name = configElement.getAttribute("name");
        if (name != null) {
            this.extensionName = name;
        }
    }

    public void setPane(PartPane pane) {
        this.pane = pane;
    }

    public void setPart(IWorkbenchPart newPart) {
        this.part = newPart;
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            ActionDescriptor[] actionDescriptors;
            EditorActionBuilder.ExternalContributor contributor;
            this.keyBindingService = new KeyBindingService(this.workbenchPartSiteCommandSupport.getMutableCommandHandlerService(), this.workbenchPartSiteContextSupport.getMutableContextActivationService());
            if (this instanceof EditorSite && (contributor = (EditorActionBuilder.ExternalContributor)((EditorSite)this).getExtensionActionBarContributor()) != null && (actionDescriptors = contributor.getExtendedActions()) != null) {
                int i = 0;
                while (i < actionDescriptors.length) {
                    PluginAction action;
                    ActionDescriptor actionDescriptor = actionDescriptors[i];
                    if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                        this.keyBindingService.registerAction((IAction)action);
                    }
                    ++i;
                }
            }
        }
        return this.keyBindingService;
    }

    protected String getInitialScopeId() {
        return null;
    }

    public void schedule(Job job, long delay) {
        Object partListener;
        IJobChangeListener paneListener = this.getPane().getJobChangeListener();
        if (paneListener != null) {
            job.addJobChangeListener(paneListener);
        }
        IWorkbenchPart iWorkbenchPart = this.getPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.runtime.jobs.IJobChangeListener;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((partListener = iWorkbenchPart.getAdapter(clazz)) != null) {
            job.addJobChangeListener((IJobChangeListener)partListener);
        }
        job.schedule(delay);
    }

    public IWorkbenchPartSiteCommandSupport getWorkbenchPartSiteCommandSupport() {
        return this.workbenchPartSiteCommandSupport;
    }

    public IWorkbenchPartSiteContextSupport getWorkbenchPartSiteContextSupport() {
        return this.workbenchPartSiteContextSupport;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.commands.IWorkbenchPartSiteCommandSupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getWorkbenchPartSiteCommandSupport();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Lorg.eclipse.ui.contexts.IWorkbenchPartSiteContextSupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getWorkbenchPartSiteContextSupport();
        }
        return null;
    }
}

