/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.WorkbenchPage;

public abstract class PartSashContainer
extends LayoutPart
implements ILayoutContainer {
    protected Composite parent;
    protected ControlListener resizeListener;
    protected LayoutTree root;
    protected LayoutTree unzoomRoot;
    protected Listener mouseDownListener;
    boolean active = false;
    protected ArrayList children = new ArrayList();

    public PartSashContainer(String id, final WorkbenchPage page) {
        super(id);
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PartSashContainer.this.resizeSashes(PartSashContainer.this.parent.getClientArea());
            }
        };
        this.mouseDownListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 3) {
                    page.toggleFastView(null);
                }
            }
        };
    }

    public void findSashes(LayoutPart pane, PartPane.Sashes sashes) {
        LayoutTree part = this.root.find(pane);
        if (part == null) {
            return;
        }
        part.findSashes(sashes);
    }

    public void add(LayoutPart child) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (child == null) {
            return;
        }
        RelationshipInfo info = new RelationshipInfo();
        info.part = child;
        if (this.root != null) {
            this.findPosition(info);
        }
        this.addChild(info);
    }

    public void add(LayoutPart child, int relationship, float ratio, LayoutPart relative) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (child == null) {
            return;
        }
        if (relative != null && !this.isChild(relative)) {
            return;
        }
        if (relationship < 1 || relationship > 4) {
            relationship = 1;
        }
        RelationshipInfo info = new RelationshipInfo();
        info.part = child;
        info.relationship = relationship;
        info.ratio = ratio;
        info.relative = relative;
        this.addChild(info);
    }

    private void addChild(RelationshipInfo info) {
        LayoutPart child = info.part;
        this.children.add(child);
        if (this.root == null) {
            this.root = new LayoutTree(child);
        } else {
            int vertical = info.relationship == 1 || info.relationship == 2 ? 512 : 256;
            boolean left = info.relationship == 1 || info.relationship == 3;
            LayoutPartSash sash = new LayoutPartSash(this, vertical);
            sash.setRatio(info.ratio);
            if (this.parent != null && !(child instanceof PartPlaceholder)) {
                sash.createControl(this.parent);
            }
            this.root = this.root.insert(child, left, sash, info.relative);
        }
        this.childAdded(child);
        if (this.active) {
            child.createControl(this.parent);
            child.setVisible(true);
            child.setContainer(this);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    public boolean allowsBorder() {
        return true;
    }

    protected abstract void childAdded(LayoutPart var1);

    protected abstract void childRemoved(LayoutPart var1);

    public RelationshipInfo[] computeRelation() {
        LayoutTree treeRoot = this.root;
        if (this.isZoomed()) {
            treeRoot = this.unzoomRoot;
        }
        ArrayList<RelationshipInfo> list = new ArrayList<RelationshipInfo>();
        if (treeRoot == null) {
            return new RelationshipInfo[0];
        }
        RelationshipInfo r = new RelationshipInfo();
        r.part = treeRoot.computeRelation(list);
        list.add(0, r);
        RelationshipInfo[] result = new RelationshipInfo[list.size()];
        list.toArray(result);
        return result;
    }

    public void createControl(Composite parentWidget) {
        if (this.active) {
            return;
        }
        this.parent = this.createParent(parentWidget);
        this.parent.addControlListener(this.resizeListener);
        ArrayList children = (ArrayList)this.children.clone();
        int i = 0;
        int length = children.size();
        while (i < length) {
            LayoutPart child = (LayoutPart)children.get(i);
            child.setContainer(this);
            child.createControl(this.parent);
            ++i;
        }
        this.root.updateSashes(this.parent);
        this.active = true;
        this.resizeSashes(this.parent.getClientArea());
    }

    protected abstract Composite createParent(Composite var1);

    public void dispose() {
        if (!this.active) {
            return;
        }
        if (this.resizeListener != null && this.parent != null) {
            this.parent.removeControlListener(this.resizeListener);
        }
        this.resizeSashes(new Rectangle(-200, -200, 0, 0));
        if (this.children != null) {
            int i = 0;
            int length = this.children.size();
            while (i < length) {
                LayoutPart child = (LayoutPart)this.children.get(i);
                child.setContainer(null);
                if (child instanceof PartTabFolder) {
                    child.dispose();
                }
                ++i;
            }
        }
        this.disposeParent();
        this.parent = null;
        this.active = false;
    }

    protected abstract void disposeParent();

    public void disposeSashes() {
        this.root.disposeSashes();
    }

    public LayoutPart findBottomRight() {
        if (this.root == null) {
            return null;
        }
        return this.root.findBottomRight();
    }

    private void findPosition(RelationshipInfo info) {
        info.ratio = 0.5f;
        info.relationship = 2;
        info.relative = this.root.findBottomRight();
        if (this.parent == null) {
            return;
        }
        if ((float)this.getBounds().width / (float)info.relative.getBounds().width > 2.0f || (float)this.getBounds().height / (float)info.relative.getBounds().height > 4.0f) {
            info.relative = null;
            info.ratio = 0.75f;
        }
    }

    public Rectangle getBounds() {
        return this.parent.getBounds();
    }

    public int getMinimumHeight() {
        return this.getLayoutTree().getMinimumHeight();
    }

    public int getMinimumWidth() {
        return this.getLayoutTree().getMinimumWidth();
    }

    public LayoutPart[] getChildren() {
        LayoutPart[] result = new LayoutPart[this.children.size()];
        this.children.toArray(result);
        return result;
    }

    public Control getControl() {
        return this.parent;
    }

    public LayoutTree getLayoutTree() {
        return this.root;
    }

    protected Listener getMouseDownListener() {
        return this.mouseDownListener;
    }

    public Composite getParent() {
        return this.parent;
    }

    private boolean isChild(LayoutPart part) {
        return this.children.indexOf(part) >= 0;
    }

    private boolean isRelationshipCompatible(int relationship, boolean isVertical) {
        if (isVertical) {
            return relationship == 2 || relationship == 1;
        }
        return relationship == 3 || relationship == 4;
    }

    public boolean isZoomed() {
        return this.unzoomRoot != null;
    }

    public void move(LayoutPart child, int relationship, LayoutPart relative) {
        LayoutTree childTree = this.root.find(child);
        LayoutTree relativeTree = this.root.find(relative);
        LayoutTreeNode commonParent = relativeTree.getParent().findCommonParent(child, relative);
        boolean isVertical = commonParent.getSash().isVertical();
        boolean recomputeRatio = false;
        recomputeRatio = this.isRelationshipCompatible(relationship, isVertical) && commonParent.sameDirection(isVertical, relativeTree.getParent()) && commonParent.sameDirection(isVertical, childTree.getParent());
        this.root = this.root.remove(child);
        int vertical = relationship == 1 || relationship == 2 ? 512 : 256;
        boolean left = relationship == 1 || relationship == 3;
        LayoutPartSash sash = new LayoutPartSash(this, vertical);
        sash.setRatio(0.5f);
        if (this.parent != null && !(child instanceof PartPlaceholder)) {
            sash.createControl(this.parent);
        }
        this.root = this.root.insert(child, left, sash, relative);
        this.root.updateSashes(this.parent);
        if (recomputeRatio) {
            this.root.recomputeRatio();
        }
        this.resizeSashes(this.parent.getClientArea());
    }

    public void remove(LayoutPart child) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (!this.isChild(child)) {
            return;
        }
        this.children.remove(child);
        this.root = this.root.remove(child);
        if (this.root != null) {
            this.root.updateSashes(this.parent);
        }
        this.childRemoved(child);
        if (this.active) {
            child.setVisible(false);
            child.setContainer(null);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (!this.isChild(oldChild)) {
            return;
        }
        this.children.remove(oldChild);
        this.children.add(newChild);
        this.childAdded(newChild);
        LayoutTree leaf = this.root.find(oldChild);
        leaf.setPart(newChild);
        this.root.updateSashes(this.parent);
        this.childRemoved(oldChild);
        if (this.active) {
            oldChild.setVisible(false);
            oldChild.setContainer(null);
            newChild.createControl(this.parent);
            newChild.setContainer(this);
            newChild.setVisible(true);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    private void resizeSashes(Rectangle parentSize) {
        if (!this.active) {
            return;
        }
        this.root.setBounds(parentSize);
    }

    public void setBounds(Rectangle r) {
        this.parent.setBounds(r);
    }

    public void zoomIn(LayoutPart part) {
        if (this.unzoomRoot != null) {
            return;
        }
        Rectangle oldBounds = this.root.getBounds();
        this.root.setBounds(new Rectangle(0, 0, 0, 0));
        this.unzoomRoot = this.root;
        this.root = new LayoutTree(part);
        this.root.setBounds(oldBounds);
    }

    public void zoomOut() {
        if (this.unzoomRoot == null) {
            return;
        }
        Rectangle oldBounds = this.root.getBounds();
        this.root.setBounds(new Rectangle(0, 0, 0, 0));
        this.root = this.unzoomRoot;
        this.root.setBounds(oldBounds);
        this.unzoomRoot = null;
    }

    protected static class RelationshipInfo {
        protected LayoutPart part;
        protected LayoutPart relative;
        protected int relationship;
        protected float ratio;

        protected RelationshipInfo() {
        }
    }
}

