/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IPartDropTarget;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;

public abstract class LayoutPart
implements IPartDropTarget {
    protected ILayoutContainer container;
    protected String id;
    private Boolean visible;
    private ListenerList propertyListeners = new ListenerList(1);
    public static final String PROP_VISIBILITY = "PROP_VISIBILITY";

    public LayoutPart(String id) {
        this.id = id;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    public abstract void createControl(Composite var1);

    public void dispose() {
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public RootLayoutContainer getRootContainer() {
        if (this.container != null) {
            return this.container.getRootContainer();
        }
        return null;
    }

    public ILayoutContainer getContainer() {
        return this.container;
    }

    public abstract Control getControl();

    public String getID() {
        return this.id;
    }

    private IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    boolean getShellActivated() {
        Window window = this.getWindow();
        if (window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)window).getShellActivated();
        }
        return false;
    }

    public Point getSize() {
        Rectangle r = this.getBounds();
        Point ptSize = new Point(r.width, r.height);
        return ptSize;
    }

    public int getMinimumWidth() {
        return 0;
    }

    public int getMinimumHeight() {
        return 0;
    }

    public Window getWindow() {
        Object data;
        Control ctrl = this.getControl();
        if (ctrl != null && (data = ctrl.getShell().getData()) instanceof Window) {
            return (Window)data;
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        Window parentWindow = this.getWindow();
        if (parentWindow instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)parentWindow;
        }
        if (parentWindow instanceof DetachedWindow) {
            return ((DetachedWindow)parentWindow).getWorkbenchPage().getWorkbenchWindow();
        }
        return null;
    }

    public boolean isDragAllowed(Point p) {
        return true;
    }

    public void moveAbove(Control refControl) {
    }

    public void reparent(Composite newParent) {
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        if (control.isReparentable()) {
            control.setBounds(0, 0, 0, 0);
            boolean enabled = control.getEnabled();
            control.setEnabled(false);
            control.setParent(newParent);
            control.setEnabled(enabled);
        }
    }

    public boolean isVisible() {
        Control ctrl = this.getControl();
        if (ctrl != null) {
            return this.visible == Boolean.TRUE;
        }
        return false;
    }

    public void setVisible(boolean makeVisible) {
        Control ctrl = this.getControl();
        if (ctrl != null) {
            if (this.visible != null && makeVisible == this.visible) {
                return;
            }
            this.visible = makeVisible ? Boolean.TRUE : Boolean.FALSE;
            ctrl.setVisible(makeVisible);
            Object[] listeners = this.propertyListeners.getListeners();
            if (listeners.length > 0) {
                Boolean oldValue = makeVisible ? Boolean.FALSE : Boolean.TRUE;
                PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROP_VISIBILITY, (Object)oldValue, (Object)this.visible);
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
            }
        }
    }

    public void setBounds(Rectangle r) {
        Control ctrl = this.getControl();
        if (ctrl != null) {
            ctrl.setBounds(r);
        }
    }

    public void setContainer(ILayoutContainer container) {
        this.container = container;
    }

    public void setFocus() {
    }

    public void setID(String str) {
        this.id = str;
    }

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return null;
    }
}

