/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.DropDownEditorWorkbook2;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.TabbedEditorWorkbook;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchPartReference;

public abstract class EditorWorkbook
extends LayoutPart
implements ILayoutContainer,
IPropertyListener {
    private static final int INACTIVE = 0;
    private static final int ACTIVE_FOCUS = 1;
    private static final int ACTIVE_NOFOCUS = 2;
    private EditorArea editorArea;
    private List editors = new ArrayList();
    private EditorPane visibleEditor;
    private Composite parent;
    private int activeState = 0;
    private boolean isZoomed = false;
    private Map mapPartToDragMonitor = new HashMap();

    public static boolean usingNewDropDown() {
        List<String> args = Arrays.asList(Platform.getCommandLineArgs());
        return args.contains("-newDropdown");
    }

    public static EditorWorkbook newEditorWorkbook(EditorArea editorArea) {
        if (EditorWorkbook.usingNewDropDown()) {
            return new DropDownEditorWorkbook2(editorArea);
        }
        return new TabbedEditorWorkbook(editorArea);
    }

    protected EditorWorkbook(EditorArea editorArea) {
        super("editor workbook");
        this.editorArea = editorArea;
        this.setID(this.toString());
    }

    public void add(LayoutPart part) {
        if (part instanceof EditorPane) {
            EditorPane editorPane = (EditorPane)part;
            this.editors.add(editorPane);
            editorPane.setWorkbook(this);
            editorPane.setZoomed(this.isZoomed);
            if (this.getControl() != null) {
                this.createItem(editorPane);
                this.createPage(editorPane);
                this.setVisibleEditor(editorPane);
            }
        }
    }

    public boolean allowsBorder() {
        return false;
    }

    public void becomeActiveWorkbook(boolean hasFocus) {
        EditorArea area = this.getEditorArea();
        if (area != null) {
            area.setActiveWorkbook(this, hasFocus);
        }
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null) {
            return;
        }
        this.parent = parent;
        this.createPresentation(parent);
        this.enableDrop(this);
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            EditorPane pane = (EditorPane)iterator.next();
            this.createItem(pane);
            this.createPage(pane);
        }
        if (this.visibleEditor != null) {
            this.setVisibleEditor(this.visibleEditor);
        } else if (this.getItemCount() > 0) {
            this.setVisibleEditor((EditorPane)this.editors.get(0));
        }
    }

    protected abstract void createPresentation(Composite var1);

    public abstract void showPaneMenu();

    private void createPage(EditorPane editorPane) {
        editorPane.createControl(this.parent);
        editorPane.setContainer(this);
        this.enableDrop(editorPane);
        IEditorReference editorRef = editorPane.getEditorReference();
        this.updateEditorTab(editorRef);
        editorRef.addPropertyListener(this);
        this.checkEnableDrag();
    }

    protected abstract void checkEnableDrag();

    protected abstract Object createItem(EditorPane var1);

    public void dispose() {
        if (this.getControl() == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.size()) {
            this.removeListeners((EditorPane)this.editors.get(i));
            ++i;
        }
        this.editors.clear();
        this.setVisibleEditor(null);
        this.disposePresentation();
    }

    protected abstract void disposePresentation();

    protected void doZoom() {
        if (this.visibleEditor == null) {
            return;
        }
        this.visibleEditor.getPage().toggleZoom(this.visibleEditor.getPartReference());
    }

    public void drawGradient() {
        int[] bgPercents;
        Color[] bgColors;
        Color fgColor;
        switch (this.activeState) {
            case 1: {
                if (this.getShellActivated()) {
                    fgColor = WorkbenchColors.getSystemColor(30);
                    bgColors = WorkbenchColors.getActiveEditorGradient();
                    bgPercents = WorkbenchColors.getActiveEditorGradientPercents();
                    break;
                }
                fgColor = WorkbenchColors.getSystemColor(33);
                bgColors = WorkbenchColors.getDeactivatedEditorGradient();
                bgPercents = WorkbenchColors.getDeactivatedEditorGradientPercents();
                break;
            }
            case 2: {
                fgColor = WorkbenchColors.getSystemColor(24);
                bgColors = WorkbenchColors.getActiveNoFocusEditorGradient();
                bgPercents = WorkbenchColors.getActiveNoFocusEditorGradientPercents();
                break;
            }
            default: {
                fgColor = null;
                bgColors = null;
                bgPercents = null;
            }
        }
        this.drawGradient(fgColor, bgColors, bgPercents);
    }

    protected abstract void drawGradient(Color var1, Color[] var2, int[] var3);

    private void enableDrop(LayoutPart part) {
        Control control = part.getControl();
        if (control != null) {
            control.setData((Object)this);
        }
    }

    public Rectangle getBounds() {
        if (this.getControl() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getControl().getBounds();
    }

    public LayoutPart[] getChildren() {
        int nSize = this.editors.size();
        LayoutPart[] children = new LayoutPart[nSize];
        this.editors.toArray(children);
        return children;
    }

    public abstract Control getControl();

    public EditorArea getEditorArea() {
        return this.editorArea;
    }

    public int getItemCount() {
        return this.editors.size();
    }

    public Composite getParent() {
        return this.parent;
    }

    public abstract Control[] getTabList();

    public abstract void showVisibleEditor();

    public EditorPane getVisibleEditor() {
        return this.visibleEditor;
    }

    public boolean isActiveWorkbook() {
        return this.getEditorArea().isActiveWorkbook(this);
    }

    public boolean isDragAllowed(Point p) {
        if (this.isZoomed) {
            return false;
        }
        if (this.getEditorArea().getEditorWorkbookCount() == 1) {
            return false;
        }
        return this.visibleEditor != null && !this.isDragAllowed(this.visibleEditor, p);
    }

    public abstract boolean isDragAllowed(EditorPane var1, Point var2);

    public void openTracker(LayoutPart part) {
        PartDragDrop dnd = this.getDragSource(part);
        if (dnd != null) {
            dnd.openTracker();
        }
    }

    public void propertyChanged(Object source, int property) {
        if ((property == 257 || property == 1) && source instanceof IEditorPart) {
            this.updateEditorTab((IEditorPart)source);
        }
    }

    public void remove(LayoutPart child) {
        if (!(child instanceof EditorPane)) {
            return;
        }
        EditorPane editorPane = (EditorPane)child;
        int index = this.editors.indexOf(editorPane);
        if (index == -1) {
            return;
        }
        this.editors.remove(editorPane);
        this.removeListeners(editorPane);
        if (this.visibleEditor == editorPane) {
            EditorPane nextEditor = null;
            int maxIndex = this.editors.size() - 1;
            if (maxIndex >= 0) {
                index = Math.min(index, maxIndex);
                nextEditor = (EditorPane)this.editors.get(index);
            }
            if (this.getControl() != null) {
                this.disposeItem(editorPane);
                editorPane.setContainer(null);
            }
            this.setVisibleEditor(nextEditor);
        } else if (this.getControl() != null) {
            this.disposeItem(editorPane);
            editorPane.setContainer(null);
        }
    }

    protected abstract void disposeItem(EditorPane var1);

    public void removeAll() {
        EditorPane child;
        this.setVisibleEditor(null);
        Iterator i = this.editors.iterator();
        while (i.hasNext()) {
            child = (EditorPane)i.next();
            this.removeListeners(child);
        }
        if (this.getControl() != null) {
            this.disposeAllItems();
        }
        i = this.editors.iterator();
        while (i.hasNext()) {
            child = (EditorPane)i.next();
            child.setContainer(null);
        }
        this.editors.clear();
    }

    protected abstract void disposeAllItems();

    private void removeListeners(EditorPane editor) {
        if (editor == null) {
            return;
        }
        this.disableDrag(editor);
        this.checkEnableDrag();
        editor.getPartReference().removePropertyListener(this);
    }

    public abstract void reorderTab(EditorPane var1, int var2, int var3);

    public abstract void reorderTab(EditorPane var1, int var2);

    public void replace(LayoutPart oldPart, LayoutPart newPart) {
    }

    private void setActiveState(int state) {
        if (this.activeState != state) {
            this.activeState = state;
            this.drawGradient();
        }
    }

    public void setBounds(Rectangle r) {
        if (this.getControl() != null) {
            this.getControl().setBounds(r);
            this.setControlSize();
        }
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
    }

    protected abstract void setControlSize();

    public void setVisibleEditor(EditorPane comp) {
        IWorkbenchPart part;
        if (this.getControl() == null) {
            this.visibleEditor = comp;
            return;
        }
        if (comp != null && (part = comp.getPartReference().getPart(true)) == null) {
            comp = null;
        }
        if (this.visibleEditor != null && this.visibleEditor != comp) {
            this.visibleEditor.setVisible(false);
        }
        this.visibleEditor = comp;
        if (this.visibleEditor != null) {
            this.setVisibleItem(this.visibleEditor);
            this.setControlSize();
            if (this.visibleEditor != null) {
                this.visibleEditor.setVisible(true);
            }
            this.becomeActiveWorkbook(this.activeState == 1);
        }
    }

    protected abstract void setVisibleItem(EditorPane var1);

    public void tabFocusHide() {
        if (this.getControl() == null) {
            return;
        }
        if (this.isActiveWorkbook()) {
            this.setActiveState(2);
        } else {
            this.setActiveState(0);
        }
    }

    public void tabFocusShow(boolean hasFocus) {
        if (this.getControl() == null) {
            return;
        }
        if (hasFocus) {
            this.setActiveState(1);
        } else {
            this.setActiveState(2);
        }
    }

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        if (dragSource instanceof EditorPane || dragSource instanceof EditorWorkbook) {
            return this;
        }
        return this.getEditorArea();
    }

    public void updateEditorTab(IEditorPart part) {
        EditorPane pane = (EditorPane)((EditorSite)part.getSite()).getPane();
        this.updateItem(pane);
    }

    public void updateEditorTab(IEditorReference ref) {
        EditorPane pane = (EditorPane)((WorkbenchPartReference)((Object)ref)).getPane();
        this.updateItem(pane);
    }

    protected abstract void updateItem(EditorPane var1);

    public void zoomIn() {
        if (this.isZoomed) {
            return;
        }
        this.isZoomed = true;
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            ((EditorPane)iterator.next()).setZoomed(true);
        }
    }

    public void zoomOut() {
        if (!this.isZoomed) {
            return;
        }
        this.isZoomed = false;
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            ((EditorPane)iterator.next()).setZoomed(false);
        }
    }

    public EditorPane[] getEditors() {
        EditorPane[] children = new EditorPane[this.editors.size()];
        this.editors.toArray(children);
        return children;
    }

    protected List getEditorList() {
        return this.editors;
    }

    protected void enableDrag(LayoutPart part) {
        PartDragDrop dragSource = this.createDragSource(part);
        if (dragSource != null) {
            this.mapPartToDragMonitor.put(part, dragSource);
            dragSource.addDropListener(this.getEditorArea().getPartDropListener());
        }
    }

    protected abstract PartDragDrop createDragSource(LayoutPart var1);

    protected void disableDrag(LayoutPart part) {
        PartDragDrop partDragDrop = (PartDragDrop)this.mapPartToDragMonitor.get(part);
        if (partDragDrop != null) {
            partDragDrop.dispose();
            this.mapPartToDragMonitor.remove(part);
        }
    }

    protected PartDragDrop getDragSource(LayoutPart part) {
        return (PartDragDrop)this.mapPartToDragMonitor.get(part);
    }
}

