/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.EditorsInformationControl;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.WorkbenchImages;

public class DropDownEditorWorkbook2
extends EditorWorkbook {
    private ViewForm viewForm;
    private Composite topLeftComposite;
    private ToolBar closeBar;
    private ViewForm labelComposite;
    private CLabel label;
    private Composite dummy;

    public DropDownEditorWorkbook2(EditorArea editorArea) {
        super(editorArea);
    }

    protected void createPresentation(Composite parent) {
        this.viewForm = new ViewForm(parent, 2048);
        this.topLeftComposite = new Composite((Composite)this.viewForm, 0);
        this.labelComposite = new ViewForm(this.topLeftComposite, 0x800800);
        this.label = new CLabel((Composite)this.labelComposite, 0);
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                DropDownEditorWorkbook2.this.dropDown();
            }
        };
        this.label.addListener(3, labelListener);
        ToolBar arrowBar = new ToolBar((Composite)this.labelComposite, 0x800000);
        ToolItem arrowItem = new ToolItem(arrowBar, 0);
        arrowItem.setImage(WorkbenchImages.getImage("IMG_LCL_VIEW_MENU"));
        Listener arrowListener = new Listener(){

            public void handleEvent(Event event) {
                DropDownEditorWorkbook2.this.dropDown();
            }
        };
        arrowBar.addListener(3, arrowListener);
        this.labelComposite.setTopLeft((Control)this.label);
        this.labelComposite.setTopRight((Control)arrowBar);
        this.closeBar = new ToolBar((Composite)this.viewForm, 0x800000);
        ToolItem closeItem = new ToolItem(this.closeBar, 0);
        closeItem.setImage(WorkbenchImages.getImage("IMG_LCL_CLOSE_VIEW"));
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                EditorPane visibleEditor = DropDownEditorWorkbook2.this.getVisibleEditor();
                if (visibleEditor != null) {
                    visibleEditor.doHide();
                }
            }
        };
        closeItem.addListener(13, closeListener);
        this.dummy = new Composite((Composite)this.viewForm, 0);
        this.dummy.setVisible(false);
        this.viewForm.setContent((Control)this.dummy);
        FormLayout layout = new FormLayout();
        this.topLeftComposite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, -1);
        formData.left = new FormAttachment(33);
        formData.bottom = new FormAttachment(100, 1);
        formData.right = new FormAttachment(67);
        this.labelComposite.setLayoutData((Object)formData);
    }

    protected void setControlSize() {
        EditorPane visibleEditor = this.getVisibleEditor();
        if (visibleEditor == null || this.getControl() == null) {
            return;
        }
        Rectangle bounds = this.viewForm.getBounds();
        Rectangle offset = this.dummy.getBounds();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        visibleEditor.setBounds(bounds);
        visibleEditor.moveAbove((Control)this.viewForm);
    }

    public void showPaneMenu() {
        EditorPane visibleEditor = this.getVisibleEditor();
        if (visibleEditor != null) {
            Point location = this.label.toDisplay(0, this.label.getSize().y);
            visibleEditor.showPaneMenu((Control)this.viewForm, location);
        }
    }

    public boolean isDragAllowed(EditorPane pane, Point p) {
        return false;
    }

    protected void checkEnableDrag() {
    }

    protected void disposePresentation() {
        this.viewForm.dispose();
        this.viewForm = null;
        this.topLeftComposite = null;
        this.label = null;
    }

    protected void drawGradient(Color fgColor, Color[] bgColors, int[] bgPercents) {
        this.label.setForeground(fgColor);
        this.label.setBackground(bgColors, bgPercents);
    }

    public int getMinimumHeight() {
        return super.getMinimumHeight();
    }

    public Control getControl() {
        return this.viewForm;
    }

    public Control[] getTabList() {
        return new Control[0];
    }

    public void showVisibleEditor() {
    }

    public void openTracker(LayoutPart part) {
    }

    protected Object createItem(EditorPane editorPane) {
        if (this.getEditorList().size() >= 1 && this.viewForm.getTopLeft() == null) {
            this.viewForm.setTopLeft((Control)this.topLeftComposite);
            this.viewForm.setTopRight((Control)this.closeBar);
            this.viewForm.redraw();
        }
        return null;
    }

    protected void disposeItem(EditorPane editorPane) {
        if (editorPane == this.getVisibleEditor()) {
            this.label.setText("");
            this.label.setImage(null);
            this.label.setToolTipText(null);
        }
        if (this.getEditorList().size() == 0 && this.viewForm.getTopLeft() != null) {
            this.viewForm.setTopLeft(null);
            this.viewForm.setTopRight(null);
            this.viewForm.redraw();
        }
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
    }

    protected void setVisibleItem(EditorPane editorPane) {
        if (this.label != null) {
            IEditorReference ref = editorPane.getEditorReference();
            this.label.setText(ref.getTitle());
            this.label.setImage(ref.getTitleImage());
            this.label.setToolTipText(ref.getTitleToolTip());
        }
    }

    protected void updateItem(EditorPane editorPane) {
        if (this.getVisibleEditor() == editorPane && this.label != null) {
            IEditorReference ref = editorPane.getEditorReference();
            String title = ref.getTitle();
            if (ref.isDirty()) {
                title = "*" + title;
            }
            this.label.setText(title);
            Image image = ref.getTitleImage();
            if (image == null || image.isDisposed()) {
                this.label.setImage(null);
            } else {
                this.label.setImage(image);
            }
            this.label.setToolTipText(ref.getTitleToolTip());
        }
    }

    protected void disposeAllItems() {
        this.label.setText("");
        this.label.setImage(null);
        this.label.setToolTipText(null);
        this.viewForm.setTopLeft(null);
        this.viewForm.setTopRight(null);
        this.viewForm.redraw();
    }

    protected PartDragDrop createDragSource(LayoutPart part) {
        return null;
    }

    public void reorderTab(EditorPane pane, int x, int y) {
    }

    public void reorderTab(EditorPane pane, int newIndex) {
    }

    public void dropDown() {
        int shellStyle = 16;
        int tableStyle = 768;
        final EditorsInformationControl info = new EditorsInformationControl(this.viewForm.getShell(), shellStyle, tableStyle);
        info.setInput(this);
        Point size = info.computeSizeHint();
        int minX = this.labelComposite.getSize().x;
        int minY = 300;
        if (size.x < minX) {
            size.x = minX;
        }
        if (size.y < minY) {
            size.y = minY;
        }
        info.setSize(size.x, size.y);
        info.setLocation(this.label.toDisplay(1, this.label.getSize().y + 3));
        info.setVisible(true);
        info.setFocus();
        info.getTableViewer().getTable().getShell().addListener(27, new Listener(){

            public void handleEvent(Event event) {
                info.setVisible(false);
            }
        });
    }
}

