/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchPlugin;

class ActivityPersistanceHelper {
    private static String PREFIX = "UIRoles.";
    private static ActivityPersistanceHelper singleton;
    static /* synthetic */ Class class$0;

    public static ActivityPersistanceHelper getInstance() {
        if (singleton == null) {
            singleton = new ActivityPersistanceHelper();
        }
        return singleton;
    }

    private ActivityPersistanceHelper() {
        IWorkbenchActivitySupport support;
        this.loadEnabledStates();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return;
        }
        boolean noRoles = support.getActivityManager().getDefinedCategoryIds().isEmpty();
        if (noRoles) {
            IActivityManager activityManager = support.getActivityManager();
            support.setEnabledActivityIds(activityManager.getDefinedActivityIds());
        }
    }

    private String createPreferenceKey(IActivity activity) {
        return String.valueOf(PREFIX) + activity.getId();
    }

    void loadEnabledStates() {
        IWorkbenchActivitySupport support;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return;
        }
        IActivityManager activityManager = support.getActivityManager();
        Iterator values = activityManager.getDefinedActivityIds().iterator();
        HashSet<String> enabledActivities = new HashSet<String>();
        while (values.hasNext()) {
            IActivity activity = activityManager.getActivity((String)values.next());
            if (!store.getBoolean(this.createPreferenceKey(activity))) continue;
            enabledActivities.add(activity.getId());
        }
        support.setEnabledActivityIds(enabledActivities);
    }

    private void saveEnabledStates() {
        IWorkbenchActivitySupport support;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return;
        }
        IActivityManager activityManager = support.getActivityManager();
        Iterator values = activityManager.getDefinedActivityIds().iterator();
        while (values.hasNext()) {
            IActivity activity = activityManager.getActivity((String)values.next());
            store.setValue(this.createPreferenceKey(activity), activity.isEnabled());
        }
    }

    public void shutdown() {
        this.saveEnabledStates();
    }
}

