/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.ViewPluginAction;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WWinPluginPulldown;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActionDescriptor {
    private PluginAction action;
    private String toolbarId;
    private String menuPath;
    private String id;
    private String menuGroup;
    private String toolbarGroupId;
    public static final int T_POPUP = 1;
    public static final int T_VIEW = 2;
    public static final int T_WORKBENCH = 3;
    public static final int T_EDITOR = 4;
    public static final int T_WORKBENCH_PULLDOWN = 5;
    public static final String ATT_ID = "id";
    public static final String ATT_DEFINITION_ID = "definitionId";
    public static final String ATT_HELP_CONTEXT_ID = "helpContextId";
    public static final String ATT_LABEL = "label";
    public static final String ATT_STYLE = "style";
    public static final String ATT_STATE = "state";
    public static final String ATT_DESCRIPTION = "description";
    public static final String ATT_TOOLTIP = "tooltip";
    public static final String ATT_MENUBAR_PATH = "menubarPath";
    public static final String ATT_TOOLBAR_PATH = "toolbarPath";
    public static final String ATT_ICON = "icon";
    public static final String ATT_HOVERICON = "hoverIcon";
    public static final String ATT_DISABLEDICON = "disabledIcon";
    public static final String ATT_CLASS = "class";
    public static final String ATT_RETARGET = "retarget";
    public static final String ATT_ALLOW_LABEL_UPDATE = "allowLabelUpdate";
    public static final String ATT_ACCELERATOR = "accelerator";
    public static final String STYLE_PUSH = "push";
    public static final String STYLE_RADIO = "radio";
    public static final String STYLE_TOGGLE = "toggle";
    public static final String STYLE_PULLDOWN = "pulldown";

    public ActionDescriptor(IConfigurationElement actionElement, int targetType) {
        this(actionElement, targetType, null);
    }

    public ActionDescriptor(IConfigurationElement actionElement, int targetType, Object target) {
        String state;
        int loc;
        this.id = actionElement.getAttribute(ATT_ID);
        String label = actionElement.getAttribute(ATT_LABEL);
        String defId = actionElement.getAttribute(ATT_DEFINITION_ID);
        String tooltip = actionElement.getAttribute(ATT_TOOLTIP);
        String helpContextId = actionElement.getAttribute(ATT_HELP_CONTEXT_ID);
        String mpath = actionElement.getAttribute(ATT_MENUBAR_PATH);
        String tpath = actionElement.getAttribute(ATT_TOOLBAR_PATH);
        String style = actionElement.getAttribute(ATT_STYLE);
        String icon = actionElement.getAttribute(ATT_ICON);
        String hoverIcon = actionElement.getAttribute(ATT_HOVERICON);
        String disabledIcon = actionElement.getAttribute(ATT_DISABLEDICON);
        String description = actionElement.getAttribute(ATT_DESCRIPTION);
        String accelerator = actionElement.getAttribute(ATT_ACCELERATOR);
        if (label == null) {
            WorkbenchPlugin.log("Invalid action declaration (label == null): " + this.id);
            label = WorkbenchMessages.getString("ActionDescriptor.invalidLabel");
        }
        String mgroup = null;
        String tgroup = null;
        if (mpath != null) {
            loc = mpath.lastIndexOf(47);
            if (loc != -1) {
                mgroup = mpath.substring(loc + 1);
                mpath = mpath.substring(0, loc);
            } else {
                mgroup = mpath;
                mpath = null;
            }
        }
        if (targetType == 1 && mgroup == null) {
            mgroup = "additions";
        }
        if (tpath != null) {
            loc = tpath.lastIndexOf(47);
            if (loc != -1) {
                tgroup = tpath.substring(loc + 1);
                tpath = tpath.substring(0, loc);
            } else {
                tgroup = tpath;
                tpath = null;
            }
        }
        this.menuPath = mpath;
        this.menuGroup = mgroup;
        if (tpath != null && tpath.equals("Normal")) {
            tpath = "";
        }
        this.toolbarId = tpath;
        this.toolbarGroupId = tgroup;
        this.action = this.createAction(targetType, actionElement, target, defId, style);
        if (this.action.getText() == null) {
            this.action.setText(label);
        }
        this.action.setId(this.id);
        if (this.action.getToolTipText() == null && tooltip != null) {
            this.action.setToolTipText(tooltip);
        }
        if (helpContextId != null) {
            String fullID = helpContextId;
            if (helpContextId.indexOf(".") == -1) {
                fullID = String.valueOf(actionElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier()) + "." + helpContextId;
            }
            WorkbenchHelp.setHelp((IAction)this.action, fullID);
        }
        if (description != null) {
            this.action.setDescription(description);
        }
        if (style != null) {
            state = actionElement.getAttribute(ATT_STATE);
            if (state != null && (style.equals(STYLE_RADIO) || style.equals(STYLE_TOGGLE))) {
                this.action.setChecked(state.equals("true"));
            }
        } else {
            state = actionElement.getAttribute(ATT_STATE);
            if (state != null) {
                this.action.setChecked(state.equals("true"));
            }
        }
        IExtension extension = actionElement.getDeclaringExtension();
        String extendingPluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        if (icon != null) {
            this.action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, icon));
        }
        if (hoverIcon != null) {
            this.action.setHoverImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, hoverIcon));
        }
        if (disabledIcon != null) {
            this.action.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, disabledIcon));
        }
        if (accelerator != null) {
            this.processAccelerator((IAction)this.action, accelerator);
        }
    }

    private PluginAction createAction(int targetType, IConfigurationElement actionElement, Object target, String defId, String style) {
        int actionStyle = 0;
        if (style != null) {
            if (style.equals(STYLE_RADIO)) {
                actionStyle = 8;
            } else if (style.equals(STYLE_TOGGLE)) {
                actionStyle = 2;
            } else if (style.equals(STYLE_PULLDOWN)) {
                actionStyle = 4;
            } else if (style.equals(STYLE_PUSH)) {
                actionStyle = 1;
            }
        }
        switch (targetType) {
            case 2: {
                return new ViewPluginAction(actionElement, ATT_CLASS, (IViewPart)target, defId, actionStyle);
            }
            case 4: {
                return new EditorPluginAction(actionElement, ATT_CLASS, (IEditorPart)target, defId, actionStyle);
            }
            case 3: {
                return new WWinPluginAction(actionElement, ATT_CLASS, (IWorkbenchWindow)target, defId, actionStyle);
            }
            case 5: {
                actionStyle = 4;
                return new WWinPluginPulldown(actionElement, ATT_CLASS, (IWorkbenchWindow)target, defId, actionStyle);
            }
            case 1: {
                return new ObjectPluginAction(actionElement, ATT_CLASS, defId, actionStyle);
            }
        }
        WorkbenchPlugin.log("Unknown Action Type: " + targetType);
        return null;
    }

    public PluginAction getAction() {
        return this.action;
    }

    public String getId() {
        return this.id;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public String getToolbarGroupId() {
        return this.toolbarGroupId;
    }

    public String getToolbarId() {
        return this.toolbarId;
    }

    public String toString() {
        return "ActionDescriptor(" + this.id + ")";
    }

    private void processAccelerator(IAction action, String acceleratorText) {
        if (acceleratorText.length() == 0) {
            return;
        }
        if (Character.isDigit(acceleratorText.charAt(0))) {
            try {
                action.setAccelerator(Integer.valueOf(acceleratorText).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                WorkbenchPlugin.log("Invalid accelerator declaration: " + this.id);
            }
        } else {
            action.setAccelerator(Action.convertAccelerator((String)acceleratorText));
        }
    }
}

