/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PropertyDialogAction
extends SelectionProviderAction {
    private Shell shell;
    static /* synthetic */ Class class$0;

    public PropertyDialogAction(Shell shell, ISelectionProvider provider) {
        super(provider, WorkbenchMessages.getString("PropertyDialog.text"));
        Assert.isNotNull((Object)shell);
        this.shell = shell;
        this.setToolTipText(WorkbenchMessages.getString("PropertyDialog.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.property_dialog_action_context");
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
            return adapter.getLabel(element);
        }
        return "";
    }

    private boolean hasPropertyPagesFor(Object object) {
        PropertyPageContributorManager manager = PropertyPageContributorManager.getManager();
        return manager.hasContributorsFor(object);
    }

    public boolean isApplicableForSelection() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.isApplicableForSelection(this.getStructuredSelection());
    }

    public boolean isApplicableForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && this.hasPropertyPagesFor(selection.getFirstElement());
    }

    public void run() {
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        IAdaptable element = (IAdaptable)this.getStructuredSelection().getFirstElement();
        if (element == null) {
            return;
        }
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        Iterator pages = pageManager.getElements(0).iterator();
        String name = this.getName(element);
        if (!pages.hasNext()) {
            MessageDialog.openInformation((Shell)this.shell, (String)WorkbenchMessages.getString("PropertyDialog.messageTitle"), (String)WorkbenchMessages.format("PropertyDialog.noPropertyMessage", new Object[]{name}));
            return;
        }
        title = WorkbenchMessages.format("PropertyDialog.propertyMessage", new Object[]{name});
        PropertyDialog propertyDialog = new PropertyDialog(this.shell, pageManager, (ISelection)this.getStructuredSelection());
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        WorkbenchHelp.setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        propertyDialog.open();
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1 && selection.getFirstElement() != null);
    }
}

