/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.CommandResolver;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.IImageBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.help.WorkbenchHelp;

public class CommandContributionItem
extends ContributionItem
implements ICommandListener {
    private static ImageCache globalImageCache;
    private static boolean useColourIcons;
    private Listener buttonListener;
    private ICommand command;
    private HelpListener helpListener;
    private Listener menuItemListener;
    private Listener toolItemListener;
    private Widget widget = null;

    static {
        useColourIcons = true;
    }

    public static boolean getUseColourIconsInToolbars() {
        return useColourIcons;
    }

    public static String removeAcceleratorText(String text) {
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.substring(0, index);
        }
        return text;
    }

    public static void setUseColourIconsInToolbars(boolean newValue) {
        useColourIcons = newValue;
    }

    public CommandContributionItem(ICommand commandToUse) {
        super(commandToUse.getId());
        this.command = commandToUse;
        this.helpListener = WorkbenchHelp.createHelpListener(commandToUse);
    }

    public void commandChanged(final CommandEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e);
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        CommandContributionItem.this.update(e);
                    }
                });
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommandContributionItem)) {
            return false;
        }
        return this.command.equals(((CommandContributionItem)o).command);
    }

    public void fill(Composite parent) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            Button b = new Button(parent, flags);
            b.setData((Object)this);
            b.addListener(12, this.getButtonListener());
            b.addListener(13, this.getButtonListener());
            b.addHelpListener(this.helpListener);
            this.widget = b;
            this.update();
            this.command.addCommandListener(this);
        }
    }

    public void fill(Menu parent, int index) {
        if (this.widget == null && parent != null) {
            Menu subMenu = null;
            int flags = 8;
            MenuItem mi = null;
            mi = index >= 0 ? new MenuItem(parent, flags, index) : new MenuItem(parent, flags);
            this.widget = mi;
            mi.setData((Object)this);
            mi.addListener(12, this.getMenuItemListener());
            mi.addListener(13, this.getMenuItemListener());
            mi.addHelpListener(this.helpListener);
            if (subMenu != null) {
                mi.setMenu(subMenu);
            }
            this.update();
            this.command.addCommandListener(this);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, this.getToolItemListener());
            ti.addListener(12, this.getToolItemListener());
            this.widget = ti;
            this.update();
            this.command.addCommandListener(this);
        }
    }

    private Listener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            CommandContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            CommandContributionItem.this.handleWidgetSelection(event, ((Button)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.buttonListener;
    }

    public ICommand getCommand() {
        return this.command;
    }

    private ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        if (globalImageCache != null) {
                            globalImageCache.dispose();
                            globalImageCache = null;
                        }
                    }
                });
            }
        }
        return cache;
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            CommandContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            CommandContributionItem.this.handleWidgetSelection(event, ((MenuItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            CommandContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            CommandContributionItem.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            this.command.removeCommandListener(this);
            this.widget = null;
        }
    }

    private void handleWidgetSelection(Event e, boolean selection) {
        Widget item = e.widget;
        if (item != null && this.command.isEnabled()) {
            boolean trace = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/trace/actions"));
            long ms = System.currentTimeMillis();
            try {
                if (trace) {
                    System.out.println("Running command: " + this.command.getName());
                }
                if (trace) {
                    System.out.println(String.valueOf(System.currentTimeMillis() - ms) + " ms to run command: " + this.command.getName());
                }
            }
            catch (NotDefinedException notDefinedException) {
                this.update();
            }
        }
    }

    public int hashCode() {
        return this.command.hashCode();
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean bl = (this.widget.getStyle() & 0x20) != 0;
            boolean bl2 = (this.widget.getStyle() & 0x10) != 0;
            return false;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.command != null && this.command.isEnabled();
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return value == null ? true : value;
    }

    public boolean isVisible() {
        return this.getCommand().isActive();
    }

    public void update() {
        this.update(null);
    }

    public void update(CommandEvent event) {
        if (this.widget != null) {
            ICommand currentCommand = this.getCommand();
            boolean descriptionChanged = true;
            boolean imageChanged = true;
            boolean nameChanged = true;
            boolean enabledChanged = true;
            boolean checkedChanged = true;
            if (event != null) {
                descriptionChanged = event.hasDescriptionChanged();
                imageChanged = event.haveImageBindingsChanged();
                nameChanged = event.hasNameChanged();
                if ((!event.hasDefinedChanged() || currentCommand.isDefined()) && event.hasActiveChanged()) {
                    currentCommand.isActive();
                }
            }
            try {
                if (this.widget instanceof ToolItem) {
                    ToolItem ti = (ToolItem)this.widget;
                    if (imageChanged) {
                        this.updateImages(true);
                    }
                    if (descriptionChanged) {
                        ti.setToolTipText(currentCommand.getDescription());
                    }
                    if (enabledChanged) {
                        boolean shouldBeEnabled;
                        boolean bl = shouldBeEnabled = currentCommand.isEnabled() && this.isEnabledAllowed();
                        if (ti.getEnabled() != shouldBeEnabled) {
                            ti.setEnabled(shouldBeEnabled);
                        }
                    }
                    return;
                }
                if (this.widget instanceof MenuItem) {
                    MenuItem mi = (MenuItem)this.widget;
                    if (nameChanged) {
                        String commandId;
                        Integer accelerator = null;
                        String acceleratorText = null;
                        String name = null;
                        CommandResolver.ICallback callback = CommandResolver.getInstance().getCommandResolver();
                        if (callback != null && (commandId = currentCommand.getId()) != null) {
                            accelerator = callback.getAccelerator(commandId);
                            acceleratorText = callback.getAcceleratorText(commandId);
                        }
                        IContributionManagerOverrides overrides = null;
                        if (this.getParent() != null) {
                            overrides = this.getParent().getOverrides();
                        }
                        if (overrides != null) {
                            name = this.getParent().getOverrides().getText((IContributionItem)this);
                        }
                        mi.setAccelerator(accelerator.intValue());
                        if (name == null) {
                            name = currentCommand.getName();
                        }
                        name = name == null ? "" : CommandContributionItem.removeAcceleratorText(name);
                        if (acceleratorText == null) {
                            mi.setText(name);
                        } else {
                            mi.setText(String.valueOf(name) + '\t' + acceleratorText);
                        }
                    }
                    if (imageChanged) {
                        this.updateImages(false);
                    }
                    if (enabledChanged) {
                        boolean shouldBeEnabled;
                        boolean bl = shouldBeEnabled = currentCommand.isEnabled() && this.isEnabledAllowed();
                        if (mi.getEnabled() != shouldBeEnabled) {
                            mi.setEnabled(shouldBeEnabled);
                        }
                    }
                    return;
                }
                if (this.widget instanceof Button) {
                    String name;
                    Button button = (Button)this.widget;
                    if (imageChanged && this.updateImages(false)) {
                        nameChanged = false;
                    }
                    if (nameChanged && (name = currentCommand.getName()) != null) {
                        button.setText(name);
                    }
                    if (descriptionChanged) {
                        button.setToolTipText(currentCommand.getDescription());
                    }
                    if (enabledChanged) {
                        boolean shouldBeEnabled;
                        boolean bl = shouldBeEnabled = currentCommand.isEnabled() && this.isEnabledAllowed();
                        if (button.getEnabled() != shouldBeEnabled) {
                            button.setEnabled(shouldBeEnabled);
                        }
                    }
                    return;
                }
            }
            catch (NotDefinedException notDefinedException) {}
        }
    }

    private boolean updateImages(boolean forceImage) {
        Image image;
        ImageCache cache = this.getImageCache();
        String normalImageURI = null;
        String disabledImageURI = null;
        String hoverImageURI = null;
        Iterator imageBindingItr = this.getCommand().getImageBindings().iterator();
        while (imageBindingItr.hasNext()) {
            IImageBinding imageBinding = (IImageBinding)imageBindingItr.next();
            String imageStyle = imageBinding.getImageStyle();
            if (imageStyle.equals("normal")) {
                normalImageURI = imageBinding.getImageUri();
                continue;
            }
            if (imageStyle.equals("disabled")) {
                disabledImageURI = imageBinding.getImageUri();
                continue;
            }
            if (!imageStyle.equals("hover")) continue;
            hoverImageURI = imageBinding.getImageUri();
        }
        if (this.widget instanceof ToolItem) {
            if (CommandContributionItem.getUseColourIconsInToolbars()) {
                image = cache.getImage(hoverImageURI);
                if (image == null) {
                    image = cache.getImage(normalImageURI);
                }
                Image disabledImage = cache.getImage(disabledImageURI);
                if (image == null && forceImage) {
                    image = cache.getMissingImage();
                }
                if (disabledImage != null) {
                    ((ToolItem)this.widget).setDisabledImage(disabledImage);
                }
                ((ToolItem)this.widget).setImage(image);
                return image != null;
            }
            image = cache.getImage(normalImageURI);
            Image hoverImage = cache.getImage(hoverImageURI);
            Image disabledImage = cache.getImage(disabledImageURI);
            if (image == null && hoverImage != null) {
                image = cache.getGrayImage(hoverImageURI);
            } else if (hoverImage == null && image != null) {
                hoverImage = image;
                image = cache.getGrayImage(normalImageURI);
            }
            if (hoverImage == null && image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (disabledImage != null) {
                ((ToolItem)this.widget).setDisabledImage(disabledImage);
            }
            ((ToolItem)this.widget).setHotImage(hoverImage);
            ((ToolItem)this.widget).setImage(image);
            return image != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            image = cache.getImage(hoverImageURI);
            if (image == null) {
                image = cache.getImage(normalImageURI);
            }
            if (image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(image);
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(image);
            }
            return image != null;
        }
        return false;
    }

    private static class ImageCache {
        private Map entries = new HashMap(11);
        private Image missingImage;

        ImageCache() {
        }

        void dispose() {
            Iterator i = this.entries.values().iterator();
            while (i.hasNext()) {
                ((Entry)i.next()).dispose();
            }
            this.entries.clear();
        }

        Entry getEntry(ImageDescriptor descriptor) {
            Entry entry = (Entry)this.entries.get(descriptor);
            if (entry == null) {
                entry = new Entry();
                this.entries.put(descriptor, entry);
            }
            return entry;
        }

        Image getGrayImage(String imageURI) {
            if (imageURI == null) {
                return null;
            }
            try {
                Image image;
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL(imageURI));
                Entry entry = this.getEntry(descriptor);
                if (entry.grayImage == null && (image = this.getImage(imageURI)) != null) {
                    entry.grayImage = new Image(null, image, 2);
                }
                return entry.grayImage;
            }
            catch (MalformedURLException malformedURLException) {
                return new Image(null, this.getMissingImage(), 2);
            }
        }

        Image getImage(String imageURI) {
            if (imageURI == null) {
                return null;
            }
            try {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL(imageURI));
                Entry entry = this.getEntry(descriptor);
                if (entry.image == null) {
                    entry.image = descriptor.createImage();
                }
                return entry.image;
            }
            catch (MalformedURLException malformedURLException) {
                return this.getMissingImage();
            }
        }

        Image getMissingImage() {
            if (this.missingImage == null) {
                ImageDescriptor descriptor = ImageDescriptor.getMissingImageDescriptor();
                Entry entry = this.getEntry(descriptor);
                if (entry.image == null) {
                    entry.image = descriptor.createImage();
                }
                this.missingImage = entry.image;
            }
            return this.missingImage;
        }

        private class Entry {
            Image grayImage;
            Image image;

            Entry() {
            }

            void dispose() {
                if (this.image != null) {
                    this.image.dispose();
                    this.image = null;
                }
                if (this.grayImage != null) {
                    this.grayImage.dispose();
                    this.grayImage = null;
                }
            }
        }
    }
}

