/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class WorkbenchAdvisor {
    public static final int FILL_PROXY = 1;
    public static final int FILL_MENU_BAR = 2;
    public static final int FILL_TOOL_BAR = 4;
    public static final int FILL_STATUS_LINE = 8;

    protected WorkbenchAdvisor() {
    }

    public void initialize(IWorkbenchConfigurer configurer) {
    }

    public void preStartup() {
    }

    public void postStartup() {
    }

    public void postRestore() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
    }

    public void eventLoopException(Throwable exception) {
        if (exception == null) {
            return;
        }
        try {
            String msg = exception.getMessage();
            if (msg == null) {
                msg = exception.toString();
            }
            WorkbenchPlugin.log("Unhandled event loop exception", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, exception));
            Throwable nested = null;
            if (exception instanceof SWTException) {
                nested = ((SWTException)exception).throwable;
            } else if (exception instanceof SWTError) {
                nested = ((SWTError)exception).throwable;
            }
            if (nested != null) {
                msg = nested.getMessage();
                if (msg == null) {
                    msg = nested.toString();
                }
                WorkbenchPlugin.log("*** SWT nested exception", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, nested));
            }
            if (WorkbenchPlugin.DEBUG) {
                exception.printStackTrace();
            }
        }
        catch (Throwable e) {
            System.err.println("Error while logging event loop exception:");
            exception.printStackTrace();
            System.err.println("Logging exception:");
            e.printStackTrace();
        }
    }

    public void eventLoopIdle(Display display) {
        display.sleep();
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
        return true;
    }

    public void postWindowClose(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer configurer, String menuId) {
        return false;
    }

    public final IAdaptable getDefaultWindowInput() {
        return null;
    }

    public IAdaptable getDefaultPageInput() {
        return null;
    }

    public abstract String getInitialWindowPerspectiveId();

    public String getMainPreferencePageId() {
        return null;
    }
}

