/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SelectImportsAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetOpenHierarchyOnSelectionAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetOpenOnSelectionAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.StopAction;
import org.eclipse.jdt.internal.ui.javaeditor.BasicEditorActionContributor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;

public class SnippetEditorActionContributor
extends BasicEditorActionContributor {
    protected JavaSnippetEditor fSnippetEditor;
    private StopAction fStopAction;
    private SelectImportsAction fSelectImportsAction;
    private SnippetOpenOnSelectionAction fOpenOnSelectionAction;
    private SnippetOpenHierarchyOnSelectionAction fOpenOnTypeSelectionAction;

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        if (this.fStopAction == null) {
            toolBarManager.add((IContributionItem)new Separator("evaluationGroup"));
            return;
        }
        toolBarManager.add((IAction)this.fStopAction);
        toolBarManager.add((IAction)this.fSelectImportsAction);
        toolBarManager.update(false);
    }

    public void contributeToMenu(IMenuManager menu) {
        if (this.fOpenOnSelectionAction == null) {
            return;
        }
        super.contributeToMenu(menu);
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenOnSelectionAction);
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenOnTypeSelectionAction);
            navigateMenu.setVisible(true);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.fSnippetEditor = null;
        if (part instanceof JavaSnippetEditor) {
            this.fSnippetEditor = (JavaSnippetEditor)part;
            if (this.fOpenOnSelectionAction == null) {
                this.initializeActions();
                this.contributeToMenu(this.getActionBars().getMenuManager());
                this.contributeToToolBar(this.getActionBars().getToolBarManager());
            }
        }
        if (this.fOpenOnSelectionAction != null) {
            this.fStopAction.setEditor(this.fSnippetEditor);
            this.fSelectImportsAction.setEditor(this.fSnippetEditor);
            this.fOpenOnSelectionAction.setEditor(this.fSnippetEditor);
            this.fOpenOnTypeSelectionAction.setEditor(this.fSnippetEditor);
        }
        this.updateStatus(this.fSnippetEditor);
    }

    protected void initializeActions() {
        this.fOpenOnSelectionAction = new SnippetOpenOnSelectionAction(this.fSnippetEditor);
        this.fOpenOnTypeSelectionAction = new SnippetOpenHierarchyOnSelectionAction(this.fSnippetEditor);
        this.fStopAction = new StopAction(this.fSnippetEditor);
        this.fSelectImportsAction = new SelectImportsAction(this.fSnippetEditor);
    }

    protected void updateStatus(JavaSnippetEditor editor) {
        String message = "";
        if (editor != null && editor.isEvaluating()) {
            message = SnippetMessages.getString("SnippetActionContributor.evalMsg");
        }
        this.getActionBars().getStatusLineManager().setMessage(message);
    }
}

