/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.jdt.internal.debug.ui.snippeteditor.ISnippetStateChangedListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;

public abstract class SnippetAction
extends Action
implements ISnippetStateChangedListener {
    private JavaSnippetEditor fEditor;

    public SnippetAction(JavaSnippetEditor editor) {
        this.setEditor(editor);
    }

    public void setEditor(JavaSnippetEditor editor) {
        if (this.fEditor != null) {
            this.fEditor.removeSnippetStateChangedListener(this);
        }
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fEditor.addSnippetStateChangedListener(this);
        }
        this.snippetStateChanged(this.fEditor);
    }

    public void snippetStateChanged(JavaSnippetEditor editor) {
        if (editor != null && !editor.isEvaluating()) {
            this.update();
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean textHasContent(String text) {
        int length = text.length();
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void update() {
        if (this.fEditor != null) {
            ITextSelection selection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            String text = selection.getText();
            boolean enabled = false;
            if (text != null) {
                enabled = this.textHasContent(text);
            }
            this.setEnabled(enabled);
        } else {
            this.setEnabled(false);
        }
    }

    protected JavaSnippetEditor getEditor() {
        return this.fEditor;
    }
}

