/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.EvaluationManager;
import org.eclipse.jdt.debug.eval.IClassFileEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ISnippetStateChangedListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SelectImportsAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ShowInPackageViewAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.StopAction;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class JavaSnippetEditor
extends AbstractTextEditor
implements IDebugEventFilter,
IEvaluationListener,
IValueDetailListener {
    public static final String IMPORTS_CONTEXT = "SnippetEditor.imports";
    public static final int RESULT_DISPLAY = 1;
    public static final int RESULT_RUN = 2;
    public static final int RESULT_INSPECT = 3;
    private int fResultMode;
    private IJavaProject fJavaProject;
    private IEvaluationContext fEvaluationContext;
    private IDebugTarget fVM;
    private String[] fLaunchedClassPath;
    private String fLaunchedWorkingDir;
    private IVMInstall fLaunchedVM;
    private List fSnippetStateListeners;
    private boolean fEvaluating;
    private IJavaThread fThread;
    private int fSnippetStart;
    private int fSnippetEnd;
    private String[] fImports = null;
    private Image fOldTitleImage = null;
    private IClassFileEvaluationEngine fEngine = null;
    private IDebugModelPresentation fPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
    private String fResult;
    static /* synthetic */ Class class$0;

    public JavaSnippetEditor() {
        this.setDocumentProvider(JDIDebugUIPlugin.getDefault().getSnippetDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JavaSnippetViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools(), this));
        this.fSnippetStateListeners = new ArrayList(4);
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setEditorContextMenuId("#JavaSnippetEditorContext");
        this.setRulerContextMenuId("#JavaSnippetRulerContext");
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        String property = this.getPage().getPersistentProperty(new QualifiedName(JDIDebugUIPlugin.getUniqueIdentifier(), IMPORTS_CONTEXT));
        if (property != null) {
            this.fImports = JavaDebugOptionsManager.parseList(property);
        }
    }

    public void dispose() {
        this.shutDownVM();
        this.fPresentation.dispose();
        this.fSnippetStateListeners = null;
        ((JDISourceViewer)this.getSourceViewer()).dispose();
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(SnippetMessages.getBundle(), "SnippetEditor.ContentAssistProposal.", (ITextEditor)this, 13);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.setAction("ShowInPackageView", (IAction)new ShowInPackageViewAction(this));
        this.setAction("Stop", (IAction)new StopAction(this));
        this.setAction("SelectImports", (IAction)new SelectImportsAction(this));
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.find", "group.search");
        this.addGroup(menu, "group.search", "group.show");
        this.addAction(menu, "group.show", "ShowInPackageView");
        this.addAction(menu, "additions", "Run");
        this.addAction(menu, "additions", "Stop");
        this.addAction(menu, "additions", "SelectImports");
    }

    protected boolean isVMLaunched() {
        return this.fVM != null;
    }

    public boolean isEvaluating() {
        return this.fEvaluating;
    }

    public void evalSelection(int resultMode) {
        if (!this.isInJavaProject()) {
            this.reportNotInJavaProjectError();
            return;
        }
        if (this.isEvaluating()) {
            return;
        }
        this.checkCurrentProject();
        this.evaluationStarts();
        this.fResultMode = resultMode;
        this.buildAndLaunch();
        if (this.fVM == null) {
            this.evaluationEnds();
            return;
        }
        this.fireEvalStateChanged();
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        String snippet = selection.getText();
        this.fSnippetStart = selection.getOffset();
        this.fSnippetEnd = this.fSnippetStart + selection.getLength();
        this.evaluate(snippet);
    }

    protected void checkCurrentProject() {
        try {
            ILaunchConfiguration config = ScrapbookLauncher.getLaunchConfigurationTemplate(this.getPage());
            if (config != null) {
                String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                IJavaProject pro = JavaCore.create((IProject)this.getPage().getProject());
                if (!pro.getElementName().equals(projectName)) {
                    ScrapbookLauncher.setLaunchConfigMemento(this.getPage(), null);
                }
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)ce.getStatus());
            this.evaluationEnds();
            return;
        }
    }

    protected void buildAndLaunch() {
        boolean launch;
        boolean build;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return;
        }
        boolean bl = build = !javaProject.getProject().getWorkspace().isAutoBuilding() || !javaProject.hasBuildState();
        if (build && !this.performIncrementalBuild()) {
            return;
        }
        boolean changed = this.classPathHasChanged();
        if (!changed) {
            changed = this.workingDirHasChanged();
        }
        if (!changed) {
            changed = this.vmHasChanged();
        }
        boolean bl2 = launch = this.fVM == null || changed;
        if (changed) {
            this.shutDownVM();
        }
        if (this.fVM == null) {
            this.checkMultipleEditors();
        }
        if (launch && this.fVM == null) {
            this.launchVM();
            this.fVM = ScrapbookLauncher.getDefault().getDebugTarget(this.getPage());
        }
    }

    protected boolean performIncrementalBuild() {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    JavaSnippetEditor.this.getJavaProject().getProject().build(10, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, r);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
            this.evaluationEnds();
            return false;
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
            this.evaluationEnds();
            return false;
        }
        return true;
    }

    protected void checkMultipleEditors() {
        this.fVM = ScrapbookLauncher.getDefault().getDebugTarget(this.getPage());
        if (this.fVM != null) {
            DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
            try {
                IThread[] threads = this.fVM.getThreads();
                int i = 0;
                while (i < threads.length) {
                    IThread iThread = threads[i];
                    if (iThread.isSuspended()) {
                        iThread.resume();
                    }
                    ++i;
                }
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
            }
        }
    }

    protected void setImports(String[] imports) {
        this.fImports = imports;
        String serialized = null;
        if (imports != null) {
            serialized = JavaDebugOptionsManager.serializeList(imports);
        }
        try {
            this.getPage().setPersistentProperty(new QualifiedName(JDIDebugUIPlugin.getUniqueIdentifier(), IMPORTS_CONTEXT), serialized);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.imports"), null, (IStatus)e.getStatus());
        }
    }

    protected String[] getImports() {
        return this.fImports;
    }

    protected IEvaluationContext getEvaluationContext() {
        IJavaProject project;
        if (this.fEvaluationContext == null && (project = this.getJavaProject()) != null) {
            this.fEvaluationContext = project.newEvaluationContext();
        }
        if (this.fEvaluationContext != null) {
            if (this.getImports() != null) {
                this.fEvaluationContext.setImports(this.getImports());
            } else {
                this.fEvaluationContext.setImports(new String[0]);
            }
        }
        return this.fEvaluationContext;
    }

    protected IJavaProject getJavaProject() {
        if (this.fJavaProject == null) {
            try {
                this.fJavaProject = this.findJavaProject();
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e);
                this.showError(e.getStatus());
            }
        }
        return this.fJavaProject;
    }

    protected void shutDownVM() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
        IDebugTarget target = this.fVM;
        if (this.fVM != null) {
            try {
                IBreakpoint bp = ScrapbookLauncher.getDefault().getMagicBreakpoint(this.fVM);
                if (bp != null) {
                    this.fVM.breakpointRemoved(bp, null);
                }
                if (this.getThread() != null) {
                    this.getThread().resume();
                }
                this.fVM.terminate();
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.shutdown"), null, (IStatus)e.getStatus());
                return;
            }
            this.vmTerminated();
            ScrapbookLauncher.getDefault().cleanup(target);
        }
    }

    protected void vmTerminated() {
        this.fVM = null;
        this.fThread = null;
        this.fEvaluationContext = null;
        this.fLaunchedClassPath = null;
        if (this.fEngine != null) {
            this.fEngine.dispose();
        }
        this.fEngine = null;
        this.fireEvalStateChanged();
    }

    public void addSnippetStateChangedListener(ISnippetStateChangedListener listener) {
        if (this.fSnippetStateListeners != null && !this.fSnippetStateListeners.contains(listener)) {
            this.fSnippetStateListeners.add(listener);
        }
    }

    public void removeSnippetStateChangedListener(ISnippetStateChangedListener listener) {
        if (this.fSnippetStateListeners != null) {
            this.fSnippetStateListeners.remove(listener);
        }
    }

    protected void fireEvalStateChanged() {
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = JavaSnippetEditor.this.getShell();
                if (JavaSnippetEditor.this.fSnippetStateListeners != null && shell != null && !shell.isDisposed()) {
                    ArrayList v = new ArrayList(JavaSnippetEditor.this.fSnippetStateListeners);
                    int i = 0;
                    while (i < v.size()) {
                        ISnippetStateChangedListener l = (ISnippetStateChangedListener)v.get(i);
                        l.snippetStateChanged(JavaSnippetEditor.this);
                        ++i;
                    }
                }
            }
        };
        Shell shell = this.getShell();
        if (shell != null) {
            this.getShell().getDisplay().asyncExec(r);
        }
    }

    protected void evaluate(String snippet) {
        if (this.getThread() == null) {
            WaitThread eThread = new WaitThread(Display.getCurrent(), (Object)this);
            eThread.start();
            eThread.block();
        }
        if (this.getThread() == null) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, SnippetMessages.getString("SnippetEditor.error.nocontext"), null);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)status);
            this.evaluationEnds();
            return;
        }
        try {
            this.getEvaluationEngine().evaluate(snippet, this.getThread(), (IEvaluationListener)this, true);
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)e.getStatus());
            this.evaluationEnds();
        }
    }

    public void evaluationComplete(IEvaluationResult result) {
        IJavaValue value;
        boolean severeErrors = false;
        if (result.hasErrors()) {
            String[] errors = result.getErrorMessages();
            boolean bl = severeErrors = errors.length > 0;
            if (result.getException() != null) {
                this.showException(result.getException());
            }
            this.showAllErrors(errors);
        }
        if ((value = result.getValue()) != null && !severeErrors) {
            switch (this.fResultMode) {
                case 1: {
                    this.displayResult(value);
                    break;
                }
                case 3: {
                    String snippet = result.getSnippet().trim();
                    int snippetLength = snippet.length();
                    if (snippetLength > 30) {
                        snippet = String.valueOf(snippet.substring(0, 15)) + SnippetMessages.getString("SnippetEditor.ellipsis") + snippet.substring(snippetLength - 15, snippetLength);
                    }
                    snippet = snippet.replace('\n', ' ');
                    snippet = snippet.replace('\r', ' ');
                    snippet = snippet.replace('\t', ' ');
                    this.showExpressionView();
                    JavaInspectExpression exp = new JavaInspectExpression(snippet, value);
                    DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)exp);
                    break;
                }
            }
        }
        this.evaluationEnds();
    }

    protected void showExpressionView() {
        Runnable r = new Runnable(){

            public void run() {
                IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
                if (page != null) {
                    IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
                    if (part == null) {
                        try {
                            page.showView("org.eclipse.debug.ui.ExpressionView");
                        }
                        catch (PartInitException e) {
                            JDIDebugUIPlugin.log(e);
                            JavaSnippetEditor.this.showError(e.getStatus());
                        }
                    } else {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
            }
        };
        this.async(r);
    }

    protected void codeComplete(ICompletionRequestor requestor) throws JavaModelException {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int start = selection.getOffset();
        String snippet = this.getSourceViewer().getDocument().get();
        IEvaluationContext e = this.getEvaluationContext();
        if (e != null) {
            e.codeComplete(snippet, start, requestor);
        }
    }

    protected IJavaElement[] codeResolve() throws JavaModelException {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int start = selection.getOffset();
        int len = selection.getLength();
        String snippet = viewer.getDocument().get();
        IEvaluationContext e = this.getEvaluationContext();
        if (e != null) {
            return e.codeSelect(snippet, start, len);
        }
        return null;
    }

    protected void showError(IStatus status) {
        this.evaluationEnds();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating2"), null, (IStatus)status);
        }
    }

    protected void showError(String message) {
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, message, null);
        this.showError((IStatus)status);
    }

    protected void displayResult(IJavaValue result) {
        StringBuffer resultString = new StringBuffer();
        try {
            IJavaType type = result.getJavaType();
            if (type != null) {
                String sig = type.getSignature();
                if ("V".equals(sig)) {
                    resultString.append(SnippetMessages.getString("SnippetEditor.noreturnvalue"));
                } else {
                    if (sig != null) {
                        resultString.append(SnippetMessages.getFormattedString("SnippetEditor.typename", result.getReferenceTypeName()));
                    } else {
                        resultString.append(" ");
                    }
                    resultString.append(this.evaluateToString(result));
                }
            } else {
                resultString.append(result.getValueString());
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.toString"), null, (IStatus)e.getStatus());
        }
        this.showAndSelect(resultString.toString(), this.fSnippetEnd);
    }

    protected synchronized String evaluateToString(IJavaValue value) {
        this.fResult = null;
        this.fPresentation.computeDetail((IValue)value, (IValueDetailListener)this);
        if (this.fResult == null) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                return SnippetMessages.getString("SnippetEditor.error.interrupted");
            }
        }
        return this.fResult;
    }

    public synchronized void detailComputed(IValue value, String result) {
        this.fResult = result;
        ((Object)((Object)this)).notifyAll();
    }

    protected void showAllErrors(final String[] errors) {
        if (errors.length > 0) {
            Runnable r = new Runnable(){

                public void run() {
                    IDocument document = JavaSnippetEditor.this.getSourceViewer().getDocument();
                    String delimiter = document.getLegalLineDelimiters()[0];
                    int insertionPoint = JavaSnippetEditor.this.fSnippetStart;
                    try {
                        insertionPoint = document.getLineOffset(document.getLineOfOffset(JavaSnippetEditor.this.fSnippetStart));
                    }
                    catch (BadLocationException ble) {
                        JDIDebugUIPlugin.log(ble);
                    }
                    int firstInsertionPoint = insertionPoint;
                    int i = 0;
                    while (i < errors.length) {
                        String error = errors[i];
                        String message = String.valueOf(error) + delimiter;
                        try {
                            document.replace(insertionPoint, 0, message);
                        }
                        catch (BadLocationException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                        insertionPoint += message.length();
                        ++i;
                    }
                    JavaSnippetEditor.this.selectAndReveal(firstInsertionPoint, insertionPoint - firstInsertionPoint);
                    JavaSnippetEditor.this.fSnippetStart = insertionPoint;
                }
            };
            this.async(r);
        }
    }

    protected void showException(Throwable exception) {
        DebugException de;
        Throwable t;
        if (exception instanceof DebugException && (t = (de = (DebugException)exception).getStatus().getException()) != null) {
            this.showUnderlyingException(t);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos, true);
        exception.printStackTrace(ps);
        this.showAndSelect(bos.toString(), this.fSnippetEnd);
    }

    protected void showUnderlyingException(Throwable t) {
        if (t instanceof InvocationException) {
            InvocationException ie = (InvocationException)t;
            ObjectReference ref = ie.exception();
            String eName = ref.referenceType().name();
            String message = SnippetMessages.getFormattedString("SnippetEditor.exception", eName);
            this.showAndSelect(message, this.fSnippetEnd);
        } else {
            this.showException(t);
        }
    }

    protected IJavaProject findJavaProject() throws JavaModelException {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput file = (IFileEditorInput)input;
            IProject p = file.getFile().getProject();
            try {
                if (p.getNature("org.eclipse.jdt.core.javanature") != null) {
                    return JavaCore.create((IProject)p);
                }
            }
            catch (CoreException ce) {
                throw new JavaModelException(ce);
            }
        }
        return null;
    }

    protected boolean classPathHasChanged() {
        String[] classpath = this.getClassPath(this.getJavaProject());
        if (this.fLaunchedClassPath != null && !this.classPathsEqual(this.fLaunchedClassPath, classpath)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.warning"), (String)SnippetMessages.getString("SnippetEditor.warning.cpchange"));
            return true;
        }
        return false;
    }

    protected boolean workingDirHasChanged() {
        String wd = this.getWorkingDirectoryAttribute();
        boolean changed = false;
        if (wd == null || this.fLaunchedWorkingDir == null) {
            if (wd != this.fLaunchedWorkingDir) {
                changed = true;
            }
        } else if (!wd.equals(this.fLaunchedWorkingDir)) {
            changed = true;
        }
        if (changed && this.fVM != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.Warning_1"), (String)SnippetMessages.getString("SnippetEditor.The_working_directory_has_changed._Restarting_the_evaluation_context._2"));
        }
        return changed;
    }

    protected boolean vmHasChanged() {
        IVMInstall vm = this.getVMInstall();
        boolean changed = false;
        if (vm == null || this.fLaunchedVM == null) {
            if (vm != this.fLaunchedVM) {
                changed = true;
            }
        } else if (!vm.equals(this.fLaunchedVM)) {
            changed = true;
        }
        if (changed && this.fVM != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.Warning_1"), (String)SnippetMessages.getString("SnippetEditor.The_JRE_has_changed._Restarting_the_evaluation_context._2"));
        }
        return changed;
    }

    protected boolean classPathsEqual(String[] path1, String[] path2) {
        if (path1.length != path2.length) {
            return false;
        }
        int i = 0;
        while (i < path1.length) {
            if (!path1[i].equals(path2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected synchronized void evaluationStarts() {
        if (this.fThread != null) {
            try {
                IJavaThread thread = this.fThread;
                this.fThread = null;
                thread.resume();
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                this.showException(e);
                return;
            }
        }
        this.fEvaluating = true;
        this.setTitleImage();
        this.fireEvalStateChanged();
        this.showStatus(SnippetMessages.getString("SnippetEditor.evaluating"));
        this.getSourceViewer().setEditable(false);
    }

    protected void setTitleImage() {
        Image image = null;
        if (this.fEvaluating) {
            this.fOldTitleImage = this.getTitleImage();
            image = JavaDebugImages.get("org.eclipse.jdt.debug.ui.jsbook_run_obj.gif");
        } else {
            image = this.fOldTitleImage;
            this.fOldTitleImage = null;
        }
        if (image != null) {
            this.setTitleImage(image);
        }
    }

    protected void evaluationEnds() {
        Runnable r = new Runnable(){

            public void run() {
                JavaSnippetEditor.this.fEvaluating = false;
                JavaSnippetEditor.this.setTitleImage();
                JavaSnippetEditor.this.fireEvalStateChanged();
                JavaSnippetEditor.this.showStatus("");
                JavaSnippetEditor.this.getSourceViewer().setEditable(true);
            }
        };
        this.async(r);
    }

    protected void showStatus(String message) {
        IEditorSite site = (IEditorSite)this.getSite();
        EditorActionBarContributor contributor = (EditorActionBarContributor)site.getActionBarContributor();
        contributor.getActionBars().getStatusLineManager().setMessage(message);
    }

    protected String[] getClassPath(IJavaProject project) {
        try {
            return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return new String[0];
        }
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent e = events[i];
            Object source = e.getSource();
            if (source instanceof IDebugElement) {
                IDebugElement de = (IDebugElement)source;
                if (de instanceof IDebugTarget) {
                    if (de.getDebugTarget().equals(this.fVM) && e.getKind() == 8) {
                        this.setThread(null);
                        Runnable r = new Runnable(){

                            public void run() {
                                JavaSnippetEditor.this.vmTerminated();
                            }
                        };
                        this.getShell().getDisplay().asyncExec(r);
                    }
                } else if (de instanceof IJavaThread && e.getKind() == 2) {
                    IJavaThread jt = (IJavaThread)de;
                    try {
                        if (jt.equals(this.getThread()) && e.getDetail() == 64) {
                            return null;
                        }
                        IJavaStackFrame f = (IJavaStackFrame)jt.getTopStackFrame();
                        if (f != null) {
                            IBreakpoint[] bps = jt.getBreakpoints();
                            if (e.getDetail() == 8 && f.getLineNumber() == 20 && f.getDeclaringTypeName().equals("org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain1") && jt.getDebugTarget() == this.fVM) {
                                this.setThread(jt);
                                return null;
                            }
                            if (e.getDetail() == 16 && bps.length > 0 && bps[0].equals(ScrapbookLauncher.getDefault().getMagicBreakpoint(jt.getDebugTarget()))) {
                                IStackFrame[] frames = jt.getStackFrames();
                                int j = 0;
                                while (j < frames.length) {
                                    IJavaStackFrame frame = (IJavaStackFrame)frames[j];
                                    if (frame.getReceivingTypeName().equals("org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain1") && frame.getName().equals("eval")) {
                                        frame.stepOver();
                                        return null;
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    catch (DebugException ex) {
                        JDIDebugUIPlugin.log(ex);
                    }
                }
            }
            ++i;
        }
        return events;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.affectsBehavior(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        JDISourceViewer isv = (JDISourceViewer)this.getSourceViewer();
        if (isv != null) {
            IContentAssistant assistant = isv.getContentAssistant();
            if (assistant instanceof ContentAssistant) {
                JDIContentAssistPreference.changeConfiguration((ContentAssistant)assistant, event);
            }
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected IJavaThread getThread() {
        return this.fThread;
    }

    protected synchronized void setThread(IJavaThread thread) {
        this.fThread = thread;
        ((Object)((Object)this)).notifyAll();
    }

    protected void launchVM() {
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        this.fLaunchedClassPath = this.getClassPath(this.getJavaProject());
        this.fLaunchedWorkingDir = this.getWorkingDirectoryAttribute();
        this.fLaunchedVM = this.getVMInstall();
        Runnable r = new Runnable(){

            public void run() {
                ScrapbookLauncher.getDefault().launch(JavaSnippetEditor.this.getPage());
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    protected IFile getPage() {
        return ((FileEditorInput)this.getEditorInput()).getFile();
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        this.fireEvalStateChanged();
    }

    protected void setTitle(String title) {
        this.cleanupOnRenameOrMove();
        super.setTitle(title);
    }

    protected void cleanupOnRenameOrMove() {
        if (this.isVMLaunched()) {
            this.shutDownVM();
        } else {
            this.fThread = null;
            this.fEvaluationContext = null;
            this.fLaunchedClassPath = null;
            if (this.fEngine != null) {
                this.fEngine.dispose();
                this.fEngine = null;
            }
        }
        this.fJavaProject = null;
    }

    protected boolean isInJavaProject() {
        try {
            return this.findJavaProject() != null;
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log(jme);
            return false;
        }
    }

    protected void reportNotInJavaProjectError() {
        String projectName = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput file = (IFileEditorInput)input;
            IProject p = file.getFile().getProject();
            projectName = p.getName();
        }
        String message = "";
        if (projectName != null) {
            message = String.valueOf(projectName) + SnippetMessages.getString("JavaSnippetEditor._is_not_a_Java_Project._n_1");
        }
        this.showError(String.valueOf(message) + SnippetMessages.getString("JavaSnippetEditor.Unable_to_perform_evaluation_outside_of_a_Java_Project_2"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Shell shell = this.getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(path);
        FileEditorInput newInput = new FileEditorInput(file);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
            private final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            public void execute(IProgressMonitor monitor) throws CoreException {
                IDocumentProvider dp = JavaSnippetEditor.this.getDocumentProvider();
                dp.saveDocument(monitor, (Object)this.val$newInput, dp.getDocument((Object)JavaSnippetEditor.this.getEditorInput()), true);
            }
        };
        boolean success = false;
        try {
            try {
                this.getDocumentProvider().aboutToChange((Object)newInput);
                new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                success = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                JDIDebugUIPlugin.log(x);
                String title = SnippetMessages.getString("JavaSnippetEditor.Problems_During_Save_As..._3");
                String msg = String.valueOf(SnippetMessages.getString("JavaSnippetEditor.Save_could_not_be_completed.__4")) + x.getTargetException().getMessage();
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.getDocumentProvider().changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.getDocumentProvider().changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected IClassFileEvaluationEngine getEvaluationEngine() {
        if (this.fEngine == null) {
            IPath outputLocation = this.getJavaProject().getProject().getPluginWorkingLocation(JDIDebugUIPlugin.getDefault().getDescriptor());
            File f = new File(outputLocation.toOSString());
            this.fEngine = EvaluationManager.newClassFileEvaluationEngine((IJavaProject)this.getJavaProject(), (IJavaDebugTarget)((IJavaDebugTarget)this.getThread().getDebugTarget()), (File)f);
        }
        if (this.getImports() != null) {
            this.fEngine.setImports(this.getImports());
        } else {
            this.fEngine.setImports(new String[0]);
        }
        return this.fEngine;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new JDISourceViewer(parent, ruler, styles);
    }

    protected String getWorkingDirectoryAttribute() {
        try {
            return ScrapbookLauncher.getWorkingDirectoryAttribute(this.getPage());
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return null;
        }
    }

    protected IVMInstall getVMInstall() {
        try {
            return ScrapbookLauncher.getVMInstall(this.getPage());
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return null;
        }
    }

    protected void async(Runnable r) {
        Control control = this.getVerticalRuler().getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(r);
        }
    }

    protected void showAndSelect(final String text, final int offset) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    JavaSnippetEditor.this.getSourceViewer().getDocument().replace(offset, 0, text);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
                JavaSnippetEditor.this.selectAndReveal(offset, text.length());
            }
        };
        this.async(r);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.part.IShowInTargetList;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (required == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(required);
    }

    private static class WaitThread
    extends Thread {
        private Display fDisplay;
        private volatile boolean fContinueEventDispatching = true;
        private Object fLock;

        WaitThread(Display display, Object lock) {
            super("Snippet Wait Thread");
            this.fDisplay = display;
            this.fLock = lock;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    Object object = this.fLock;
                    synchronized (object) {
                        this.fLock.wait(10000L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fDisplay.syncExec(new Runnable(this){
                    final /* synthetic */ WaitThread this$1;
                    {
                        this.this$1 = waitThread;
                    }

                    public void run() {
                    }
                });
                this.fContinueEventDispatching = false;
                this.fDisplay.asyncExec(null);
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            this.fDisplay.syncExec(new /* invalid duplicate definition of identical inner class */);
            this.fContinueEventDispatching = false;
            this.fDisplay.asyncExec(null);
        }

        protected void block() {
            if (this.fDisplay == Display.getCurrent()) {
                while (this.fContinueEventDispatching) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    this.fDisplay.sleep();
                }
            }
        }
    }
}

