/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointConditionCompletionProcessor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaLineBreakpointPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BreakpointConditionEditor {
    private JDISourceViewer fViewer;
    private BreakpointConditionCompletionProcessor fCompletionProcessor;
    private boolean fIsValid;
    private String fOldValue;
    private String fErrorMessage;
    private JavaLineBreakpointPage fPage;
    private IJavaLineBreakpoint fBreakpoint;

    public BreakpointConditionEditor(Composite parent, JavaLineBreakpointPage page) {
        String condition;
        this.fPage = page;
        this.fBreakpoint = (IJavaLineBreakpoint)this.fPage.getBreakpoint();
        try {
            condition = this.fBreakpoint.getCondition();
        }
        catch (CoreException exception) {
            JDIDebugUIPlugin.log(exception);
            return;
        }
        this.fErrorMessage = PropertyPageMessages.getString("BreakpointConditionEditor.1");
        this.fOldValue = "";
        this.fViewer = new JDISourceViewer(parent, null, 2816);
        this.fViewer.setInput(parent);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return BreakpointConditionEditor.this.getCompletionProcessor();
            }
        });
        this.fViewer.setEditable(true);
        this.fViewer.setDocument((IDocument)document);
        DefaultUndoManager undoManager = new DefaultUndoManager(10);
        this.fViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.fViewer);
        this.fViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.fViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener((IUndoManager)undoManager){
            private final /* synthetic */ IUndoManager val$undoManager;
            {
                this.val$undoManager = iUndoManager;
            }

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144) {
                    if (event.keyCode == 32) {
                        BreakpointConditionEditor.this.fViewer.doOperation(13);
                        event.doit = false;
                    } else if (event.keyCode == 122) {
                        this.val$undoManager.undo();
                        event.doit = false;
                    }
                }
            }
        });
        this.fViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                BreakpointConditionEditor.this.valueChanged();
            }
        });
        IType type = BreakpointUtils.getType((IJavaBreakpoint)this.fBreakpoint);
        if (type != null) {
            try {
                this.getCompletionProcessor().setType(type);
                String source = null;
                ICompilationUnit compilationUnit = type.getCompilationUnit();
                if (compilationUnit != null) {
                    source = compilationUnit.getSource();
                } else {
                    IClassFile classFile = type.getClassFile();
                    if (classFile != null) {
                        source = classFile.getSource();
                    }
                }
                int lineNumber = this.fBreakpoint.getMarker().getAttribute("lineNumber", -1);
                int position = -1;
                if (source != null && lineNumber != -1) {
                    try {
                        position = new Document(source).getLineOffset(lineNumber - 1);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                this.getCompletionProcessor().setPosition(position);
            }
            catch (CoreException coreException) {}
        }
        gd = (GridData)this.fViewer.getControl().getLayoutData();
        gd.heightHint = this.fPage.convertHeightInCharsToPixels(10);
        gd.widthHint = this.fPage.convertWidthInCharsToPixels(40);
        document.set(condition);
        this.valueChanged();
    }

    public String getCondition() {
        return this.fViewer.getDocument().get();
    }

    protected void refreshValidState() {
        if (!this.fViewer.isEditable()) {
            this.fPage.removeErrorMessage(this.fErrorMessage);
            this.fIsValid = true;
        } else {
            String text = this.fViewer.getDocument().get();
            boolean bl = this.fIsValid = text != null && text.trim().length() > 0;
            if (!this.fIsValid) {
                this.fPage.addErrorMessage(this.fErrorMessage);
            } else {
                this.fPage.removeErrorMessage(this.fErrorMessage);
            }
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.fViewer.getControl().getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    private BreakpointConditionCompletionProcessor getCompletionProcessor() {
        if (this.fCompletionProcessor == null) {
            this.fCompletionProcessor = new BreakpointConditionCompletionProcessor(null);
        }
        return this.fCompletionProcessor;
    }

    public void setEnabled(boolean enabled) {
        this.fViewer.setEditable(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            this.fViewer.getTextWidget().setFocus();
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
        }
        this.valueChanged();
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void valueChanged() {
        this.refreshValidState();
        String newValue = this.fViewer.getDocument().get();
        if (!newValue.equals(this.fOldValue)) {
            this.fOldValue = newValue;
        }
    }

    public void dispose() {
        this.fViewer.dispose();
    }
}

