/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerDescriptor;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RuntimeClasspathAdvancedDialog
extends Dialog {
    private IAction[] fActions;
    private Button[] fButtons;
    private Button fAddContainerButton;
    private Combo fContainerCombo;
    private ClasspathContainerDescriptor[] fDescriptors;
    private IClasspathViewer fViewer;

    public RuntimeClasspathAdvancedDialog(Shell parentShell, IAction[] actions, IClasspathViewer viewer) {
        super(parentShell);
        this.fActions = actions;
        this.fViewer = viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        inner.setLayoutData((Object)gd);
        Label l = new Label(inner, 0);
        l.setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Select_an_advanced_option__1"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        l.setFont(font);
        this.fButtons = new Button[this.fActions.length];
        int i = 0;
        while (i < this.fActions.length) {
            IAction action = this.fActions[i];
            this.fButtons[i] = new Button(inner, 16);
            this.fButtons[i].setText(action.getText());
            this.fButtons[i].setData((Object)action);
            this.fButtons[i].setEnabled(action.isEnabled());
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.fButtons[i].setLayoutData((Object)gd);
            this.fButtons[i].setFont(font);
            ++i;
        }
        this.fAddContainerButton = new Button(inner, 16);
        this.fAddContainerButton.setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Add_&Container__1"));
        this.fAddContainerButton.setFont(font);
        this.fContainerCombo = new Combo(inner, 8);
        this.fContainerCombo.setFont(font);
        this.fDescriptors = ClasspathContainerDescriptor.getDescriptors();
        String[] names = new String[this.fDescriptors.length];
        int maxLength = 0;
        int i2 = 0;
        while (i2 < names.length) {
            names[i2] = this.fDescriptors[i2].getName();
            int length = names[i2].length();
            if (length > maxLength) {
                maxLength = length;
            }
            ++i2;
        }
        this.fContainerCombo.setItems(names);
        this.fContainerCombo.select(0);
        this.fContainerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int i = 0;
                while (i < RuntimeClasspathAdvancedDialog.this.fButtons.length) {
                    RuntimeClasspathAdvancedDialog.this.fButtons[i].setSelection(false);
                    ++i;
                }
                RuntimeClasspathAdvancedDialog.this.fAddContainerButton.setSelection(true);
            }
        });
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(maxLength + 5);
        this.fContainerCombo.setLayoutData((Object)gd);
        new Label(inner, 0);
        this.getShell().setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Advanced_Options_1"));
        return composite;
    }

    protected void okPressed() {
        if (this.fAddContainerButton.getSelection()) {
            int pos;
            int index = this.fContainerCombo.getSelectionIndex();
            IRuntimeClasspathEntry entry = this.chooseContainerEntry(this.fDescriptors[index]);
            if (entry != null && (pos = this.fViewer.indexOf(entry)) == -1) {
                this.fViewer.addEntries(new IRuntimeClasspathEntry[]{entry});
            }
        } else {
            int i = 0;
            while (i < this.fButtons.length) {
                if (this.fButtons[i].getSelection()) {
                    IAction action = (IAction)this.fButtons[i].getData();
                    if (action instanceof RuntimeClasspathAction) {
                        ((RuntimeClasspathAction)action).setShell(this.getShell());
                    }
                    action.run();
                    break;
                }
                ++i;
            }
        }
        super.okPressed();
    }

    private IRuntimeClasspathEntry chooseContainerEntry(ClasspathContainerDescriptor desc) {
        IClasspathEntry created;
        IRuntimeClasspathEntry[] currentEntries = this.fViewer.getEntries();
        IClasspathEntry[] entries = new IClasspathEntry[currentEntries.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = currentEntries[i].getClasspathEntry();
            ++i;
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard(desc, null, entries);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(this.convertWidthInCharsToPixels(40), this.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.getShell().setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Select_Container_2"));
        if (dialog.open() == 0 && (created = wizard.getNewEntry()) != null) {
            try {
                return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)created.getPath(), (int)1);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Unable_to_create_new_entry._3"), e);
            }
        }
        return null;
    }
}

